<?php

namespace App\Helpers;

use Exception;
use PHPMailer\PHPMailer\PHPMailer;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

class AppHelpers
{

    public static function sendResponse($data = false, $msg = null, $status_code = 401)
    {
        return response()->json(['message' => $msg, 'result' => $data], $status_code);
    }

    public static function sendMail($sub, $viewBody, $receiver_email, $sender_email)
    {
        $mail = new PHPMailer();
        try {
            info('test 1');
            $mail->SMTPDebug = 0;
            $mail->SMTPAuth = true;
            $mail->SMTPSecure = 'ssl';
            $mail->Port = env('SMTP_PORT');
            $mail->Host = env('SMTP_HOST');
            $mail->Username = env('SMTP_USERNAME');
            $mail->Password = env('SMTP_PASSWORD');
            $mail->setFrom($sender_email, env('FROM_NAME'));
            $mail->addAddress($receiver_email);
            $mail->AddCC('developers.techmetsolutions@gmail.com');
            $mail->Subject = $sub;
            $mail->AltBody = $viewBody;
            $mail->MsgHTML($viewBody);
            $mail->isHTML(true);
            $mail->send();
        } catch (Exception $e) {
            info($sub);
            info($e);
        }
    }

    public static function SendNotification($quot_id, $title, $contact)
    {
        info($quot_id . 'Quotation id' . $title . 'Title' . $contact . 'Contact Number');

        // For IPL
        $notification = array('quotation Id' => $quot_id, 'title' => $title, 'body' => $contact);

        // For General
        // $notification = array('title' => $title, 'body' => $body, 'sound' => 'ipl');
        // if ($isTopic) {
        //     $arrayToSend = array('to' => "/topics/" . $token, 'notification' => $notification, 'priority' => 'high');
        //     // TODO: Check When in Production
        //     AdminNotification::create([
        //         'title' => $title,
        //         'body' => $body,
        //     ]);
        // } else {
        //     $arrayToSend = array('to' => $token, 'notification' => $notification, 'priority' => 'high');
        //     CustNotification::create([
        //         'cust_id' => $cust_id,
        //         'title' => $title,
        //         'description' => $body,
        //     ]);
        // }


        // if ($token != "") {
        //     $curl = curl_init();
        //     curl_setopt_array($curl, [
        //         CURLOPT_URL => "https://fcm.googleapis.com/fcm/send",
        //         CURLOPT_RETURNTRANSFER => true,
        //         CURLOPT_CUSTOMREQUEST => "POST",
        //         CURLOPT_POSTFIELDS => json_encode($arrayToSend),
        //         CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'Authorization: key=' . env('FCM_SERVER_KEY')],
        //     ]);
        //     $response = curl_exec($curl);
        //     if ($response === false) {
        //         die('FCM Send Error: ' . curl_error($curl));
        //     }
        //     curl_close($curl);
        // }

        $curl = curl_init();

        // curl_setopt_array($curl, array(
        //     CURLOPT_URL => 'https://2factor.in/API/V1/51265aa2-7f52-11ed-9158-0200cd936042/SMS/+918888221323/AUTOGEN/OTP1',
        //     CURLOPT_RETURNTRANSFER => true,
        //     CURLOPT_ENCODING => '',
        //     CURLOPT_MAXREDIRS => 10,
        //     CURLOPT_TIMEOUT => 0,
        //     CURLOPT_FOLLOWLOCATION => true,
        //     CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        //     CURLOPT_CUSTOMREQUEST => 'POST',
        // ));
        $arrayToSend = array('notification' => $notification, 'priority' => 'high');
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://2factor.in/API/R1/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($arrayToSend),
            CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'Authorization: key=' . env('51265aa2-7f52-11ed-9158-0200cd936042')],
        ));

        $response = curl_exec($curl);
        // if ($response === false) {
        //     die('FCM Send Error: ' . curl_error($curl));
        // }

        curl_close($curl);
        echo $response;
        info($response);
    }

    public static function uploadImage($image, $path)
    {
        $image_name = time() . '.' . $image->getClientOriginalExtension();
        $image->move(public_path($path), $image_name);
        return $image_name;
    }
}
