<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuotationPayment extends Model
{
    use HasFactory;
    public $table = 'quotation_payment';
    public $fillable = ['quotation_id', 'payment_type', 'amount', 'payment_date', 'remark'];

    public function userData()
    {
        return $this->belongsTo(Quotation::class, 'user_id')->sum('sub_amt');
    }

    public function paymentData()
    {
        return $this->belongsTo(QuotationItems::class, 'quotation_id')->get();
    }
}
