<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css"
        integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">

    <title>Delivery Challan</title>
</head>
<style>
    .container {
        width: 1000px;
    }

    .wrapper {
        width: 100%;
        border: 1px solid #000;
        margin: 10px 0;

        .row {
            border-bottom: 1px solid #000;

            .border-right {
                border-right: 1px solid #000;
            }
        }

        .no-border {
            border-bottom: 0;
        }
    }

    .margin-0 {
        margin: 0;
    }

    .padding-0 {
        padding: 0;
    }

    img {
        height: 104px;
        width: 200px;
    }

    .table {
        width: 100%;
        margin: 0;

        >tbody>tr {
            >td {
                border: 1px solid #000;
                padding: 5px 0 5px 10px;
                width: 50%;
            }

            .first {
                border-top: 0;
            }

            .last {
                border-bottom: 0;
            }

            b {
                display: block;
            }

            span {
                font-size: 12px;
            }
        }
    }

    .invoice-bill {
        width: 100%;

        td {
            border: 1px solid #000;
            padding: 5px;
        }

        .serial-no {
            width: 70px;
        }

        .particulars {
            width: 500px;
        }

        .amount {
            width: 150px;
        }

        .particular-items {
            padding: 5px 10px;
        }

        .amount-items {
            padding: 5px 0;
        }
    }

    .entry-id {
        margin: 35px 0;
    }

    .bank-details {
        margin-top: 30px;
    }

    .authorised-sign-wrapper {
        width: 300px;
        border: 1px solid #000;
        padding: 5px 20px;
    }

    .logo {
        margin-top: 40px;
        margin-left: 30px;
    }

    .pri {
        margin-left: 590px;
        margin-top: -34px;
    }

    .tablecontainer {
        width: 99%;
        margin-left: 4px;
        margin-top: 6px;
    }
</style>

<body>
    <div class="container">
        <div class="wrapper">
            <div class="row">
                <div class="col-sm-12">
                    <div class="text-center mt-4">
                        <h2>Delivery Challan</h2>
                        <p class="pri"><a href="" onclick="window.print();" class="text-end">Print</a></p>
                    </div>
                </div>
            </div>
            <div class="tablecontainer">
                <div class="row mt-3">
                    <div class="col-sm-7">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">THE CERAMIC STUDIO</h5>
                                <p class="card-text">Shop no. 18, Business Bay<br>
                                    Shree Hari Kute Marg<br>
                                    Tidke Colony, Mumbai Naka<br>
                                    Nashik - 422002<br>
                                    CONT.: 8847788888, 7058859999<br>
                                    Email: support@theceramicstudio.in<br></p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="col-sm-5 logo">
                            <img src="../assets/tcs_logo.png" alt="logo">
                        </div>
                    </div>
                </div>
            </div>
            <div class="tablecontainer">
                <div class="row">
                    <div class="col-sm-12">
                        @foreach ($quotations as $data)
                            <table class="table table-bordered">
                                <tbody>
                                    <tr style="1px solid black">
                                        <th style="border:1px solid black;">To,
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $data->client_name }}
                                        </th>
                                        <th style="border:1px solid black;">Mobile No
                                            :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $data->contact }}</th>
                                        <th td colspan="3" style="border:1px solid black;"> Challan No
                                            :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $data->id }} </th>
                                    </tr>
                                    <tr>
                                        <th style="border:1px solid black;">Delivery&nbsp;Boy&nbsp;Name :
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $data->del_boy_name }}</th>
                                        <th style="border:1px solid black;">Contact
                                            :&nbsp;&nbsp;{{ $data->del_boy_contact }}
                                        </th>
                                        <th colspan="3" style="border:1px solid black;">Date
                                            :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $data->created_at }}
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="border:1px solid black;">Architect&nbsp;Name :
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $data->architect }}</th>
                                        <th style="border:1px solid black;">Contact
                                            :&nbsp;&nbsp;{{ $data->architect_contact }}
                                        </th>
                                        <th colspan="3" style="border:1px solid black;"> GST No
                                            :&nbsp;&nbsp;&nbsp;&nbsp;ABCD12345785
                                        </th>
                                    </tr>
                                    <tr>
                                        <th colspan="2" style="border:1px solid black;">Weight Of Goods : <span
                                                id="totalWeight"></span>&nbsp;&nbsp;Tons
                                        </th>

                                    </tr>
                                </tbody>
                            </table>
                    </div>
                </div>
            </div>
            <div class="tablecontainer">
                <table class="table table-bordered">
                    <thead class="thead-dark">
                        <tr>
                            <th style="border:1px solid black;">DC&nbsp;No</th>
                            <th style="border:1px solid black;">Description&nbsp;of&nbsp;Goods</th>
                            <th style="border:1px solid black;">Size</th>
                            <th style="border:1px solid black;">Weight</th>
                            <th style="border:1px solid black;">Qty</th>
                            <th style="border:1px solid black;">Rate</th>
                            <th style="border:1px solid black;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $tot_weight = 0;
                            $grandtotal = 0;
                            $count = 0;
                        @endphp
                        @foreach ($quotationItems as $value)
                            @php
                                $count++;
                                $cov = $value->coverage;
                                $totbox = $value->unit_send != null ? $value->unit_send : $value->box;
                                $calculate = round((float) $cov * (float) $totbox * (float) $value->rate);
                                $percent = ((float) $calculate * (float) $value->discount) / 100;

                                $p_name = '';
                            @endphp
                            @foreach ($products as $prod)
                                @if ($prod->id == $value->product_id)
                                    @php
                                        $p_name = $prod->p_name;
                                    @endphp
                                @endif
                            @endforeach
                            <tr>
                                <td style="border:1px solid black;">{{ $count }}</td>
                                <td style="border:1px solid black;">{{ $p_name }}</td>
                                <td style="border:1px solid black;">{{ $value->size }}</td>
                                <td style="border:1px solid black;">{{ $value->total_weight }}</td>
                                @php
                                    $tot_weight += $value->total_weight;
                                    $grandtotal += $calculate - $percent;
                                @endphp
                                <td style="border:1px solid black;">
                                    {{ $value->unit_send != null ? $value->unit_send : $value->box }}</td>
                                <td style="border:1px solid black;">{{ $value->rate }}</td>
                                <td style="border:1px solid black;">
                                    {{ $calculate - $percent }}</td>
                            </tr>
                        @endforeach
                        <tr>
                            <th class="thead-dark text-center" colspan="6" style="border:1px solid black;">
                                Total</th>
                            <td style="border:1px solid black;">{{ $grandtotal }}</td>
                        </tr>
                        <input type="hidden" id="weightD" value="{{ $tot_weight }}">
                        <tr>
                            <th colspan="8">For NEFT or RTGS :-<br>
                                Yes Bank<br>
                                Branch:- Canada Corner<br>
                                Bank IFSC CODE:- YESB0000021<br>
                                AC. HO. Name:- THE CERAMIC STUDIO<br>
                                AC.NO. :- 002163700002424
                            </th>
                            {{-- <td colspan="2"></td> --}}
                        </tr>
                        <tr>
                            <td colspan="4">Terms :-<br>
                                All goods are delivered in good condition<br>
                                Our responsibility ceases have left our premises<br>
                                Goods once sold will not be taken back<br>
                                No complaint regarding rates will be entertained<br>
                                Interest @24% per annum will be charged, if bill not paid within 33 days
                            </td>
                            <td colspan="3"><br><br><br><br><br>for, Viraj Ceramics</td>
                        </tr>
                        <tr rowspan="2">
                            <th colspan="4">Tempo No :&nbsp;&nbsp;&nbsp;&nbsp;{{ $data->tempo_no }} </th>
                            <td colspan="3"><br>Receivers Signature</td>
                        </tr>
                    </tbody>
                    @endforeach
                </table>
            </div>
        </div>
        <script>
            let p = document.getElementById('weightD').value;
            document.getElementById('totalWeight').innerHTML = p / 1000;
        </script>
        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"
            integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous">
        </script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.7/dist/umd/popper.min.js"
            integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous">
        </script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/js/bootstrap.min.js"
            integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous">
        </script>
</body>

</html>
