@extends ('admin.layouts.master')
@section('content')
    <div class="container pt-4 px-4 mb-5">
        <div class="bg-light rounded p-4">
            <x-session-message />
            <form action="{{ route('updatePurchaseData') }}" method="POST">
                @csrf
                <div class="row">
                    @foreach ($purchaseData as $pdata)
                        <div class="bg-light rounded p-4">
                            <h6 class="mb-4">Update Delivery Challan</h6>
                            <input type="hidden" id="purchase_id" name="purchase_id" value="{{ $pdata->id }}">
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Purchase Date</label>
                                <div class="col-md-10">
                                    <input type="date" class="form-control" name="purchase_date"
                                        value="{{ $pdata->purchase_date }}">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Challan&nbsp;No</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="bill_no" value="{{ $pdata->bill_no }}">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Client Name :</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="client_name"
                                        value="{{ $pdata->client_name }}">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Contact No :</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="contact"
                                        value="{{ $pdata->client_contact }}" pattern="[0-9]{10}" maxlength="10">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Refer&nbsp;By</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="refer_by"
                                        value="{{ $pdata->refer_by }}">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Delivery&nbsp;Boy&nbsp;Name</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="del_boy_name"
                                        value="{{ $pdata->del_boy_name }}">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Delivery&nbsp;Boy&nbsp;Contact</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="del_boy_contact"
                                        value="{{ $pdata->del_boy_contact }}" pattern="[0-9]{10}" maxlength="10">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Tempo&nbsp;Number</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="tempo_no"
                                        value="{{ $pdata->tempo_no }}">
                                </div>
                            </div>
                        </div>
                </div>

                <div class="table-responsive">
                    <table class="table" id="dynamicTable">
                        <thead class="text-center">
                            <tr id="faqs-row">
                                <th>Bcode</th>
                                <th>Product</th>
                                <th style="width: 9%">Size</th>
                                <th style="width: 9%">Quality</th>
                                <th>Rate</th>
                                <th>Cov</th>
                                <th>BatchNo</th>
                                <th>Box</th>
                                <th>Weight</th>
                                <th>TotWgt</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
                <div class="form-group submitButtonFooter">
                    <div class="col-sm-offset-2 col-sm-10">
                        <button type="button" class="btn btn-success" onclick="addRow();" data-loading-text="Loading...">
                            <i class="glyphicon glyphicon-plus-sign"></i> Add Row
                        </button>

                        <button type="submit" id="updateManageId" data-loading-text="Loading..." class="btn btn-success"><i
                                class="glyphicon glyphicon-ok-sign"></i> Update
                            Changes</button>
                    </div>
                </div>
            </form>
            @endforeach
            &nbsp;
            <br><br><br>
        </div>
    </div>
    <script type="text/javascript">
        let products = @JSON($products);
        let qualities = @JSON($quality);
        let purchaseItems = @JSON($purchaseItems);
        var prod = 0;
        let deleteRoute = "{{ route('deleteDeliveryData') }}";

        function calculateSub() {
            let subtotal = 0;
            for (let x = 0; x <= prod; x++) {
                let current = document.getElementById(`totalbalance${x}`);
                if (current != null && current.value != "") {
                    subtotal += parseFloat(current.value);
                }
            }
            document.getElementById('subTotal').value = subtotal;
        }

        function getProdData(e) {
            let prod = e.id.replace("prod_name", "");
            let sizes = [];
            products.forEach(element => {
                if (element.p_name.toUpperCase() == e.value.toUpperCase()) {
                    sizes.push(element.p_size.toLowerCase());
                }
            });
            sizes = [...new Set(sizes)];
            let optionHtml = '<option>~SELECT~</option>';
            sizes.forEach(e => {
                optionHtml += `<option value="${e}">${e}</option>`;
            })
            document.getElementById(`productSize${prod}`).innerHTML = optionHtml;
            document.getElementById(`productQuality${prod}`).innerHTML = "<option>~SELECT~</option>";
            document.getElementById(`productrate${prod}`).value = "";
            document.getElementById(`coverage${prod}`).value = "";
            document.getElementById(`batch_no${prod}`).innerHTML = "<option>~SELECT~</option>";
            document.getElementById(`box${prod}`).value = "";
            document.getElementById(`weight${prod}`).value = "";
            document.getElementById(`totalweight${prod}`).value = "";
            document.getElementById(`totalbalance${prod}`).value = "";
            document.getElementById(`product_id${prod}`).value = "";
        }

        function getProductSizeData(p) {
            let id = p.id.replace("productSize", "");
            let productName = document.getElementById(`prod_name${id}`).value;
            let optionHtml = '<option>~SELECT~</option>';

            let currentQualities = [];

            products.forEach(prod => {
                if (prod.p_name.toUpperCase() == productName.toUpperCase() && prod.p_size.toLowerCase() == p.value
                    .toLowerCase()) {
                    let currentQuality = qualities.find(e => e.id == prod.quality_id);
                    currentQualities.push(currentQuality.quality_name);
                }
            });
            currentQualities = [...new Set(currentQualities)];
            currentQualities.forEach(e => {
                optionHtml += `<option value="${e}">${e}</option>`;
            })
            document.getElementById(`productQuality${id}`).innerHTML = optionHtml;
        }

        function getProductQty(q) {
            let prodId = q.id.replace("productQuality", "");
            let productName = document.getElementById(`prod_name${prodId}`).value;
            let size = document.getElementById(`productSize${prodId}`).value;

            let qualityId = qualities.find(e => e.quality_name == q.value).id;

            for (let index = 0; index < products.length; index++) {
                const element = products[index];
                if (element.p_name.toUpperCase() == productName.toUpperCase() && element.p_size.toLowerCase() == size
                    .toLowerCase() && element
                    .quality_id == qualityId) {
                    document.getElementById(`productrate${prodId}`).value = element.p_rate;
                    document.getElementById(`product_id${prodId}`).value = element.id;

                    batchNo = element.purchase_items.map((e) => e.batchno);
                    batchNo = [...new Set(batchNo)];
                    let optionHtmlBatch = '<option>~SELECT~</option>';
                    batchNo.forEach(e => {
                        optionHtmlBatch += `<option value="${e}">${e}</option>`;
                    })
                    document.getElementById(`batch_no${prodId}`).innerHTML = optionHtmlBatch;
                    break;
                }
            }
        }


        function calcuateTotal(prod) {
            let totalEle = document.getElementById(`totalbalance${prod}`);
            let totalWeight = document.getElementById(`totalweight${prod}`);
            let rate = document.getElementById(`productrate${prod}`);
            let coverage = document.getElementById(`coverage${prod}`);
            let qtyEle = document.getElementById(`box${prod}`);
            let weight = document.getElementById(`weight${prod}`);

            if (qtyEle.value != "" && qtyEle.value > 0 && weight.value != "" && weight.value > 0) {
                totalWeight.value = qtyEle.value * weight.value;
            }

            if (rate.value != "" && rate.value > 0 && coverage.value != "" && coverage.value > 0 && qtyEle.value != "" &&
                qtyEle.value > 0) {
                let total = rate.value * coverage.value * qtyEle.value;
                totalEle.value = total.toFixed(2);
            } else {
                totalEle.value = 0;
            }

        }

        function removeTableRow(p) {
            deliveryId = p;
            $.ajax({
                type: 'POST',
                url: `{{ route('getDeliveryData') }}`,
                data: {
                    "_token": "{{ csrf_token() }}",
                    deliveryId: deliveryId
                },
                success: function(x) {
                    console.log(x);
                    // document.getElementById('subTotal').value = x.data.total_amount;
                }
            });

        }

        function addRow(purchaseItems = null) {
            html =
                `<tr id="faqs-row${prod}">
                    <td><input type="text" id="barcode-input${prod}" name="barcode-input[]" class="form-control" readonly></td>
    <td><select class="form-control" name="prod_name[]" id="prod_name${prod}" onchange="getProdData(this);"><option value="">~SELECT~</option>`;
            let uniqueProductNames = products.map((item) => item.p_name.toUpperCase());
            uniqueProductNames = [...new Set(uniqueProductNames)];
            uniqueProductNames.forEach((element) => {
                html += `<option value="${element}">${element}</option>`;
            });
            html += `</select></td>
            <td><select class="form-control" name="productSize[]" id="productSize${prod}" onchange="getProductSizeData(this)"><option>~SELECT~</option></select></td>
             <td><select class="form-control" name="productQuality[]" id="productQuality${prod}" onchange="getProductQty(this)"><option>~SELECT~</option></select></td>
            <td><input type="text" name="productrate[]" id="productrate${prod}" class="form-control" oninput="calcuateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"></td>
            <td><input type="text" name="coverage[]" id="coverage${prod}" class="form-control" oninput="calcuateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"/></td>
            <td><select class="form-control" name="batch_no[]" id="batch_no${prod}"><option>~SELECT~</option></select>
                </td>
            <td><input type="text" name="box[]" id="box${prod}" class="form-control" oninput="calcuateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"></td>
            <td><input type="text" name="weight[]" id="weight${prod}" class="form-control" oninput="calcuateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"></td>
            <td><input type="text" name="totalweight[]" id="totalweight${prod}" class="form-control" oninput="calcuateTotal(${prod})" readonly></td>
            <td><input type="hidden" name="purchaseItemId[]" id="purchaseItemId${prod}">
                <input type="hidden" name="product_id[]" id="product_id${prod}">
                <input type="text" name="totalbalance[]" id="totalbalance${prod}" class="form-control" readonly>
                </td>
            <td style="color: red" id="removeButton${prod}"><i class="fa fa-trash" aria-hidden="true"></i></td>
            </tr>`
            $('#dynamicTable tbody').append(html);

            if (purchaseItems != null) {

                let product = products.find((item) => item.id == purchaseItems.product_id);
                document.getElementById(`prod_name${prod}`).value = product.p_name.toUpperCase();
                let sizes = [];
                let prod_code = [];
                products.forEach(element => {
                    if (element.p_name.toUpperCase() == product.p_name.toUpperCase()) {
                        sizes.push(element.p_size.toLowerCase().trim());
                        prod_code.push(element.product_code);
                    }
                });

                document.getElementById(`barcode-input${prod}`).value = prod_code;

                sizes = [...new Set(sizes)];
                let optionHtml = '<option>~SELECT~</option>';
                sizes.forEach(e => {
                    optionHtml += `<option value="${e}">${e}</option>`;
                })

                document.getElementById(`productSize${prod}`).innerHTML = optionHtml;
                document.getElementById(`productSize${prod}`).value = purchaseItems.size.toLowerCase();

                let currentQualities = [];
                products.forEach(e => {
                    if (e.p_name.toUpperCase() == product.p_name.toUpperCase() && e.p_size.toLowerCase() == product
                        .p_size.toLowerCase()) {
                        let currentQuality = qualities.find((item) => item.id == e.quality_id);
                        currentQualities.push(currentQuality.quality_name);
                    }
                });
                currentQualities = [...new Set(currentQualities)];
                optionHtml = '<option>~SELECT~</option>';
                currentQualities.forEach(e => {
                    optionHtml += `<option value="${e}">${e}</option>`;
                })

                document.getElementById(`productQuality${prod}`).innerHTML = optionHtml;
                document.getElementById(`productQuality${prod}`).value = purchaseItems.quality;

                let batchNo = [];
                products.forEach(e => {
                    if (e.p_name.toUpperCase() == product.p_name.toUpperCase() && e.p_size.toLowerCase() == product
                        .p_size.toLowerCase()) {
                        batchNo = e.purchase_items.map((e) => e.batchno);
                    }
                });
                batchNo = [...new Set(batchNo)];
                let optionHtmlBatch = '<option>~SELECT~</option>';
                batchNo.forEach(e => {
                    optionHtmlBatch += `<option value="${e}">${e}</option>`;
                })

                document.getElementById(`batch_no${prod}`).innerHTML = optionHtmlBatch;
                document.getElementById(`batch_no${prod}`).value = purchaseItems.batchno;

                document.getElementById(`productrate${prod}`).value = purchaseItems.rate;
                document.getElementById(`coverage${prod}`).value = purchaseItems.coverage;
                document.getElementById(`box${prod}`).value = purchaseItems.box;
                document.getElementById(`weight${prod}`).value = purchaseItems.weight;
                document.getElementById(`totalweight${prod}`).value = purchaseItems.total_weight;
                document.getElementById(`totalbalance${prod}`).value = purchaseItems.total;
                document.getElementById(`product_id${prod}`).value = purchaseItems.product_id;
                document.getElementById(`purchaseItemId${prod}`).value = purchaseItems.id;

                document.getElementById(`removeButton${prod}`).addEventListener("click", (e) => {
                    removeTableRow(purchaseItems.id)
                    e.target.parentNode.parentNode.remove()
                });
            } else {
                document.getElementById(`removeButton${prod}`).innerHTML = `<i class="fa fa-trash" aria-hidden="true"></i>`;
                document.getElementById(`removeButton${prod}`).addEventListener('click', function(e) {
                    if (confirm('Are you sure you want to delete this Entry?')) {
                        e.target.parentNode.parentNode.remove()
                    }
                });
            }

            prod++;
        }
        purchaseItems.forEach((element) => {
            addRow(element);
        });
    </script>
@endsection
