<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Payments</title>
</head>
<style>
    h5,
    table,
    td,
    td p {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    h2 {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        margin: 10px;
    }

    body {
        width: 100%;
        height: 100%;
        margin: 0 auto;
        font-family: "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
        font-weight: 400;
    }

    .wrapper {
        border: 1px solid #000;
        margin: 10px 0;
        padding: 0.25rem;
    }

    .delivery-challan {
        color: #212529;
        font-size: 20px;
    }

    .text-center {
        text-align: center;
    }

    .card {
        width: 80%;
        padding: 1rem;
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-radius: 0.25rem;
        text-align: left;
        font-weight: bold;
    }

    .card-title {
        color: #212529;
        font-size: 18px;
    }

    .headerDiv .logo {
        width: 40%;
        text-align: center;
    }

    .card-text {
        font-size: 12px;
        color: #212529;
        padding: 0;
    }

    .bank-details {
        padding: 8px;
        font-weight: bold;
    }

    table {
        width: 100%;
        text-align: center;
    }

    thead {
        background-color: #343a40;
        color: white;
    }

    table,
    th,
    td {
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-collapse: collapse;
        padding: 10px 0px;
    }

    .terms {
        text-align: left;
        border-radius: 0.25rem;
    }

    .terms td {
        padding: 8px;
    }



    .footer td {
        padding: 10px;
    }

    .dark-border {
        border: 1px solid rgb(0, 0, 0);
    }

    .remove-border {
        border: none;
    }
</style>

<body>
    <div class="wrapper">
        <div class="text-center delivery-challan">
            <h2>Payments</h2>
        </div>

        <table class="remove-border">
            <tr class="remove-border">
                <td class="remove-border">
                    <div class="card">
                        <span class="card-title">THE CERAMIC STUDIO</span>
                        <br>
                        <span class="card-text">Shop no. 18, Business Bay<br>
                            Shree Hari Kute Marg<br>
                            Tidke Colony, Mumbai Naka<br>
                            Nashik - 422002<br>
                            CONT.: 8847788888, 7058859999<br>
                            Email: support@theceramicstudio.in<br>
                        </span>

                    </div>
                </td>
                <td class="remove-border">
                    <img src="{{ asset('img/user.jpg') }}" alt="Logo" width="160px">
                </td>
            </tr>
        </table>
        <table>
            <tr>
                <th class="dark-border">To, {{ ucwords(strtolower($quotation->client_name)) }}</th>
                <th class="dark-border">Mobile No: {{ ucwords(strtolower($quotation->contact)) }}</th>
                <th class="dark-border">Challan No: {{ ucwords(strtolower($quotation->id)) }}</th>
            </tr>
        </table>
        <br>
        @if ($payments->count() == 0)
            <h3 class="text-center">No Payments Found</h3>
        @else
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Payment Type</th>
                        <th>Amount</th>
                        <th>Remark</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($payments as $payment)
                        <tr>
                            <td>{{ $payment->payment_date }}</td>
                            <td>{{ $payment->payment_type }}</td>
                            <td>{{ $payment->amount }}</td>
                            <td>{{ $payment->remark }}</td>
                        </tr>
                    @endforeach

                </tbody>
            </table>
        @endif
    </div>
</body>

</html>
