<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    {{-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css"
        integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous"> --}}


    <title>Barcode</title>

    <style>
        .card {
            width: 250px;
            background-color: white;
            border: 1px solid gray;
            border-radius: 10px;
            margin: 0;
            padding: 0;
        }

        .grid-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            display: flex;
        }

        .data-container-1 {
            grid-column: 1;
            display: flex;
            flex-direction: column;
            margin-top: 5px;
        }

        .data-container-2 {
            grid-column: 2;
            display: flex;
            flex-wrap: wrap;
            align-items: center;
        }

        #print {
            margin-left: 190px;
        }

        /* .template {
        width: 100mm;
        display: flex;
    }

    .row1 {
        margin: 0;
        padding: 0;
    }

    .row2 {
        display: flex;
        flex-direction: column;
        align-items: center;
        margin-left: 40px;
    } */
    </style>
</head>

<body>
    {{-- Code With Print Option --}}
    <div class="grid-container">
        <div class="data-container-2">
            @foreach ($purchaseItems as $data)
                <table style="width:100%; display: flex;">
                    <tr>
                        @foreach ($products as $value)
                            @php
                                $qr = QrCode::size(100)->generate("$value->id.Product_Name = $value->p_name . Product_Size = $value->p_size. Quantity = $value->p_quantity. Rate = $value->p_rate. $value->availability");
                            @endphp
                            @if ($value->id == $data->product_id)
                                <td>{{ $qr }}</td>
                            @endif
                        @endforeach
                    </tr>
                </table>
            @endforeach
        </div>
        <div class="data-container-1">
            @foreach ($purchaseItems as $data)
                <div class="card">
                    <span class="printData"><a
                            href="{{ route('printProductData', [$data->purchase_id, $data->product_id]) }}"
                            id="print">Print</a></span>
                    <h3 class="text-center" style="margin-left: 45px">Viraj Ceramics</h3>
                    <div class="text-center" style="margin-left: 32px">
                        {!! DNS1D::getBarcodeSVG($data->product_code, 'C39', 1, 60) !!}
                    </div>
                    <div class="card-body" style="margin-left: 50px">
                        <table>
                            <tr>
                                <th>Product</th>
                                @foreach ($products as $prod)
                                    @if ($prod->id == $data->product_id)
                                        <td style="text-align:right">{{ $prod->p_name }}</td>
                                    @endif
                                @endforeach
                            </tr>
                            <tr>
                                <th>Size</th>
                                <td style="text-align:right">{{ $data->size }}</td>
                            </tr>
                            <tr>
                                <th>Quality</th>
                                <td style="text-align:right">{{ $data->quality }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    {{-- Code as per Template --}}
    {{-- <div class="template">
        <div class="row1">
            @foreach ($purchaseItems as $data)
                <table style="width:100%; display: flex;">
                    <tr>
                        @foreach ($products as $value)
                            @php
                                $qr = QrCode::size(120)->generate("$value->id.Product_Name = $value->p_name . Product_Size = $value->p_size. Quantity = $value->p_quantity. Rate = $value->p_rate. $value->availability");
                            @endphp
                            @if ($value->id == $data->product_id)
                                <td>{{ $qr }}</td>
                            @endif
                        @endforeach
                    </tr>
                </table>
            @endforeach
        </div>
        <div class="row2">
            @foreach ($purchaseItems as $data)
                <h3 style="margin-top: 0; padding:0;">Viraj Ceramics</h3><br>
                <div style="margin-top: -36px; padding:0;">
                    {!! DNS1D::getBarcodeSVG($data->product_code, 'C39', 1, 40) !!}
                </div>
                <table>
                    <tr>
                        <th>Product</th>
                        @foreach ($products as $prod)
                            @if ($prod->id == $data->product_id)
                                <td style="text-align:right">{{ $prod->p_name }}</td>
                            @endif
                        @endforeach
                    </tr>
                    <tr>
                        <th>Size</th>
                        <td style="text-align:right">{{ $data->size }}</td>
                    </tr>
                    <tr>
                        <th>Quality</th>
                        <td style="text-align:right">{{ $data->quality }}</td>
                    </tr>
                </table>
            @endforeach
        </div>
    </div> --}}

</body>

</html>
