@extends('admin.layouts.master')
@section('content')
    <!-- Blank Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="bg-light rounded  p-4">
            <x-session-message />
            <div class="d-flex justify-content-between mb-2">
                <h6 class="mb-4">Manage Product</h6>
                <div class="d-flex gap-2">
                    <form class="d-flex" method="GET">
                        <input type="search" class="form-control border-0" name="search" id="search" placeholder="Search">
                        <input type="submit" value="Submit" class="btn btn-success">
                    </form>
                    @if (Request::get('search') != '')
                        <a href="{{ route('product') }}" class="btn btn-danger">All Products</a>
                    @endif
                </div>
                <div>
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exampleModal">
                        +&nbsp;Add&nbsp;Product
                    </button>
                    <a href="{{ route('productPDF') }}" class="btn btn-info" target="_blank"><i class="fa fa-download"
                            aria-hidden="true"></i></a>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table text-center">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Size</th>
                            <th>Quality</th>
                            <th>Category</th>
                            <th>Quantity</th>
                            <th>Rate</th>
                            <th>Godown</th>
                            <th>Status</th>
                            <th>Action</th>
                            <th>Qr&nbsp;Code</th>
                            <th>BarCode</th>
                            <th>MRP</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($products as $value)
                            <tr>
                                <td class="align-middle">
                                    <img src="{{ $value->p_image }}" width="70px;" height="70px;" alt="">
                                </td>
                                <td class="align-middle">{{ $value->p_name }}</td>
                                <td class="align-middle">{{ $value->p_size }}</td>
                                @foreach ($qualities as $data)
                                    @if ($data->id == $value->quality_id)
                                        <td class="align-middle"> {{ $data->quality_name }}</td>
                                    @endif
                                @endforeach
                                @foreach ($categories as $item)
                                    @if ($item->id == $value->cat_id)
                                        <td class="align-middle"> {{ $item->categories_name }}</td>
                                    @endif
                                @endforeach
                                <td class="align-middle">{{ $value->current_quantity }}</td>
                                <td class="align-middle">{{ $value->p_rate }}</td>
                                @php
                                    $godowns = str_replace(']', '', $value->godown);
                                    $godowns = str_replace('[', '', $godowns);
                                    $godowns = str_replace('"', '', $godowns);
                                    $godowns = str_replace(',', ', ', $godowns);
                                @endphp
                                <td class="align-middle">{{ strtoupper($godowns) }}</td>
                                <td class="align-middle">
                                    @if ($value->availability == 'AVAILABLE')
                                        <label class="p-1  bg-success text-white">AVAIL</label>
                                    @elseif ($value->availability == 'NOT-AVAILABLE')
                                        <label class="p-1  bg-danger text-white">NOT-AVAIL</label>
                                    @endif
                                </td>
                                <td class="align-middle">
                                    <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                        data-bs-target="#editModal"
                                        onclick="updateProduct('{{ $value->id }}','{{ $value->cat_id }}','{{ $value->quality_id }}','{{ $value->p_image }}','{{ $value->p_name }}','{{ $value->p_size }}','{{ $value->p_rate }}','{{ $value->availability }}','{{ $value->godown }}')">
                                        <i class="fa fa-edit"></i>
                                    </button>
                                    @auth
                                        @if (Auth::user()->role == 'Admin')
                                            <a href="{{ route('deleteProduct', $value->id) }}"
                                                onclick="return confirm('Are you sure you want to delete this Product?');"><button
                                                    type="button" class="btn btn-square btn-danger m-2"><i
                                                        class="fa fa-trash"></i></button></a>
                                        @endif
                                    @endauth
                                    <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                        data-bs-target="#itemModal" onclick="updateCat('{{ $value->id }}')">
                                        <i class="fa fa-eye"></i>
                                    </button>
                                </td>
                                @php
                                    $quality = $value->quality->quality_name;
                                    $qr = QrCode::size(50)->generate("$value->id.Name = $value->p_name . Size = $value->p_size . Quality = $quality ");
                                    $qr1 = QrCode::size(300)->generate("$value->id.Name = $value->p_name . Size = $value->p_size . Quality = $quality");
                                @endphp
                                <td class="align-middle">
                                    <button onclick="qrcode('{{ $value->id }}')" data-bs-toggle="modal"
                                        data-bs-target="#qrcode">
                                        <div>{{ $qr }}</div>
                                    </button>
                                    <a href="{{ route('proPdf', $value->id) }}"><i class="fa fa-download"
                                            aria-hidden="true"></i></a>
                                </td>
                                <td class="align-middle">
                                    <div class="text-center">
                                        <a href="{{ route('barcode', $value->id) }}">
                                            {!! DNS1D::getBarcodeSVG($value->product_code, 'C39', 0.4, 50) !!}
                                        </a>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <a href="{{ route('prodMRP', $value->id) }}">
                                        <i class="fa fa-download" aria-hidden="true">MRP</i>
                                    </a>
                                </td>
                                <div id="{{ $value->id }}qr_data" class="d-none">{{ $qr1 }}</div>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-end my-3">
                    {{ $products->links('pagination::bootstrap-4') }}
                </div>

            </div>
        </div>
        {{-- QR CODE  --}}
        <div class="modal fade" id="qrcode" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content align-items-center">
                    <div class="modal-header ">
                        <input type="hidden" name="code" id="code">
                        <h5 class="modal-title" id="exampleModalLongTitle">QR Code</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div id="qr-code-model"></div>
                    </div>
                </div>
            </div>
        </div>
        {{-- Add Quantity Model  --}}
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add Product</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('storeProduct') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Product Image :</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="file" name="p_image" class="form-control">
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Product Name:</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" name="p_name" class="form-control" placeholder="PRODUCT NAME"
                                        required>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Product Size :</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" name="p_size" class="form-control" placeholder="PRODUCT SIZE"
                                        required>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Product Quality:</label>
                                </div>
                                <div class="col-md-8">
                                    <select name="p_quality" class="form-control" required>
                                        <option value="">~~SELECT~~</option>
                                        @foreach ($qualities as $quality)
                                            <option value="{{ $quality->id }}">{{ $quality->quality_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Category Name:</label>
                                </div>
                                <div class="col-md-8">
                                    <select name="p_category" class="form-control" required>
                                        <option value="">~~SELECT~~</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->categories_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Rate:</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" name="rate" class="form-control" required>
                                </div>
                            </div>
                            <br>

                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Status :</label>
                                </div>
                                <div class="col-md-8">
                                    <select name="availability" class="form-control" required>
                                        <option value="">~~SELECT~~</option>
                                        <option value="AVAILABLE">Available</option>
                                        <option value="NOT-AVAILABLE">Not-Available</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Upload link:</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="url" name="video_link" id="video_link" class="form-control">
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Godown:</label>
                                </div>
                                <div class="col-md-8">
                                    <label for="godown1">KKW</label>
                                    <input type="checkbox" id="godown1" name="godown[]" value="kkw" checked>
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <label for="godown2">MN</label>
                                    <input type="checkbox" id="godown2" name="godown[]" value="mn">
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <label for="godown3">Viraj Ceramics</label>
                                    <input type="checkbox" id="godown3" name="godown[]" value="vs">
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="table text-center" id="dynamicTable">
                                <thead>
                                    <tr>
                                        <th>BatchNo</th>
                                        <th>Quantity</th>
                                        <th>Location</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center">
                            <button type="button" class="btn btn-success" onclick="addRow();"
                                data-loading-text="Loading...">
                                <i class="glyphicon glyphicon-plus-sign">+</i>
                            </button>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-success">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- Edit Product Model  --}}
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Edit Product</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('updateProduct') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" id="p_id" name="p_id">
                        <input type="hidden" id="purchase_id" name="purchase_id">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Product Image :</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="file" name="p_image" class="form-control">
                                </div>
                            </div>
                            <br>

                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Product Name:</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" name="p_name" id="p_name" class="form-control"
                                        placeholder="PRODUCT NAME" required>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Product Size :</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" name="p_size" id="p_size" class="form-control"
                                        placeholder="product Size" required>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Product Quality:</label>
                                </div>
                                <div class="col-md-8">
                                    <select id="p_quality" name="p_quality" class="form-control" required>
                                        <option value="">~~SELECT~~</option>
                                        @foreach ($qualities as $quality)
                                            <option value="{{ $quality->id }}">{{ $quality->quality_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <br>

                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Category Name:</label>
                                </div>
                                <div class="col-md-8">
                                    <select id="cat_id" name="cat_id" class="form-control" required>
                                        <option value="">~~SELECT~~</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->categories_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <br>
                            {{-- @auth
                                @if (Auth::user()->role == 'User')
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label for="" style="font: bold;color:black">Quantity:</label>
                                        </div>
                                        <div class="col-md-8">
                                            <input type="text" name="p_quantity" id="p_quantity" class="form-control"
                                                readonly>
                                        </div>
                                    </div>
                                @else
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label for="" style="font: bold;color:black">Quantity:</label>
                                        </div>
                                        <div class="col-md-8">
                                            <input type="text" name="p_quantity" id="p_quantity" class="form-control"
                                                required>
                                        </div>
                                    </div>
                                @endif
                            @endauth --}}

                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Rate:</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" name="p_rate" id="p_rate" class="form-control" required
                                        @if (Auth::user()->role != 'Admin') readonly @endif>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Status :</label>
                                </div>
                                <div class="col-md-8">
                                    <select id="availability" name="availability" class="form-control" required>
                                        <option value="">~~SELECT~~</option>
                                        <option value="AVAILABLE">Available</option>
                                        <option value="NOT-AVAILABLE">Not-Available</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Upload link:</label>
                                </div>
                                <div class="col-md-8">
                                    <input type="url" name="video_link" id="video_link" class="form-control">
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="" style="font: bold;color:black">Godown:</label>
                                </div>
                                <div class="col-md-8">
                                    <label for="godown1">KKW</label>
                                    <input type="checkbox" id="godown_edit1" name="godown[]" value="kkw" checked>
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <label for="godown2">MN</label>
                                    <input type="checkbox" id="godown_edit2" name="godown[]" value="mn">
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <label for="godown3">VC</label>
                                    <input type="checkbox" id="godown_edit3" name="godown[]" value="vc">
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="table text-center" id="editdynamicTable">
                                <thead>
                                    <tr>
                                        <th>BatchNo</th>
                                        <th>Quantity</th>
                                        <th>Location</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center">
                            <button type="button" class="btn btn-success" onclick="addRowData();"
                                data-loading-text="Loading...">
                                <i class="glyphicon glyphicon-plus-sign">+</i>
                            </button>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="itemModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Stock&nbsp;Data</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body p-1">
                    <table class="table text-center">
                        <thead>
                            <tr>
                                <th>Sr&nbsp;No</th>
                                <th>Batch&nbsp;No</th>
                                <th>Box&nbsp;Quantity</th>
                            </tr>
                        </thead>
                        <tbody id="item_body">
                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-end pb-3 px-4">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <br>
    <br>
    <br>
    <br>
    <br>
    <br>
    <script>
        let product = @JSON($products).data;
        let prod = 0;

        function updateProduct(id, cat_id, p_quality, image, p_name, p_size, p_rate, availability, godown) {
            document.getElementById('p_id').value = id;
            document.getElementById('cat_id').value = cat_id;
            document.getElementById('p_quality').value = p_quality;
            document.getElementById('p_name').value = p_name;
            document.getElementById('p_size').value = p_size;
            document.getElementById('p_rate').value = p_rate;
            document.getElementById('availability').value = availability;

            var options = JSON.parse(godown);
            document.getElementById('godown_edit1').checked = false;
            document.getElementById('godown_edit2').checked = false;
            document.getElementById('godown_edit3').checked = false;
            if (options.includes("kkw")) {
                document.getElementById('godown_edit1').checked = true;
            }
            if (options.includes("mn")) {
                document.getElementById('godown_edit2').checked = true;
            }
            if (options.includes("tcs")) {
                document.getElementById('godown_edit3').checked = true;
            }

            if (product != null) {
                let products = product.find((item) => item.id == id);
                $('#editdynamicTable tbody').empty();
                products.purchase_items.forEach(element => {
                    if (element.purchase_id != null) {
                        document.getElementById('purchase_id').value = element.purchase_id;
                    }

                    prod++;
                    let html = `<tr id="faqs-row${prod}" style="text-align:center">
                    <td><input type="hidden" name="stockId[]" id="stockId${prod}" value="${element.id}">
                    <input type="text" name="batch_no[]" id="batch_no${prod}" class="form-control" value="${element.batchno}" oninput="getBatchno(this)" required></td>
                <td><input type="text" name="quantity[]" id="quantity${prod}" class="form-control" value ="${element.quantity}" pattern="[0-9]+(\.[0-9]{1,2})?" onclick="getBoxQty(this)" required></td>
                <td><input type="text" name="location[]" id="location${prod}" class="form-control" value ="${element.location}"></td>
                <td style="color: red" id="removeButton${prod}"><i class="fa fa-trash" aria-hidden="true"></i></td>
                </tr>`;
                    $('#editdynamicTable tbody').append(html);

                    document.getElementById(`removeButton${prod}`).addEventListener("click", (e) => {
                        removeTableRow(element.id)
                        if (confirm('Are you sure you want to delete this Entry?')) {
                            e.target.parentNode.parentNode.remove()
                        }
                    });
                });
            }

        }

        function removeTableRow(p) {
            stockId = p;
            $.ajax({
                type: 'POST',
                url: `{{ route('getPurchaseItems') }}`,
                data: {
                    "_token": "{{ csrf_token() }}",
                    stockId: stockId
                },
                success: function(x) {
                    console.log(x);
                }
            });

        }

        function addRowData() {
            prod++;
            html =
                `<tr id="faqs-row${prod}" style="text-align:center">
        <td><input type="hidden" name="stockId[]" id="stockId${prod}">
            <input type="text" name="batch_no[]" id="batch_no${prod}" class="form-control" oninput="getBatchno(this)" required></td>
        <td><input type="number" name="quantity[]" id="quantity${prod}" class="form-control" value ="0" onclick="getBoxQty(this)" required></td>
        <td><input type="text" name="location[]" id="location${prod}" class="form-control"></td>
        <td style="color: red" onclick="$('#faqs-row${prod}').remove();"><i class="fa fa-trash" aria-hidden="true"></i></td>
        </tr>`;
            $('#editdynamicTable tbody').append(html);
        }
        addRowData();

        function qrcode(id) {
            document.getElementById('code').value = id;
            document.getElementById("qr-code-model").innerHTML = document.getElementById(`${id}qr_data`).innerHTML;
        }

        function updateCat(prodId) {
            let stock = product.find((e) => e.id == prodId);
            let html = ``;
            stock.batches.forEach((element, i) => {
                html += ` <tr>
                                <td>${i+1}</td>
                                 <td>${element.batchno}</td>
                                 <td>${element.quantity}</td>
                                </tr>`;
            });
            document.getElementById('item_body').innerHTML = html;
        }

        function getBoxQty(n) {
            let id = n.id.replace("quantity", "");
            document.getElementById(`quantity${id}`).value = "";
        }

        function addRow() {
            prod++;
            html =
                `<tr id="faqs-row${prod}" style="text-align:center">
                <td><input type="text" name="batch_no[]" id="batch_no${prod}" class="form-control" oninput="getBatchno(this)" required></td>
                <td><input type="text" name="quantity[]" id="quantity${prod}" class="form-control" value ="0" pattern="[0-9]+(\.[0-9]{1,2})?" onclick="getBoxQty(this)" required></td>
                <td><input type="text" name="location[]" id="location${prod}" class="form-control"></td>
                <td style="color: red" onclick="$('#faqs-row${prod}').remove();"><i class="fa fa-trash" aria-hidden="true"></i></td>
                </tr>`;
            $('#dynamicTable tbody').append(html);
        }
        addRow();
    </script>
@endsection
