<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Delivery Challan</title>
</head>
<style>
    h5,
    table,
    td,
    td p {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    h2 {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        margin: 10px;
    }

    body {
        width: 100%;
        height: 100%;
        margin: 0 auto;
        font-family: "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
        font-weight: 400;
    }

    .wrapper {
        border: 1px solid #000;
        margin: 10px 0;
        padding: 0.25rem;
    }

    .delivery-challan {
        color: #212529;
        font-size: 20px;
    }

    .text-center {
        text-align: center;
    }

    .card {
        width: 80%;
        padding: 1rem;
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-radius: 0.25rem;
        text-align: left;
        font-weight: bold;
    }

    .card-title {
        color: #212529;
        font-size: 18px;
    }

    .headerDiv .logo {
        width: 40%;
        text-align: center;
    }

    .card-text {
        font-size: 12px;
        color: #212529;
        padding: 0;
    }

    .bank-details {
        padding: 8px;
        font-weight: bold;
    }

    table {
        width: 100%;
        text-align: center;
    }

    thead {
        background-color: #343a40;
        color: white;
    }

    table,
    th,
    td {
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-collapse: collapse;
        padding: 10px 0px;
    }

    .terms {
        text-align: left;
        border-radius: 0.25rem;
    }

    .terms td {
        padding: 8px;
    }



    .footer td {
        padding: 10px;
    }

    .dark-border {
        border: 1px solid rgb(0, 0, 0);
    }

    .remove-border {
        border: none;
    }
</style>

<body>
    <div class="wrapper">
        <div class="text-center delivery-challan">
            <h2>Delivery Challan</h2>
        </div>

        <table class="remove-border">
            <tr class="remove-border">
                <td class="remove-border">
                    <div class="card">
                        <span class="card-title">THE CERAMIC STUDIO</span>
                        <br>
                        <span class="card-text">Shop no. 18, Business Bay<br>
                            Shree Hari Kute Marg<br>
                            Tidke Colony, Mumbai Naka<br>
                            Nashik - 422002<br>
                            CONT.: 8847788888, 7058859999<br>
                            Email: support@theceramicstudio.in<br>
                        </span>

                    </div>
                </td>
                <td class="remove-border">
                    <img src="{{ asset('img/user.jpg') }}" alt="Logo" width="160px">
                </td>
            </tr>
        </table>
        <table>
            <tr>
                <th class="dark-border">To, {{ ucwords(strtolower($quotation->client_name)) }}</th>
                <th class="dark-border">Mobile No: {{ ucwords(strtolower($quotation->contact)) }}</th>
                <th class="dark-border">Challan No: {{ ucwords(strtolower($quotation->id)) }}</th>
            </tr>
            <tr>
                <th class="dark-border">Delivery Boy: {{ ucwords(strtolower($quotation->del_boy_name)) }}</th>
                <th class="dark-border">Contact: {{ ucwords(strtolower($quotation->del_boy_contact)) }}</th>
                <th class="dark-border">Date: {{ ucwords(strtolower($quotation->created_at)) }}</th>
            </tr>
        </table>
        <table>
            <thead>
                <tr>
                    <th>DC No</th>
                    <th>Description</th>
                    <th>Size</th>
                    <th>Weight</th>
                    <th>Qty</th>
                    <th>Rate</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $tot_weight = 0;
                    $tot_amount = 0;
                    $grandtotal = 0;
                @endphp
                @foreach ($quotationItems as $value)
                    @php
                        $cov = $value->coverage;
                        $totbox = $value->unit_send != null ? $value->unit_send : $value->box;
                        $calculate = round($cov * $totbox * $value->rate, 2);
                        $percent = ($calculate * $value->discount) / 100;
                        $p_name = '';
                    @endphp
                    @foreach ($products as $prod)
                        @if ($prod->id == $value->product_id)
                            @php
                                $p_name = $prod->p_name;
                            @endphp
                        @endif
                    @endforeach
                    <tr>
                        <td>{{ $value->product_id }}</td>
                        <td>{{ $p_name }}</td>
                        <td>{{ $value->size }}</td>
                        <td>{{ $value->total_weight }}</td>
                        <td>{{ $value->unit_send != null ? $value->unit_send : $value->box }}</td>
                        <td>{{ $value->rate }}</td>
                        <td>{{ round($value->total, 2) }}</td>
                        @php
                            $tot_weight += $value->total_weight;
                            $grandtotal += $calculate - $percent;
                        @endphp
                    </tr>
                @endforeach
            </tbody>
        </table>
        <table>
            <tr>
                <th style="text-align: right;padding-right: 20px;">Total Weight</th>
                <td>@php echo $tot_weight / 1000 @endphp Tons</td>
            </tr>
            <tr>
                <th style="text-align: right;padding-right: 20px;">Total</th>
                <td>{{ round($grandtotal, 2) }}</td>
            </tr>
        </table>
        <div class="bank-details">
            For NEFT or RTGS :-<br>
            Yes Bank <br>
            Branch:- Canada Corner<br>
            Bank IFSC CODE:- YESB0000021<br>
            AC. HO. Name:- THE CERAMIC STUDIO<br>
            AC. NO. :- 002163700002424
        </div>
        <table class="terms">
            <tr>
                <td>Terms & Conditions:-<br>
                    All goods are delivered in good condition<br>
                    Our responsibility ceases have left our premises<br>
                    Goods once sold will not be taken back<br>
                    No complaint regarding rates will be entertained<br>
                    Interest @24% per annum will be charged, if bill not paid within 33 days
                </td>
                <td>
                    for, Viraj Ceramics
                </td>
            </tr>
        </table>
        <table class="footer">
            <tr>
                <td class="strong">Tempo No: {{ $quotation->tempo_no }}</td>
                <td>Receivers Signature</td>
            </tr>
        </table>
    </div>
</body>

</html>
