@extends('admin.layouts.master')
@section('content')
    <div class="container-fluid">
        <x-session-message />
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tracking Details</h5>
                </div>
                <form action="{{ route('trackingDetails') }}" method="POST">
                    @csrf
                    <input type="hidden" id="del_id" name="del_id" value="{{ $purchase_id }}">
                    <div class="modal-body">
                        <br>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="" style="font: bold;color:black">Date&nbsp;&&nbsp;Time</label>
                            </div>
                            <div class="col-md-6">
                                <input type="datetime-local" name="date" class="form-control">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="" style="font: bold;color:black">Status :</label>
                            </div>
                            <div class="col-md-6">
                                <select name="status" class="form-control">
                                    <option value="">~~SELECT~~</option>
                                    <option value="PREDISPATCH">Preparing For Dispatch</option>
                                    <option value="DISPATCH">Dispatched</option>
                                    <option value="ONTHEWAY">On The Way</option>
                                    <option value="DELIVER">Deliver</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-center">
                        <button type="submit" class="btn btn-success">Submit</button>
                    </div>
                    <table class="table text-center">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($trackingData as $data)
                                <tr>
                                    <td>{{ $data->id }}</td>
                                    <td>{{ $data->purchase_date }}</td>
                                    <td>{{ $data->status }}</td>
                                    <td>
                                        <a href="{{ route('deleteTrackingData', $data->id) }}"
                                            onclick="return confirm('Are you sure you want to delete this Tips?');">
                                            <button type="button" class="btn btn-square btn-danger m-2"><i
                                                    class="fa fa-trash" title="Delete Quotation"></i></button>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                </form>
            </div>
        </div>
    </div>
@endsection
