<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Product extends Model
{
    use HasFactory;
    public $fillable = ['quality_id', 'cat_id', 'p_name', 'p_image', 'p_size', 'p_quantity', 'p_rate', 'availability', 'video_link', 'godown', 'product_code'];

    protected $hidden = ['created_at', 'updated_at'];

    public function quality(){
        return $this->hasOne(Quality::class, 'id', 'quality_id')->select('id', 'quality_name');
    }

    public function category(){
        return  $this->hasOne(Category::class, 'id', 'cat_id')->select('id', 'categories_name');
    }

    public function getPImageAttribute()
    {
        if ($this->attributes['p_image'] == null || $this->attributes['p_image'] == '') {
            return asset('assets/img/img_not_avl.png');
        }
        if (!file_exists(public_path('product_img/' . $this->attributes['p_image']))) {
            return asset('assets/img/img_not_avl.png');
        }
        return asset('product_img/' . $this->attributes['p_image']);
    }

    // public function categoryName()
    // {
    //     return Category::where('id', $this->cat_id)->first()->categories_name;
    // }

    // public function qualityName()
    // {
    //     return Quality::where('id', $this->quality_id)->first()->quality_name;
    // }

    public function purchaseItems()
    {
        return $this->hasMany(PurchaseItems::class, 'product_id');
        // return $this->p_quantity + PurchaseItems::where('product_id', $this->id)->sum('quantity');
    }
    public function managePurchaseItems()
    {
        return $this->hasMany(ManagePurchaseItems::class, 'product_id');
        // return ManagePurchaseItems::where('product_id', $this->id)->sum('box');
    }

    // public function getCurrentQuantityAttribute()
    // {
    //     return  $this->totalQuantity() - $this->totalSoldQuantity();
    // }
}
