@extends('admin.layouts.master')
@section('content')
    <div class="container-fluid pt-4 px-4 mb-5">
        <div class="bg-light rounded p-4">
            <x-session-message />
            <form action="{{ route('updatePurchase') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="bg-light rounded">
                        <h6 class="mb-4">Edit Inventory</h6>
                        <input type="hidden" id="purchase_id" name="purchase_id" value="{{ $pdata->id }}">
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Purchase Date</label>
                        <div class="col-md-10">
                            <input type="date" class="form-control" name="purchase_data"
                                value="{{ $pdata->purchase_date }}">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Bill No</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="bill_no" value="{{ $pdata->bill_no }}">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Client Name :</label>
                        <div class="col-md-10">
                            <input type="text" class="form-control" name="client_name" value="{{ $pdata->client_name }}">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Contact No :</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="contact" value="{{ $pdata->client_contact }}"
                                pattern="[0-9]{10}" maxlength="10">
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table" id="dynamicTable">
                        <thead class="text-center">
                            <tr>
                                <th>Product</th>
                                <th style="width: 9%">Size</th>
                                <th style="width: 9%">Quality</th>
                                <th>Rate</th>
                                <th>Cov</th>
                                <th>BatchNo</th>
                                <th>Avl&nbsp;Qty</th>
                                <th>Qty</th>
                                <th>Total</th>
                                <th>GoDown</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label">SubAmount :</label>
                    <div class="col-sm-10">
                        <input type="number" class="form-control" id="subTotal" name="subTotal"
                            value="{{ $pdata->total }}" readonly />
                    </div>
                </div>
                <div class="form-group submitButtonFooter">
                    <div class="text-center">
                        <button type="button" class="btn btn-success" onclick="addRow();" data-loading-text="Loading...">
                            <i class="glyphicon glyphicon-plus-sign"></i>Add&nbsp;Row</button>
                        <button type="submit" id="createQuotationBtn" data-loading-text="Loading..."
                            class="btn btn-success"><i class="glyphicon glyphicon-ok-sign"></i>Update&nbsp;Changes</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script type="text/javascript">
        let products = @JSON($products);
        let qualities = @JSON($quality);
        let purchaseItems = @JSON($purchaseItems);
        var prod = purchaseItems.length;

        let deleteRoute = "{{ route('deleteInvenData') }}";

        function calculateSub() {
            let subtotal = 0;
            for (let x = 0; x <= prod; x++) {
                let current = document.getElementById(`totalbalance${x}`);
                if (current != null && current.value != "") {
                    subtotal += parseFloat(current.value);
                }
            }
            document.getElementById('subTotal').value = subtotal.toFixed(2);
        }

        function getProdData(e) {
            let row_id = e.id.replace("prod_name", "");
            let sizes = [];
            products.forEach(element => {
                if (element.p_name.toUpperCase() == e.value.toUpperCase()) {
                    sizes.push(element.p_size.toLowerCase());
                }
            });
            sizes = [...new Set(sizes)];
            let optionHtml = '<option>~SELECT~</option>';
            sizes.forEach(e => {
                optionHtml += `<option value="${e}">${e}</option>`;
            })

            document.getElementById(`productSize${row_id}`).innerHTML = optionHtml;
            document.getElementById(`productQuality${row_id}`).innerHTML = "<option>~SELECT~</option>";
            document.getElementById(`productrate${row_id}`).value = "";
            document.getElementById(`coverage${row_id}`).value = "";
            document.getElementById(`batch_no${row_id}`).value = "";
            document.getElementById(`avl_quantity${row_id}`).value = "";
            document.getElementById(`quantity${row_id}`).value = "";
            document.getElementById(`totalbalance${row_id}`).value = "";
            document.getElementById(`product_id${row_id}`).value = "";
            document.getElementById(`godown_Data${row_id}`).innerHTML = "";
            calculateSub();

        }

        function getProductSizeData(p) {
            let id = p.id.replace("productSize", "");
            let productName = document.getElementById(`prod_name${id}`).value;
            let optionHtml = '<option>~SELECT~</option>';

            let currentQualities = [];
            products.forEach(prod => {
                if (prod.p_name.toUpperCase() == productName.toUpperCase() && prod.p_size.toLowerCase() == p.value
                    .toLowerCase()) {
                    let currentQuality = qualities.find(e => e.id == prod.quality_id);
                    currentQualities.push(currentQuality.quality_name);
                }
            });
            currentQualities = [...new Set(currentQualities)];
            currentQualities.forEach(e => {
                optionHtml += `<option value="${e}">${e}</option>`;
            })
            document.getElementById(`productQuality${id}`).innerHTML = optionHtml;
        }

        function getProductQty(q) {
            let prodId = q.id.replace("productQuality", "");
            let productName = document.getElementById(`prod_name${prodId}`).value;
            let size = document.getElementById(`productSize${prodId}`).value;
            let pid = document.getElementById(`pid${prodId}`).value;
            let currentPurchaseItem = purchaseItems.find(e => e.pid == pid);

            let qualityId = qualities.find(e => e.quality_name == q.value).id;
            for (let index = 0; index < products.length; index++) {
                const element = products[index];
                if (element.p_name.toUpperCase() == productName.toUpperCase() && element.p_size.toLowerCase() == size
                    .toLowerCase() && element
                    .quality_id == qualityId) {
                    document.getElementById(`avl_quantity${prodId}`).value = element.current_quantity;
                    document.getElementById(`productrate${prodId}`).value = element.p_rate;
                    let godownData = JSON.parse(element.godown);
                    let optionHtml = '';
                    godownData.forEach(function(element) {
                        optionHtml += `<option>${element}</option>`;
                    });
                    document.getElementById(`godown_Data${prodId}`).innerHTML = optionHtml.toUpperCase();
                    break;
                }
            }
        }

        function updateTotal(row_id) {
            let totalEle = document.getElementById(`totalbalance${row_id}`);
            let availEle = document.getElementById(`avl_quantity${row_id}`);
            let coverage = document.getElementById(`coverage${row_id}`);
            let rate = document.getElementById(`productrate${row_id}`);
            let qtyEle = document.getElementById(`quantity${row_id}`);
            let prodIdEle = document.getElementById(`product_id${row_id}`);
            let pid = document.getElementById(`pid${row_id}`).value;
            let currentQuantity = purchaseItems.find(e => e.id == pid);
            if (rate.value != "" && coverage.value != "" && qtyEle.value != "" && qtyEle.value > 0 && coverage
                .value > 0 &&
                rate.value > 0 && !qtyEle.value.includes("e") && !coverage.value.includes("e") && !rate.value
                .includes(
                    "e") && !qtyEle.value.includes("E") && !coverage.value.includes("E") && !rate.value.includes(
                    "E")) {
                totalEle.value = parseFloat(qtyEle.value) * parseFloat(rate.value) * parseFloat(coverage.value);
            } else {
                totalEle.value = 0;
            }

            let productName = document.getElementById(`prod_name${row_id}`).value;
            let size = document.getElementById(`productSize${row_id}`).value;
            let qualityId = qualities.find(e => e.quality_name == document.getElementById(`productQuality${row_id}`)
                .value).id;
            let productDb = products.find(e => (e.p_name.toUpperCase() == productName.toUpperCase() && e.p_size
                .toLowerCase().trim() ==
                size.toLowerCase().trim() && e.quality_id == qualityId));

            if (currentQuantity == undefined) {
                currentQuantity = 0;
            } else {
                currentQuantity = currentQuantity.quantity;
            }
            if (qtyEle.value > 0 && qtyEle.value != "") {
                availEle.value = parseFloat(productDb.current_quantity) - parseFloat(currentQuantity) +
                    parseFloat(qtyEle.value);
                prodIdEle.value = productDb.id;
            } else {
                availEle.value = parseFloat(productDb.current_quantity) - parseFloat(currentQuantity);
            }
            calculateSub();
        }


        function removeTableRow(p) {
            purchaseId = p;
            $.ajax({
                type: 'POST',
                url: `{{ route('getInventoryData') }}`,
                data: {
                    "_token": "{{ csrf_token() }}",
                    purchaseId: purchaseId
                },
                success: function(x) {
                    document.getElementById('subTotal').value = x.data.total_amount;
                }
            });

        }

        function addRow(purchaseItem = null) {
            html =
                `<tr id="faqs-row${prod}" style="text-align:center">;
        <td><select class="form-control" name="prod_name[]" id="prod_name${prod}" onchange="getProdData(this);"><option value="">~SELECT~</option>`;
            let uniqueProductNames = products.map((item) => item.p_name.toUpperCase());
            uniqueProductNames = [...new Set(uniqueProductNames)];
            uniqueProductNames.forEach((element) => {
                html += `<option value="${element}">${element}</option>`;
            });
            html += `</select></td>
                <td><select class="form-control" name="productSize[]" id="productSize${prod}" onchange="getProductSizeData(this)"><option>~SELECT~</option></select></td>;
                <td> <select class="form-control" name="productQuality[]" id="productQuality${prod}" onchange="getProductQty(this)"><option>~SELECT~</option></select></td>
                <td><input type="text" name="productrate[]" id="productrate${prod}" class="form-control" oninput="updateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"></td>
                <td><input type="text" name="coverage[]" id="coverage${prod}" class="form-control" oninput="updateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"/></td>
                <td><input type="text" name="batch_no[]" id="batch_no${prod}" class="form-control" oninput="getBatchno(this)" required></td>
                <td><input type="text" class="form-control" name="avl_quantity[]" id="avl_quantity${prod}" readonly/></td>
                <td><input type="text" name="quantity[]" id="quantity${prod}" class="form-control" oninput="updateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"></td>
                <td><input type="hidden" name="product_id[]" id="product_id${prod}">
                    <input type="hidden" name="pid[]" id="pid${prod}">
                    <input type="text" name="totalbalance[]" id="totalbalance${prod}" class="form-control" readonly>
                    </td>
                <td><select name="godown[]" id="godown_Data${prod}"><option>~SELECT~</option></select></td></select></td>
                 <td style="color: red" id="removeButton${prod}"><i class="fa fa-trash" aria-hidden="true"></i></td>
                </tr>`;
            $('#dynamicTable tbody').append(html);

            if (purchaseItem != null) {
                let product = products.find((item) => item.id == purchaseItem.product_id);
                document.getElementById(`prod_name${prod}`).value = product.p_name.toUpperCase();
                let sizes = [];
                products.forEach(element => {
                    if (element.p_name.toUpperCase() == product.p_name.toUpperCase()) {
                        sizes.push(element.p_size.toLowerCase().trim());
                    }
                });
                sizes = [...new Set(sizes)];
                let optionHtml = '<option>~SELECT~</option>';
                sizes.forEach(e => {
                    optionHtml += `<option value="${e}">${e}</option>`;
                })

                document.getElementById(`productSize${prod}`).innerHTML = optionHtml;
                document.getElementById(`productSize${prod}`).value = purchaseItem.size;

                let currentQualities = [];
                products.forEach(e => {
                    if (e.p_name.toUpperCase() == product.p_name.toUpperCase() && e.p_size.toLowerCase() == product
                        .p_size.toLowerCase()) {
                        let currentQuality = qualities.find((item) => item.id == e.quality_id);
                        currentQualities.push(currentQuality.quality_name);
                    }
                });
                currentQualities = [...new Set(currentQualities)];
                optionHtml = '<option>~SELECT~</option>';
                currentQualities.forEach(e => {
                    optionHtml += `<option value="${e}">${e}</option>`;
                })
                document.getElementById(`productQuality${prod}`).innerHTML = optionHtml;
                document.getElementById(`productQuality${prod}`).value = purchaseItem.quality;
                document.getElementById(`productrate${prod}`).value = purchaseItem.rate;
                document.getElementById(`coverage${prod}`).value = purchaseItem.coverage;
                document.getElementById(`avl_quantity${prod}`).value = purchaseItem.available_qty;
                document.getElementById(`batch_no${prod}`).value = purchaseItem.batchno;
                document.getElementById(`quantity${prod}`).value = purchaseItem.quantity;
                document.getElementById(`totalbalance${prod}`).value = purchaseItem.total;
                document.getElementById(`product_id${prod}`).value = purchaseItem.product_id;

                let godowns = [];
                let godownData = JSON.parse(product.godown);
                optionHtml = '';
                godownData.forEach(function(element) {
                    optionHtml += `<option>${element}</option>`;
                });
                document.getElementById(`godown_Data${prod}`).innerHTML = optionHtml.toUpperCase();
                document.getElementById(`godown_Data${prod}`).value = purchaseItem.godown.toUpperCase();
                document.getElementById(`pid${prod}`).value = purchaseItem.id;

                document.getElementById(`removeButton${prod}`).addEventListener("click", (e) => {
                    removeTableRow(purchaseItem.id)
                    e.target.parentNode.parentNode.remove()
                });
            } else {
                document.getElementById(`removeButton${prod}`).innerHTML = `<i class="fa fa-trash" aria-hidden="true"></i>`;
                document.getElementById(`removeButton${prod}`).addEventListener('click', function(e) {
                    if (confirm('Are you sure you want to delete this Entry?')) {
                        e.target.parentNode.parentNode.remove()
                    }
                });
            }
            prod++;
        }

        purchaseItems.forEach((element) => {
            addRow(element);
        });
    </script>
@endsection
