<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Quotation</title>
</head>
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    html {
        margin: 10px;
        margin-top: 20px;
    }


    h2 {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        margin: 10px;
    }

    body {
        width: 100%;
        height: 100%;
        margin: 0 auto;
    }

    .wrapper {
        margin: 10px auto;
        padding: 20px 4px;
    }

    .delivery-challan {
        color: #212529;
        font-size: 20px;
    }

    .text-center {
        text-align: center;
    }

    .card {
        padding: 1rem;
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-radius: 0.25rem;
        text-align: left;
        font-weight: bold;
    }

    .card-title {
        color: #212529;
        font-size: 18px;
    }

    .headerDiv .logo {
        width: 40%;
        text-align: center;
    }

    .card-text {
        font-size: 16px;
        color: rgb(33, 37, 41);

    }

    .bank-details {
        padding: 8px;
        font-weight: bold;
    }

    table {
        width: 100%;
        text-align: center;
    }

    table,
    th,
    td {
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-collapse: collapse;
        padding: 10px 0px;
        word-wrap: break-word;

    }

    .terms {
        text-align: left;
        border-radius: 0.25rem;
    }

    .terms td {
        padding: 8px;
    }

    .footer td {
        padding: 10px;
    }

    .dark-border {
        border: 1px solid rgb(0, 0, 0);
    }

    .remove-border {
        border: none;
    }

    .p-2 {
        padding: 8px 0.2rem !important;
    }
</style>

<body>
    <div class="wrapper">
        <div class="text-center">
            <p class="card-text" style="width: 90%;margin: auto;font-weight: 600; margin-top: 10px; font-size: 14px">
            <h5 class="card-title">VIRAJ CERAMICS</h5>
            <p class="card-text">87/6, Balapur, Fagna<br>
                Opp Hotel Sheetal, Parola Road<br>
                Dhule<br>
                CONT.: 82852 72727<br>
                Email: viraj_ceramics@yahoon.com<br></p>
            </p>
        </div>
        <hr style="width: 90%;margin-left: auto;margin-right: auto;color: rgba(0, 0, 0, 0.514);
    border: solid;">
        <div class="text-center">
            <h2><u style=color:black;><i>Quotation</i></u></h2>
        </div>
        <table style="border: none; margin: 0 auto; width: 98%" class="text-center">
            <tbody>
                <tr>
                    <th style="text-align: left; border: none">To,</th>
                    <th style="border: none">Date :&nbsp;{{ $quotation->created_at->toDateString() }}
                    </th>
                </tr>
                <tr>
                    <th style="text-align: left; border: none">
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $quotation->client_name }}&nbsp;&nbsp;({{ $quotation->contact }})
                    </th>
                </tr>
                <tr>
                    <th style="text-align: left; border: none">Attended By
                        :&nbsp;&nbsp;&nbsp;{{ $quotation->attended_by }}({{ $quotation->attendee_contact }})
                    </th>
                </tr>
            </tbody>
        </table>

        <p style="font-size: 16px;color: rgb(33, 37, 41); margin: 0 auto;">
            This is with reference to our discussion with you regarding your requirement; here we
            quote our best price for your prestigious project as below:
        </p>
        <div style="margin-top: 20px;width: 99%;">
            <table class="table table-bordered">
                <thead class="text-center">
                    <tr>
                        <th style="border:1px solid black; width: 20px" class="p-2">SrNo</th>
                        <th width="10%" style="border:1px solid black;">{{ $type == 'code' ? 'Code' : 'Name' }}
                        </th>
                        <th style="border:1px solid black; width: 5%" class="p-2">Size</th>
                        <th style="border:1px solid black; width: 10%" class="p-2">Image</th>
                        <th style="border:1px solid black; width: 5%" class="p-2">Quality</th>
                        <th style="border:1px solid black; width: 5%" class="p-2">Rate</th>
                        <th style="border:1px solid black; width: 5%" class="p-2">Dis</th>
                        <th style="border:1px solid black; width: 5%" class="p-2">DisAmt</th>
                        <th style="border:1px solid black; width: 10%" class="p-2">Box</th>
                        <th style="border:1px solid black; width: 10%" class="p-2">Area</th>
                        <th style="border:1px solid black; width: 10%" class="p-2">Amount</th>
                    </tr>
                </thead>
                <tbody class="text-center">
                    @php
                        $tot_weight = 0;
                        $grandtotal = 0;
                        $count = 0;
                    @endphp
                    @foreach ($quotationItems as $value)
                        @php
                            $cov = $value->coverage != '' ? $value->coverage : 1;
                            $totbox = $value->unit_send != null ? $value->unit_send : $value->box;
                            $calculate = round((float) $cov * (float) $totbox * (float) $value->rate, 2);
                            if ($value->discount != null && $value->discount != 0 && $value->discount != '') {
                                $percent = ($calculate * (float) $value->discount) / 100;
                            } else {
                                $percent = 0;
                            }
                            $count++;
                            $p_name = '';
                            $p_image = '';
                            $discountAmt = $value->rate - ($value->rate * $value->discount) / 100;
                        @endphp
                        @foreach ($products as $prod)
                            @if ($prod->id == $value->product_id)
                                @php
                                    $p_name = $type == 'code' ? $prod->id : $prod->p_name;
                                    $p_image = $prod->p_image;
                                @endphp
                            @endif
                        @endforeach
                        <tr>
                            <td style="border:1px solid black; width: 5%" class="p-2">{{ $count }}</td>
                            <td style="border:1px solid black; width: 10%; font-size: 15px" class="p-2">
                                {{ $p_name }}</td>
                            <td style="border:1px solid black; width: 5%" class="p-2">{{ $value->size }}</td>
                            <td style="border:1px solid black; width: 10%" class="p-2">
                                @if (empty($p_image))
                                    <img src="{{ url('public/product_img/no_image.jpg') }}" width="60px"
                                        height="60px" style="padding-top: 15px;">
                                @else
                                    <a href="{{ $p_image }}" target="_blank">
                                        <img src="{{ $p_image }}" width="60px" height="60px"
                                            style="padding-top: 15px;">
                                    </a>
                                @endif
                            </td>
                            <td style="border:1px solid black; width: 5%" class="p-2">
                                {{ Str::ucfirst(Str::lower($value->quality)) }}</td>
                            <td style="border:1px solid black; width: 10%" class="p-2">{{ $value->rate }}</td>
                            @if ($value->discount != 0)
                                <td style="border:1px solid black; width: 5%" class="p-2">{{ $value->discount }}
                                </td>
                            @else
                                <td style="border:1px solid black;">-</td>
                            @endif
                            <td style="border:1px solid black; width: 5%" class="p-2">{{ $discountAmt }}</td>
                            <td style="border:1px solid black; width: 5%" class="p-2">
                                {{ $value->unit_send != null ? $value->unit_send : $value->box }}</td>
                            <td style="border:1px solid black; width: 10%" class="p-2">
                                {{ $value->application_area }}</td>
                            <td style="border:1px solid black; width: 10%" class="p-2">{{ $calculate - $percent }}
                            </td>
                            @php
                                $tot_weight += $value->total_weight;
                                $grandtotal += $calculate - $percent;
                            @endphp
                        </tr>
                    @endforeach
                    <tr>
                        <th colspan="10" class="text-center" style="border:1px solid black;">Total</th>
                        <td style="border:1px solid black;">{{ round($grandtotal, 2) }}/-</td>
                    </tr>
                    @if ($quotation->discount !== null && $quotation->discount !== 0)
                        <tr>
                            <th colspan="10" class="text-center" style="border:1px solid black;">Discount</th>
                            <td style="border:1px solid black;">{{ $quotation->discount }}/-</td>
                        </tr>
                        <tr>
                            <th colspan="10" class="text-center" style="border:1px solid black;">
                                Discounted&nbsp;Amount
                            </th>
                            <td style="border:1px solid black;">{{ $quotation->discountedAmt }}/-</td>
                        </tr>
                    @endif
                    <tr>
                        <th colspan="10" class="text-center" style="border:1px solid black;">Paidup&nbsp;Amount
                        </th>
                        <td style="border:1px solid black;">{{ $quotation->total_paid }}/-</td>
                    </tr>
                    <tr>
                        <th colspan="10" class="text-center" style="border:1px solid black;">DueAmount</th>
                        <td style="border:1px solid black;">{{ $quotation->due_amount }}/-</td>
                    </tr>
                </tbody>
            </table>
            <p>Above rates are including GST @ 18%, Excluding unloading charge and this are Nashik
                warehouse rates.
            </p>
            <b>Payment Terms &nbsp;:</b>&nbsp;&nbsp;
            100% Advance<br>
            <b>Delivery Period &nbsp;:</b>&nbsp;&nbsp; 7 TO 8 Days from the date of order / dispatch
            schedule.<br>
            <b>Billing</b>

            GST Billing @ 18%<br>
            <b>Validity Of Price :</b>&nbsp;&nbsp; 30 Days from Date of Quotation<br><br>
            <p>
                We again express our gratitude for your esteemed organization and looking forward
                for a
                long and
                healthy business relationship. Assuring you of our best service all the
                times.<br><br>
                Thanking You
            </p>
            <b>VIRAJ CERAMICS<br>
                82852 72727<br>
        </div>
    </div>
</body>

</html>
