@extends ('admin.layouts.master')
@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="col-12">
            <div class="bg-light rounded h-100 p-4">
                @if (Session::has('message'))
                    <div class="alert alert-success alert-dismissible tcs_alert">
                        <strong> {{ Session::get('message') }} </strong>
                    </div>
                @endif
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="mb-4">Report Data</h6>
                    </div>
                    <div class="col-md-4">
                        <form class="d-none d-md-flex ms-4">
                            <input class="form-control border-0" type="search" placeholder="Search">
                        </form>
                    </div>
                </div>
                <table class="table" id="starQuotation">
                    <thead class="text-center">
                        <tr>
                            <th scope="col">Sr&nbsp;No</th>
                            <th scope="col">Client&nbsp;Name</th>
                            <th scope="col">Created&nbsp;Date</th>
                            <th scope="col">Options</th>
                        </tr>
                    </thead>
                    @foreach ($quotationData as $data)
                        <tbody class="text-center">
                            <tr>
                                <td>{{ $data->id }}</td>
                                <td>{{ $data->client_name }}</td>
                                <td>{{ $data->created_at }}</td>
                                <td>
                                    <a href="{{ route('quotation', $data->id) }}">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i class="fa fa-print" title="Quotation"></i>
                                        </button></a>
                                </td>
                            </tr>
                        </tbody>
                    @endforeach
                </table>
            </div>
        </div>
    </div>
@endsection
