<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css"
        integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    
    

    <title>Quotation</title>
</head>
<style>
    .container {
        width: 1000px;
    }

    .wrapper {
        width: 100%;
        /* border: 1px solid #000; */
        margin: 18px 0;

        .row {
            border-bottom: 1px solid #000;

            .border-right {
                border-right: 1px solid #000;
            }
        }

        .no-border {
            border-bottom: 0;
        }
    }

    .imge {
        height: 104px;
        width: 200px;
    }

    .logo {
        margin-top: 40px;
        margin-left: 30px;
    }

    .pri {
        margin-left: 590px;
        margin-top: -34px;
    }

    .printQ {
        margin-left: 590px;
        margin-top: 10px;
        margin-bottom: 0;
    }

    .tablecontainer {
        width: 99%;
        margin: auto;
    }
</style>

<body>
    <div class="container">
        <div class="wrapper">
            <div class="mt-3 row justify-content-center">
                <div class="text-center">
                    <div class="card-body">
                          <h5 class="card-title">VIRAJ CERAMICS</h5>
                        <p class="card-text mt-4">87/6, Balapur, Fagna<br>
                            Opp Hotel Sheetal, Parola Road<br>
                            Dhule<br>
                            CONT.: 82852 72727<br>
                            Email: viraj_ceramics@yahoon.com<br></p>
                    </div>
                    <hr
                        style="width: 80%;margin-left: auto;margin-right: auto;color: rgba(0, 0, 0, 0.514);
    border: solid;">
                </div>
                <div class="text-center">
                    <h3><u style=color:black;><i>Quotation</i></u></h3>
                </div>
                <div class="tablecontainer">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-8">
                                <table>
                                    <tbody>
                                        <tr>
                                            <th>To,</th>
                                        </tr>
                                        <tr>
                                            <th>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($quotations->client_name); ?>&nbsp;&nbsp;(<?php echo e($quotations->contact); ?>)
                                            </th>
                                        </tr>
                                        <tr>
                                            <th>Attended By
                                                :&nbsp;&nbsp;&nbsp;<?php echo e($quotations->attended_by); ?>(<?php echo e($quotations->attendee_contact); ?>)
                                            </th>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-sm-4">
                                <table>
                                    <tbody>
                                        <tr>
                                            <th> Date :&nbsp;<?php echo e($quotations->created_at->toDateString()); ?></th>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="mt-4">
                            <p>
                                This is with reference to our discussion with you regarding your requirement; here we
                                quote our<br> best price for your prestigious project as below:
                            </p>
                        </div>
                    </div>
                </div>
                <div class="tablecontainer">
                    <table class="table table-bordered">
                        <thead class="text-center">
                            <tr>
                                <th width="3%" style="border:1px solid black;">Sr&nbsp;No</th>
                                <th width="10%" style="border:1px solid black;">
                                    <?php echo e($type == 'code' ? 'Code' : 'Name'); ?>

                                </th>
                                <th width="10%" style="border:1px solid black;">Size</th>
                                <th width="10%" style="border:1px solid black;">Image</th>
                                <th width="10%" style="border:1px solid black;">Quality</th>
                                <th width="10%" style="border:1px solid black;">Rate</th>
                                <th width="10%" style="border:1px solid black;">Dis</th>
                                <th width="10%" style="border:1px solid black;">DisAmt</th>
                                <th width="10%" style="border:1px solid black;">Box</th>
                                <th width="10%" style="border:1px solid black;">App.&nbsp;Area</th>
                                <th width="10%" style="border:1px solid black;">Amount</th>
                            </tr>
                        </thead>
                        <tbody class="text-center">
                            <?php
                                $tot_amount = 0;
                                $count = 0;
                            ?>
                            <?php $__currentLoopData = $quotationItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $count++;
                                    $p_name = '';
                                    $p_image = '';
                                    $discountAmt = $value->rate - ($value->rate * $value->discount) / 100;
                                ?>

                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($prod->id == $value->product_id): ?>
                                        <?php
                                            $p_name = $type == 'code' ? $prod->id : $prod->p_name;
                                            $p_image = $prod->p_image;
                                        ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="border:1px solid black;"><?php echo e($count); ?></td>
                                    <td style="border:1px solid black;"><?php echo e($p_name); ?></td>
                                    <td style="border:1px solid black;"><?php echo e($value->size); ?></td>
                                    <td style="border:1px solid black;">
                                        <?php if(empty($p_image)): ?>
                                            <img src="<?php echo e(url('public/product_img/no_image.jpg')); ?>" width="100px">
                                        <?php else: ?>
                                            <a href="<?php echo e($p_image); ?>" target="_blank">
                                                <img src="<?php echo e($p_image); ?>" width="100px" height="100px">
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    <td style="border:1px solid black;"><?php echo e($value->quality); ?></td>
                                    <td style="border:1px solid black;"><?php echo e($value->rate); ?></td>
                                    <?php if($value->discount != 0): ?>
                                        <td style="border:1px solid black;"><?php echo e($value->discount); ?></td>
                                    <?php else: ?>
                                        <td style="border:1px solid black;">-</td>
                                    <?php endif; ?>
                                    <td style="border:1px solid black;"><?php echo e($discountAmt); ?></td>
                                    <td style="border:1px solid black;"><?php echo e($value->box); ?></td>
                                    <td style="border:1px solid black;"><?php echo e($value->application_area); ?></td>
                                    <td style="border:1px solid black;"><?php echo e(round($value->total, 2)); ?></td>
                                    <?php
                                        $tot_amount += $value->total;
                                    ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th colspan="10" class="text-center" style="border:1px solid black;">Grand&nbsp;Total
                                </th>
                                <td style="border:1px solid black;"><?php echo e($tot_amount); ?>/-</td>
                            </tr>
                            <?php if($quotations->discount !== null && $quotations->discount !== 0): ?>
                                <tr>
                                    <th colspan="10" class="text-center" style="border:1px solid black;">Discount</th>
                                    <td style="border:1px solid black;"><?php echo e($quotations->discount); ?>%</td>
                                </tr>
                                <tr>
                                    <th colspan="10" class="text-center" style="border:1px solid black;">
                                        Discounted&nbsp;Amount</th>
                                    <td style="border:1px solid black;"><?php echo e($quotations->discountedAmt); ?>/-</td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <th colspan="10" class="text-center" style="border:1px solid black;">
                                    Paidup&nbsp;Amount
                                </th>
                                <td style="border:1px solid black;"><?php echo e($quotations->total_paid); ?>/-</td>
                            </tr>
                            <tr>
                                <th colspan="10" class="text-center" style="border:1px solid black;">DueAmount</th>
                                <td style="border:1px solid black;"><?php echo e($quotations->due_amount); ?>/-</td>
                            </tr>
                        </tbody>
                    </table>
                    <table class="mb-4">
                        <tbody>
                            <tr>
                                <p>Above rates are including GST @ 18%, Excluding unloading charge and this are Dhule
                                    warehouse rates.
                                </p>
                            </tr>
                            </tr>
                            <tr>
                                <td colspan="10"><b>Payment Terms &nbsp;:</b>&nbsp;&nbsp;
                                    100% Advance<br>
                                    <b>Delivery Period &nbsp;:</b>&nbsp;&nbsp; 7 TO 8 Days from the date of order /
                                    dispatch
                                    schedule.<br>
                                    <b>Billing
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</b>&nbsp;&nbsp;
                                    GST Billing @ 18%<br>
                                    <b>Validity Of Price :</b>&nbsp;&nbsp; 30 Days from Date of Quotation<br><br>
                                    <p>
                                        We again express our gratitude for your esteemed organization and looking
                                        forward
                                        for a
                                        long and
                                        healthy business relationship. Assuring you of our best service all the
                                        times.<br><br>
                                        Thanking You
                                    </p>
                                    <b>VIRAJ CERAMIC<br>
                                        82852 72727</b>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"
            integrity="sha384-q8i/X+965DzO0rTDNEpUTHQoQUJMHLrErGJyHg89uy71MyuHH+8abtTE1Pi6jizo" crossorigin="anonymous">
        </script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.7/dist/umd/popper.min.js"
            integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous">
        </script>
        <script src="<?php echo e(asset('assets/bootstrap/js/bootstrap.min.js')); ?>"
            integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous">
        </script>
</body>

</html>
<?php /**PATH /home/virajceramics/public_html/admin/resources/views/admin/quotation.blade.php ENDPATH**/ ?>