<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseItems extends Model
{
    use HasFactory;
    public $fillable = ['purchase_id', 'product_id', 'size', 'quality', 'rate', 'coverage', 'available_qty', 'quantity', 'total', 'product_code', 'barcode', 'godown', 'batchno'];

    public function stockOutMany()
    {
        return $this->hasMany(ManagePurchaseItems::class, 'batchno', 'batchno');
    }
    public function stockProducts()
    {
        return $this->hasOne(Product::class, 'id', 'product_id');
    }
}
