<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->id();
            $table->string('client_name')->nullable();
            $table->string('contact')->nullable();
            $table->string('attended_by')->nullable();
            $table->string('attendee_contact')->nullable();
            $table->string('advance_payment')->nullable();
            $table->string('sub_amt')->nullable();
            $table->decimal('gst')->nullable();
            $table->string('payment_type')->nullable();
            $table->string('payment_status')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('total_amount')->nullable();
            $table->string('del_boy_name')->nullable();
            $table->string('del_boy_contact')->nullable();
            $table->string('weight_of_goods')->nullable();
            $table->string('tempo_no')->nullable();
            $table->enum('star_mark', ['0', '1'])->default('0');
            $table->string('header_section')->nullable();
            $table->string('bottom_section')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotations');
    }
};
