@extends ('admin.layouts.master')
@section('content')
    <!-- Blank Start -->
    <div class="container pt-4 px-4">
        <div class="col-12">
            <div class="bg-light rounded h-100 p-4">
                @if (Session::has('message'))
                    <div class="alert alert-success alert-dismissible">
                        <strong> {{ Session::get('message') }} </strong>
                        <button type="button" class="close" data-bs-dismiss="alert">&times;</button>
                    </div>
                @endif

                <div class="row">
                    <div class="bg-light rounded h-100 p-4">
                        <h6 class="mb-4">Change Password</h6>
                        <form action="{{ route('updatePassword') }}" method="POST">
                            @csrf
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Current Password</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="old_pw" placeholder="Old Password"
                                        required>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">New password</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="newpassword" placeholder="New Password"
                                        required>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Confirm Password</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="c_password"
                                        placeholder="Confirm Password" required>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-success">Save Changes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
