@extends ('admin.layouts.master')
@section('content')
    <!-- Blank Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="col-12">
            <div class="bg-light rounded h-100 p-4">
                <x-session-message />
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="mb-4">Outstanding Clients</h6>
                    </div>

                    <div class="col-md-4">
                        {{--  <form class="d-none d-md-flex ms-4">
                            <input class="form-control border-0" type="search" id="search" name="txtsearch"
                                placeholder="Search">

                        </form>  --}}
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exampleModal">
                            + Add Client
                        </button>
                    </div>

                </div>

                <div class="table-responsive">
                    <table class="table" id="example">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Name</th>
                                <th scope="col">Contact</th>
                                <th scope="col">City</th>
                                <th scope="col">Amount</th>
                                <th scope="col">Options</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data as $value)
                                {{-- @dd($value) --}}
                                <tr>
                                    <td>{{ $value->id }}</td>
                                    <td>{{ $value->name }}</td>
                                    <td>{{ $value->mobile }}</td>
                                    <td>{{ $value->city }}</td>
                                    <td>{{ $value->amount }}</td>
                                    <td>

                                        <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                            data-bs-target="#editModal"
                                            onclick="updateclient('{{ $value->id }}','{{ $value->name }}','{{ $value->mobile }}','{{ $value->city }}','{{ $value->amount }}')">
                                            <i class="fa fa-edit"></i>
                                        </button>

                                        <a href="{{ route('deleteClient', $value->id) }}"
                                            onclick="return confirm('Are you sure you want to delete this Client?');"><button
                                                type="button" class="btn btn-square btn-danger m-2"><i
                                                    class="fa fa-trash"></i></button></a>
                                    </td>
                                </tr>
                            @endforeach



                        </tbody>
                    </table>
                    <div class="d-flex justify-content-end my-3">
                        {{ $data->links('pagination::bootstrap-4') }}
                    </div>
                </div>
            </div>
            {{-- Add Quantity Model  --}}
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Add Client</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('storeClient') }}" method="POST">
                            @csrf
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Name:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="name" class="form-control" placeholder="Client Name"
                                            required>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Contact No.:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" name="mobile" class="form-control" placeholder="Contact"
                                            required>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">City:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="city" class="form-control" placeholder="Client City"
                                            required>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Amount:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" name="amount" class="form-control" placeholder="Amount"
                                            required>
                                    </div>
                                </div>
                                <br>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- Edit quantity Model  --}}
            <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Update Client</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('updateClient') }}" method="POST">
                            @csrf
                            <input type="hidden" id="c_id" name="c_id">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Name :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="name" id="cname" class="form-control">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Contact No.:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" name="mobile" id="cmobile" class="form-control"
                                            placeholder="Contact" required>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">City:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="city" id="ccity" class="form-control"
                                            placeholder="Client City" required>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Amount:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" name="amount" id="camount" class="form-control"
                                            placeholder="Amount" required>
                                    </div>
                                </div>

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Blank End -->

    <br>
    <br>
    <br>
    <br>
    <br>
    <br>



    <script>
        function updateclient(id, name, mobile, city, amount) {
            console.log(id);
            document.getElementById('c_id').value = id;
            document.getElementById('cname').value = name;
            document.getElementById('cmobile').value = mobile;
            document.getElementById('ccity').value = city;
            document.getElementById('camount').value = amount;
        }



        //Search Function
        $("#search").keyup(function() {
            var value = this.value.toLowerCase().trim();

            $("table tr").each(function(index) {
                if (!index) return;
                $(this).find("td").each(function() {
                    var id = $(this).text().toLowerCase().trim();
                    var not_found = (id.indexOf(value) == -1);
                    $(this).closest('tr').toggle(!not_found);
                    return not_found;
                });
            });
        });
    </script>
@endsection
