@extends ('admin.layouts.master')
@section('content')
    <!-- Blank Start -->
    <div class="container-fluid pt-4 px-4 mb-5">
        <div class="col-12">
            <div class="bg-light rounded p-4">
                <x-session-message />
                <div class="d-flex justify-content-between mb-2">
                    <h6 class="mb-4">Manage Delivery Challan</h6>
                    <div class="d-flex gap-2">
                        <form class="d-flex" method="GET">
                            <input type="search" class="form-control border-0" name="search" id="search"
                                placeholder="Search">
                            <input type="submit" value="Submit" class="btn btn-success">
                        </form>
                        @if (Request::get('search') != '')
                            <a href="{{ route('manageData') }}" class="btn btn-danger">All Delivery Challan</a>
                        @endif
                    </div>
                    <div></div>
                </div>
                <div class="table-responsive">
                    <table class="table text-center">
                        <thead>
                            <tr>
                                <th>#Sr No</th>
                                <th>Purchase Date</th>
                                <th>Bill No</th>
                                <th>Client name</th>
                                <th>Client Contact</th>
                                <th>Purchase Items</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="text-center">
                            @foreach ($purchaseData as $value)
                                <tr>
                                    <td class="align-middle">{{ $value->id }}</td>
                                    <td class="align-middle">{{ $value->created_at }}</td>
                                    <td class="align-middle">{{ $value->bill_no }}</td>
                                    <td class="align-middle">{{ $value->client_name }}</td>
                                    <td class="align-middle">{{ $value->client_contact }}</td>
                                    <td class="align-middle">{{ $value->count }}</td>
                                    <td class="align-middle">
                                        @auth
                                            @if (Auth::user()->role == 'Admin')
                                                <a href="{{ route('editPurchaseData', $value->id) }}">
                                                    <button type="button" class="btn btn-square btn-success m-2">
                                                        <i class="fa fa-edit"></i>
                                                    </button></a>
                                            @endif
                                        @endauth


                                        @auth
                                            @if (Auth::user()->role == 'Admin')
                                                <a href="{{ route('deletePurchaseData', $value->id) }}"
                                                    onclick="return confirm('Are you sure you want to delete this Delevery Challan?');">
                                                    <button type="button" class="btn btn-square btn-danger m-2"><i
                                                            class="fa fa-trash"></i></button></a>
                                            @endif
                                        @endauth
                                        <a href="{{ route('inventoryDC', $value->id) }}" target="_blank">
                                            <button type="button" class="btn btn-square btn-success m-2">
                                                <i title="Delivery Challan">DC</i>
                                            </button></a>
                                        <a href="{{ route('trackingDetailsData', $value->id) }}">
                                            <button type="button" class="btn btn-square btn-success m-2">
                                                <i title="Tracking Details">TD</i>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="d-flex justify-content-end my-3">
                        {{ $purchaseData->links('pagination::bootstrap-4') }}
                    </div>
                </div>
            </div>
            <div class="modal fade" id="trackingDetailsModal" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Tracking Details</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('trackingDetails') }}" method="POST">
                            @csrf
                            <input type="hidden" id="del_id" name="del_id">
                            <div class="modal-body">
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Date&nbsp;&&nbsp;Time</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="date" name="date" class="form-control">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Status :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <select name="status" class="form-control">
                                            <option value="">~~SELECT~~</option>
                                            <option value="PREDISPATCH">Preparing For Dispatch</option>
                                            <option value="DISPATCH">Dispatched</option>
                                            <option value="ONTHEWAY">On The Way</option>
                                            <option value="DELIVER">Deliver</option>
                                        </select>
                                    </div>
                                </div>
                                <br>
                            </div>
                            <div class="modal-footer justify-content-center">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function manageData(id) {
            document.getElementById('del_id').value = id;
        }
    </script>
@endsection
