@extends('admin.layouts.master')
@section('content')
    <!-- Blank Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="bg-light rounded  p-4">
            <x-session-message />
            <div class="d-flex justify-content-between mb-2">
                <h6 class="mb-4">Manage Product</h6>
                {{--  <div class="d-flex gap-2">
                    <form class="d-flex" method="GET">
                        <input type="search" class="form-control border-0" name="search" id="search" placeholder="Search">
                        <input type="submit" value="Submit" class="btn btn-success">
                    </form>
                    @if (Request::get('search') != '')
                        <a href="{{ route('product') }}" class="btn btn-danger">All Products</a>
                    @endif
                </div>  --}}
                {{--  <div class="d-flex gap-2">
                    <input type="search" class="form-control border-0" name="search" id="search" placeholder="Search">
                </div>  --}}
                {{--  <div>
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exampleModal">
                        +&nbsp;Add&nbsp;Product
                    </button>
                    <a href="{{ route('productPDF') }}" class="btn btn-info" target="_blank"><i class="fa fa-download"
                            aria-hidden="true"></i></a>
                </div>  --}}
            </div>
            <div class="table-responsive">
                <table class="table text-center">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Size</th>
                            <th>Quality</th>
                            <th>Category</th>
                            <th>Type</th>
                            <th>Quantity</th>
                            <th>Rate PerBox</th>
                            {{--  <th>Rate PerSqft</th>  --}}
                            <th>Godown</th>
                            <th>Status</th>
                            <th>Action</th>
                            <th>Qr&nbsp;Code</th>
                            <th>BarCode</th>
                            <th>MRP</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($products as $value)
                            <tr>
                                <td class="align-middle">
                                    <img src="{{ $value->p_image }}" width="70px;" height="70px;" alt="">
                                </td>
                                <td class="align-middle">{{ $value->p_name }}</td>
                                <td class="align-middle">{{ $value->p_size }}</td>
                                @foreach ($qualities as $data)
                                    @if ($data->id == $value->quality_id)
                                        <td class="align-middle"> {{ $data->quality_name }}</td>
                                    @endif
                                @endforeach
                                @foreach ($categories as $item)
                                    @if ($item->id == $value->cat_id)
                                        <td class="align-middle"> {{ $item->categories_name }}</td>
                                    @endif
                                @endforeach
                                <td class="align-middle">{{ $value->type }}</td>
                                <td class="align-middle">{{ $value->current_quantity }}</td>
                                <td class="align-middle">{{ $value->p_rate }}</td>
                                {{--  <td class="align-middle">{{ $value->p_rate_p_sqft }}</td>  --}}
                                @php
                                    $godowns = str_replace(']', '', $value->godown);
                                    $godowns = str_replace('[', '', $godowns);
                                    $godowns = str_replace('"', '', $godowns);
                                    $godowns = str_replace(',', ', ', $godowns);
                                @endphp
                                <td class="align-middle">{{ strtoupper($godowns) }}</td>
                                <td class="align-middle">
                                    @if ($value->availability == 'AVAILABLE')
                                        <label class="p-1  bg-success text-white">AVAIL</label>
                                    @elseif ($value->availability == 'NOT-AVAILABLE')
                                        <label class="p-1  bg-danger text-white">NOT-AVAIL</label>
                                    @endif
                                </td>
                                <td class="align-middle">
                                    @auth
                                        @if (Auth::user()->role == 'Admin')
                                            <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                                data-bs-target="#editModal"
                                                onclick="updateProduct('{{ $value->id }}','{{ $value->cat_id }}','{{ $value->quality_id }}','{{ $value->type }}','{{ $value->p_image }}','{{ $value->p_name }}','{{ $value->p_size }}','{{ $value->p_pcinbox }}','{{ $value->p_rate }}','{{ $value->availability }}','{{ $value->godown }}')">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        @endif
                                    @endauth
                                    @auth
                                        @if (Auth::user()->role == 'Admin')
                                            <a href="{{ route('deleteProduct', $value->id) }}"
                                                onclick="return confirm('Are you sure you want to delete this Product?');"><button
                                                    type="button" class="btn btn-square btn-danger m-2"><i
                                                        class="fa fa-trash"></i></button></a>
                                        @endif
                                    @endauth
                                    <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                        data-bs-target="#itemModal" onclick="updateCat('{{ $value->id }}')">
                                        <i class="fa fa-eye"></i>
                                    </button>
                                </td>
                                @php
                                    $quality = $value->quality->quality_name;
                                    $qr = QrCode::size(50)->generate(
                                        "$value->id.Name = $value->p_name . Size = $value->p_size . Quality = $quality ",
                                    );
                                    $qr1 = QrCode::size(300)->generate(
                                        "$value->id.Name = $value->p_name . Size = $value->p_size . Quality = $quality",
                                    );
                                @endphp
                                <td class="align-middle">
                                    <button onclick="qrcode('{{ $value->id }}')" data-bs-toggle="modal"
                                        data-bs-target="#qrcode">
                                        <div>{{ $qr }}</div>
                                    </button>
                                    <a href="{{ route('proPdf', $value->id) }}"><i class="fa fa-download"
                                            aria-hidden="true"></i></a>
                                </td>
                                <td class="align-middle">
                                    <div class="text-center">
                                        <a href="{{ route('barcode', $value->id) }}">
                                            {!! DNS1D::getBarcodeSVG($value->product_code, 'C39', 0.4, 50) !!}
                                        </a>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <a href="{{ route('prodMRP', $value->id) }}">
                                        <i class="fa fa-download" aria-hidden="true">MRP</i>
                                    </a>
                                </td>
                                <div id="{{ $value->id }}qr_data" class="d-none">{{ $qr1 }}</div>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-end my-3">
                    {{ $products->links('pagination::bootstrap-4') }}
                </div>

            </div>
        </div>
    @endsection
