@extends ('admin.layouts.master')
@section('content')
    <!-- Blank Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="col-12">
            <div class="bg-light rounded h-100 p-4">
                <x-session-message />
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="mb-4">Manage Quality</h6>
                    </div>

                    <div class="col-md-4">
                        <form class="d-none d-md-flex ms-4">
                            <input class="form-control border-0" type="search" id="search" name="txtsearch"
                                placeholder="Search">

                        </form>
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-success" data-bs-toggle="modal"
                            data-bs-target="#exampleModal">
                            + Add Quality
                        </button>
                    </div>

                </div>

                <div class="table-responsive">
                    <table class="table" id="example">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Quality</th>
                                <th scope="col">Status</th>
                                <th scope="col">Options</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data as $value)
                                {{-- @dd($value) --}}
                                <tr>
                                    <td>{{ $value->id }}</td>
                                    <td>{{ $value->quality_name }}</td>
                                    <td>
                                        @if ($value->availability == 'AVAILABLE')
                                            <label class="p-2 mb-2 bg-success text-white">AVAILABLE</label>
                                        @elseif ($value->availability == 'NOT-AVAILABLE')
                                            <label class="p-2 mb-2 bg-danger text-white">NOT-AVAILABLE</label>
                                        @endif
                                    </td>
                                    <td>

                                        <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                            data-bs-target="#editModal"
                                            onclick="updatequantity('{{ $value->id }}','{{ $value->quality_name }}','{{ $value->availability }}')">
                                            <i class="fa fa-edit"></i>
                                        </button>

                                        <a href="{{ route('deleteQuality', $value->id) }}"
                                            onclick="return confirm('Are you sure you want to delete this Quality?');"><button
                                                type="button" class="btn btn-square btn-danger m-2"><i
                                                    class="fa fa-trash"></i></button></a>
                                    </td>
                                </tr>
                            @endforeach



                        </tbody>
                    </table>
                    <div class="d-flex justify-content-end my-3">
                        {{ $data->links('pagination::bootstrap-4') }}
                    </div>
                </div>
            </div>
            {{-- Add Quantity Model  --}}
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Add Quality</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('storeQuality') }}" method="POST">
                            @csrf
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Quality :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="quality_name" class="form-control"
                                            placeholder="Quality Name" required>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Status :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <select id="availability" name="availability" class="form-control" required>
                                            <option value="">~~SELECT~~</option>
                                            <option value="AVAILABLE">Available</option>
                                            <option value="NOT-AVAILABLE">Not-Available</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- Edit quantity Model  --}}
            <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Update Quality</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('updateQuality') }}" method="POST">
                            @csrf
                            <input type="hidden" id="q_id" name="q_id">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Quality :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="quality_name" id="quality_name"
                                            class="form-control">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Status :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <select id="availability_status" name="availability_status" class="form-control">
                                            <option value="">select</option>
                                            <option value="AVAILABLE">AVAILABLE</option>
                                            <option value="NOT-AVAILABLE">NOT-AVAILABLE</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Blank End -->

    <br>
    <br>
    <br>
    <br>
    <br>
    <br>



    <script>
        function updatequantity(id, quality_name, availability) {
            console.log(id);
            document.getElementById('q_id').value = id;
            document.getElementById('quality_name').value = quality_name;
            document.getElementById('availability_status').value = availability;
        }



        //Search Function
        $("#search").keyup(function() {
            var value = this.value.toLowerCase().trim();

            $("table tr").each(function(index) {
                if (!index) return;
                $(this).find("td").each(function() {
                    var id = $(this).text().toLowerCase().trim();
                    var not_found = (id.indexOf(value) == -1);
                    $(this).closest('tr').toggle(!not_found);
                    return not_found;
                });
            });
        });
    </script>
@endsection
