<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Quotation</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css"
        integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
</head>
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    html {
        margin: 10px;
        margin-top: 20px;
    }


    h2 {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        margin: 10px;
    }

    body {
        width: 100%;
        height: 100%;
        margin: 0 auto;
    }

    .wrapper {
        margin: 10px auto;
        padding: 20px 4px;
    }

    .delivery-challan {
        color: #212529;
        font-size: 20px;
    }

    .text-center {
        text-align: center;
    }

    .card {
        padding: 1rem;
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-radius: 0.25rem;
        text-align: left;
        font-weight: bold;
    }

    .card-title {
        color: #212529;
        font-size: 18px;
    }

    .headerDiv .logo {
        width: 40%;
        text-align: center;
    }

    .card-text {
        font-size: 16px;
        color: rgb(33, 37, 41);

    }

    .bank-details {
        padding: 8px;
        font-weight: bold;
    }

    table {
        width: 100%;
        text-align: center;
    }

    table,
    th,
    td {
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-collapse: collapse;
        padding: 10px 0px;
        word-wrap: break-word;

    }

    .terms {
        text-align: left;
        border-radius: 0.25rem;
    }

    .terms td {
        padding: 8px;
    }

    .footer td {
        padding: 10px;
    }

    .dark-border {
        border: 1px solid rgb(0, 0, 0);
    }

    .remove-border {
        border: none;
    }

    .p-2 {
        padding: 8px 0.2rem !important;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        text-align: center;
        margin: 20px 0;
    }

    table th,
    table td {
        border: 1px solid #000;
        padding: 8px;
        word-break: break-word;
    }

    .text-center {
        text-align: center;
    }

    .logo img {
        max-width: 200px;
        height: auto;
    }
</style>

<body>
    <div class="wrapper">
        
        <div class="text-start">
            <p class="card-text" style="width: 90%;margin: auto;font-weight: 600; margin-top: 0px; font-size: 14px">
            <div class="logo">
                <img src="<?php echo e(public_path('assets/viraj_logo.png')); ?>" alt="logo"
                    style="width:200px !important; height:200px !important; margin-bottom:-30px;">
            </div>

        </div>
        <div class="text-right">

            <p class="card-text" style="font-weight: bold;font-size:14px; margin-top:-100px;margin-right:15px;">87/6,
                Balapur, Fagna
                Opp Hotel <br>Sheetal, Parola Road,
                Dhule<br>
                GSTIN No.: 27ADAPJ5841K1ZG<br>
                Mb: 9373943349<br>
                Email: viraj_ceramics@yahoo.com<br></p>
            </p>
        </div>
        <hr style="width: 96%;margin-left: auto;margin-right: auto;color: rgba(0, 0, 0, 0.514);
    border: solid;">
        <div class="text-center" style="margin-top:-25px;">
            <h2><u style=color:black;><i>Quotation</i></u></h2>
        </div>
        <table style="border: none; margin: 0 auto; width: 98%" class="text-center">
            <tbody>
                <tr>
                    <th style="text-align: left; border: none">Name,</th>
                    <th style="border: none; text-align: right;">
                        Date: <?php echo e($quotation->created_at->format('d/m/Y')); ?>

                    </th>

                </tr>
                <tr style="margin-top:-25px;margin-bottom:-25px;">
                    <th style="text-align: left; border: none;">
                        <span style="font-size:20px;"><?php echo e($quotation->client_name); ?></span><br>
                        
                    </th>
                    
                </tr>
                <tr style="margin-top:-25px;">
                    <th style="text-align: left; border: none;">
                        Mobile No.:<?php echo e($quotation->contact); ?><br>
                        
                    </th>

                </tr>
                <tr>
                    <th style="text-align: left; border: none;">Attended By
                        :&nbsp;&nbsp;&nbsp;<?php echo e($quotation->attended_by); ?>(<?php echo e($quotation->attendee_contact); ?>)
                    </th>
                </tr>
                
            </tbody>
        </table>

        <p style="font-size: 16px;color: rgb(33, 37, 41); margin: 0 auto;padding:0px 15px 0 15px;margin-top:-15px;">
            This is with reference to our discussion with you regarding your requirement; here we
            quote our best price for your prestigious project as below:
        </p>

        <div style="margin-top: -20px;width:96%;padding:0 15px;">
            <table class="table table-bordered">
                <thead class="text-center">
                    <tr>
                        <th style="border:1px solid gray; width: 20px" class="p-2">Sr.No</th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">Size</th>
                        <th width="10%" style="border:1px solid gray;"><?php echo e($type == 'code' ? 'Code' : 'Name'); ?>

                        </th>
                        
                        
                        <th style="border:1px solid gray; width: 7%" class="p-2">Type</th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">MRP Rate Per Sqft</th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">Final Rate Per Sqft</th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">MRP Rate Per Box</th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">Final Rate Per Box</th>
                        
                        
                        <th style="border:1px solid gray; width: 5%" class="p-2">Box</th>
                        <th style="border:1px solid gray; width: 7%" class="p-2">MRP Amount</th>
                        <th style="border:1px solid gray; width: 6%" class="p-2">DiscAmt</th>
                        
                        <th style="border:1px solid gray; width: 14%" class="p-2">Final Total</th>
                    </tr>
                </thead>
                <tbody class="text-center" style="text-size:9px !important;">
                    <?php
                        $tot_weight = 0;
                        $finaltotal = 0;
                        $disctotal = 0;
                        $grandtotal = 0;
                        $count = 0;
                    ?>
                    <?php $__currentLoopData = $quotationItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $cov = $value->coverage != '' ? $value->coverage : 1;
                            $totbox = $value->unit_send != null ? $value->unit_send : $value->box;
                            $calculate = round((float) $cov * (float) $totbox * (float) $value->rate, 2);

                            $count++;
                            $p_name = '';
                            $p_image = '';
                            //$discountAmt = ($value->initial_rate - $value->rate) * $value->coverage * $value->box;
                            $MrptotalAmt =
                                $value->initial_rate !== null
                                    ? $value->initial_rate * $value->coverage * $value->box
                                    : 0;
                            $discountAmt =
                                $value->initial_rate !== null
                                    ? ($value->initial_rate - $value->rate) * $value->coverage * $value->box
                                    : 0;
                        ?>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($prod->id == $value->product_id): ?>
                                <?php
                                    $p_name = $type == 'code' ? $prod->id : $prod->p_name;
                                    $p_image = $prod->p_image;
                                    $p_type = $prod->type;
                                ?>
                                <tr>
                                    <td style="border:1px solid gray; width: 5%" class="p-2"><?php echo e($count); ?></td>
                                    <td style="border:1px solid gray; width: 5%" class="p-2"><?php echo e($value->size); ?></td>
                                    <td style="border:1px solid gray; width: 10%; font-size: 15px" class="p-2">
                                        <?php echo e($p_name); ?></td>

                                    
                                    
                                    <td style="border:1px solid gray; width: 10%; font-size: 15px" class="p-2">
                                        <?php echo e($p_type); ?></td>
                                    <td style="border:1px solid gray; width: 6%" class="p-2">
                                        <?php echo e($value->initial_rate); ?>

                                    <td style="border:1px solid gray; width:6%" class="p-2"><?php echo e($value->rate); ?>

                                    <td style="border:1px solid gray; width: 6%" class="p-2">
                                        <?php echo e($value->p_rate_p_box); ?>

                                    </td>
                                    <td style="border:1px solid gray; width: 6%" class="p-2">
                                        <?php echo e($value->f_rate_p_box); ?>

                                    </td>
                                    
                                    <td style="border:1px solid gray; width: 6%" class="p-2">
                                        <?php echo e($value->unit_send != null ? $value->unit_send : $value->box); ?></td>
                                    
                                    
                                    <td style="border:1px solid gray; width: 8%" class="p-2"><?php echo e($MrptotalAmt); ?>/-
                                    </td>
                                    <td style="border:1px solid gray; width: 8%" class="p-2"><?php echo e($discountAmt); ?>/-
                                    </td>
                                    

                                    
                                    <td style="border:1px solid gray; width: 10%" class="p-2">
                                        <?php echo e($value->total); ?>/-
                                    </td>
                                    <?php
                                        $tot_weight += $value->total_weight;
                                        //$grandtotal += $calculate - 0;
                                        $finaltotal += $MrptotalAmt;
                                        $disctotal += $discountAmt;
                                        $grandtotal += $value->total;
                                    ?>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th colspan="11" class="text-center"
                            style="border:1px solid gray;padding: .50rem !important;">Freight Charges</th>
                        <td style="border:1px solid gray;padding: .50rem !important;">
                            <?php echo e($quotation->freight_charges); ?>/-
                        </td>
                    </tr>
                    <tr>
                        <th colspan="11" class="text-center"
                            style="border:1px solid gray;padding: .50rem !important;">Final Total</th>
                        <td style="border:1px solid gray;padding: .50rem !important;"><?php echo e($finaltotal); ?>/-
                        </td>
                    </tr>
                    <tr>
                        <th colspan="11" class="text-center"
                            style="border:1px solid gray;padding: .50rem !important;">Total Discount Amount</th>
                        <td style="border:1px solid gray;padding: .50rem !important;"><?php echo e($disctotal); ?>/-</td>
                    </tr>
                    
                    <tr>
                        <th colspan="11" class="text-center"
                            style="border:1px solid gray;padding: .50rem !important;">Grand&nbsp;Total
                        </th>
                        <?php
                            $fctot_amount = $grandtotal + $quotation->freight_charges;
                        ?>
                        <td style="border:1px solid gray;padding: .50rem !important;">
                            <?php echo e($fctot_amount); ?>/-</td>
                    </tr>
                    <?php if($quotation->discount !== null && $quotation->discount !== 0): ?>
                        <tr>
                            <th colspan="11" class="text-center"
                                style="border:1px solid gray;padding: .50rem !important;">Discount in %</th>
                            <td style="border:1px solid gray;padding: .50rem !important;"><?php echo e($quotation->discount); ?>/-
                            </td>
                        </tr>
                        <tr>
                            <th colspan="11" class="text-center"
                                style="border:1px solid gray;padding: .50rem !important;">
                                Discounted&nbsp;Amount
                            </th>
                            <td style="border:1px solid gray;padding: .50rem !important;">
                                <?php echo e($quotation->discountedAmt); ?>/-</td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <th colspan="11" class="text-center"
                            style="border:1px solid gray;padding: .50rem !important;">Received&nbsp;Amount
                        </th>
                        <td style="border:1px solid gray;padding: .50rem !important;"><?php echo e($quotation->total_paid); ?>/-
                        </td>
                    </tr>
                    <tr>
                        <th colspan="11" class="text-center"
                            style="border:1px solid gray;padding: .50rem !important;">Due Amount</th>
                        
                        <?php
                            $fcdue_amount = $quotation->due_amount;
                        ?>


                        <td style="border:1px solid gray;padding: .50rem !important;"><?php echo e($fcdue_amount); ?>/-
                        </td>
                    </tr>
                </tbody>
            </table>
            
            <b>Payment Terms &nbsp;:</b>&nbsp;&nbsp;
            100% Advance<br>
            <b>Delivery Period &nbsp;:</b>&nbsp;&nbsp; 7 TO 8 Days from the date of order / dispatch
            schedule.<br>
            <b>Billing &nbsp;&nbsp;:</b>

            Above
            Rates are Including GST<br><br>
            
            <h5 style="font-weight: 700;">BANK DETAILS:</h5>
            <b>BANK NAME:</b>&nbsp;&nbsp; HDFC BANK<br>
            <b>ACCOUNT NO. :</b>&nbsp;&nbsp; 50200037712596<br>
            <b>IFSC CODE :</b>&nbsp;&nbsp; HDFC0000637<br>
            <b>BRANCH :</b>&nbsp;&nbsp; DHULE <br><br>
            <b>BANK NAME:</b>&nbsp;&nbsp; THE HASTI CO-OP BANK LTD<br>
            <b>ACCOUNT NO. :</b>&nbsp;&nbsp; 007001100000021<br>
            <b>IFSC CODE :</b>&nbsp;&nbsp; HCBL0000107<br>
            <b>BRANCH :</b>&nbsp;&nbsp; DHULE <br>
            <p>
                We again express our gratitude for your esteemed organization and looking forward
                for a
                long and
                healthy business relationship. Assuring you of our best service all the
                times.<br><br>
                Thanking You
            </p>
            <b>VIRAJ CERAMICS<br>
                9373943349<br>
        </div>
    </div>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\Priyanka_Project\VirajCeramics\resources\views/admin/quotationMainPDF.blade.php ENDPATH**/ ?>