<?php $__env->startSection('content'); ?>
    <div class="container-fluid pt-4 px-4 mb-5">
        <div class="bg-light rounded p-4">
            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.session-message','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('session-message'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
            <form action="<?php echo e(route('storePurchase')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="bg-light rounded p-4">
                        <h6 class="mb-4">Add Inventory</h6>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label">Purchase Date</label>
                            <div class="col-md-10">
                                <input type="date" class="form-control" name="purchase_data" required
                                    value="<?php echo e(date('Y-m-d')); ?>">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label">Bill No</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="bill_no" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label">Client Name</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="client_name" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label">Client Contact</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="client_contact" pattern="[0-9]{10}"
                                    maxlength="10" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table text-center" id="dynamicTable">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th style="width:9%;">Size</th>
                                <th style="width:9%;">Quality</th>
                                <th>Rate</th>
                                <th>Cov</th>
                                <th>BatchNo</th>
                                <th>Avl&nbsp;Qty</th>
                                <th>Quantity</th>
                                <th>Total</th>
                                <th>GoDown</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
                <br>
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label">SubAmount :</label>
                    <div class="col-sm-10">
                        <input type="number" class="form-control" id="subTotal" name="subTotal" readonly />
                    </div>
                </div>
                <div class="form-group submitButtonFooter">
                    <div class="text-center">
                        <button type="button" class="btn btn-success" onclick="addRow();" data-loading-text="Loading...">
                            <i class="glyphicon glyphicon-plus-sign"></i> Add Row
                        </button>
                        <button type="submit" id="createQuotationBtn" data-loading-text="Loading..."
                            class="btn btn-success"><i class="glyphicon glyphicon-ok-sign"></i> Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script type="text/javascript">
        let product = <?php echo json_encode($products, 15, 512) ?>;
        let quality = <?php echo json_encode($quality, 15, 512) ?>;
        var prod = 0;

        function getProdData(e) {
            let row_id = e.id.replace("prod_name", "");
            let sizes = [];
            product.forEach(element => {
                if (element.p_name.toUpperCase() == e.value.toUpperCase()) {
                    sizes.push(element.p_size.toLowerCase());
                }
            });
            sizes = [...new Set(sizes)];
            let optionHtml = '<option>~SELECT~</option>';
            sizes.forEach(e => {
                optionHtml += `<option value="${e}">${e}</option>`;
            })
            document.getElementById(`productSize${row_id}`).innerHTML = optionHtml;
            document.getElementById(`productQuality${row_id}`).innerHTML = "<option>~SELECT~</option>";
            document.getElementById(`productrate${row_id}`).value = "";
            document.getElementById(`coverage${row_id}`).value = "";
            document.getElementById(`batch_no${row_id}`).value = "";
            document.getElementById(`avl_quantity${row_id}`).value = "";
            document.getElementById(`quantity${row_id}`).value = "";
            document.getElementById(`totalbalance${row_id}`).value = "";
            document.getElementById(`product_id${row_id}`).value = "";
            document.getElementById(`godown_Data${row_id}`).innerHTML = "";
            calculateSub();

        }

        function getProductSizeData(p) {
            let id = p.id.replace("productSize", "");
            let productName = document.getElementById(`prod_name${id}`).value;
            let optionHtml = '<option>~SELECT~</option>';

            let currentQualities = [];

            product.forEach(prod => {
                if (prod.p_name.toUpperCase() == productName.toUpperCase() && prod.p_size.toLowerCase() == p.value
                    .toLowerCase()) {
                    let currentQuality = quality.find(e => e.id == prod.quality_id);
                    currentQualities.push(currentQuality.quality_name);
                }
            });
            currentQualities = [...new Set(currentQualities)];
            currentQualities.forEach(e => {
                optionHtml += `<option value="${e}">${e}</option>`;
            })
            document.getElementById(`productQuality${id}`).innerHTML = optionHtml;
        }

        function getProductQty(q) {
            let prodId = q.id.replace("productQuality", "");
            let productName = document.getElementById(`prod_name${prodId}`).value;
            let size = document.getElementById(`productSize${prodId}`).value;
            let qualityId = quality.find(e => e.quality_name == q.value).id;
            for (let index = 0; index < product.length; index++) {
                const element = product[index];
                // console.log(element);
                if (element.p_name.toUpperCase() == productName.toUpperCase() && element.p_size.toLowerCase() == size
                    .toLowerCase() && element.quality_id == qualityId) {
                    document.getElementById(`avl_quantity${prodId}`).value = element.current_quantity;
                    document.getElementById(`productrate${prodId}`).value = element.p_rate;
                    let godownData = JSON.parse(element.godown);
                    let optionHtml = '';
                    godownData.forEach(function(element) {
                        optionHtml += `<option>${element}</option>`;
                    });
                    document.getElementById(`godown_Data${prodId}`).innerHTML = optionHtml.toUpperCase();
                    break;
                }
            }
        }

        function updateTotal(row_id) {
            let totalEle = document.getElementById(`totalbalance${row_id}`);
            let availEle = document.getElementById(`avl_quantity${row_id}`);
            let coverage = document.getElementById(`coverage${row_id}`);
            let rate = document.getElementById(`productrate${row_id}`);
            let qtyEle = document.getElementById(`quantity${row_id}`);
            let prodIdEle = document.getElementById(`product_id${row_id}`);

            if (rate.value != "" && coverage.value != "" && qtyEle.value != "" && qtyEle.value > 0 && coverage.value > 0 &&
                rate.value > 0 && !qtyEle.value.includes("e") && !coverage.value.includes("e") && !rate.value.includes(
                    "e") && !qtyEle.value.includes("E") && !coverage.value.includes("E") && !rate.value.includes("E")) {
                totalEle.value = parseFloat(qtyEle.value) * parseFloat(rate.value) * parseFloat(coverage.value);
            } else {
                totalEle.value = 0;
            }

            let productName = document.getElementById(`prod_name${row_id}`).value;
            let size = document.getElementById(`productSize${row_id}`).value;
            let qualityId = quality.find(e => e.quality_name == document.getElementById(`productQuality${row_id}`)
                .value).id;
            let productDb = product.find(e => e.p_name.toUpperCase() == productName.toUpperCase() && e.p_size
                .toLowerCase() == size.toLowerCase() &&
                e.quality_id == qualityId);
            if (qtyEle.value > 0 && qtyEle.value != "") {
                availEle.value = parseFloat(productDb.current_quantity) + parseFloat(qtyEle.value);
                prodIdEle.value = productDb.id;
            } else {
                availEle.value = productDb.current_quantity;
            }
            calculateSub();
        }

        function calculateSub() {
            let subtotal = 0;
            for (let x = 0; x <= prod; x++) {
                let current = document.getElementById(`totalbalance${x}`);
                if (current != null && current.value != "") {
                    subtotal += parseFloat(current.value);
                }
            }
            document.getElementById('subTotal').value = subtotal.toFixed(2);
        }

        function addRow() {
            html =
                `<tr id="faqs-row${prod}" style="text-align:center">;
        <td><select class="form-control" name="prod_name[]" id="prod_name${prod}" onchange="getProdData(this);"><option value="">~SELECT~</option>`;
            let uniqueProductNames = product.map((item) => item.p_name.toUpperCase());
            uniqueProductNames = [...new Set(uniqueProductNames)];
            uniqueProductNames.forEach((element) => {
                html += `<option value="${element}">${element}</option>`;
            });
            html += `</select></td>
                <td><select class="form-control" name="productSize[]" id="productSize${prod}" onchange="getProductSizeData(this)"><option>~SELECT~</option></select></td>;
                <td> <select class="form-control" name="productQuality[]" id="productQuality${prod}" onchange="getProductQty(this)"><option>~SELECT~</option></select></td>
                <td><input type="text" name="productrate[]" id="productrate${prod}" class="form-control" oninput="updateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"></td>
                <td><input type="text" name="coverage[]" id="coverage${prod}" class="form-control" oninput="updateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"/></td>
                <td><input type="text" name="batch_no[]" id="batch_no${prod}" class="form-control" value="0" oninput="getBatchno(this)" required></td>
                <td><input type="text" class="form-control" name="avl_quantity[]" id="avl_quantity${prod}" readonly/></td>
                <td><input type="text" name="quantity[]" id="quantity${prod}" class="form-control" oninput="updateTotal(${prod})" pattern="[0-9]+(\.[0-9]{1,2})?"></td>
                <td>
                    <input type="hidden" name="product_id[]" id="product_id${prod}">
                    <input type="text" name="totalbalance[]" id="totalbalance${prod}" class="form-control" readonly>
                    </td>
                <td><select name="godown[]" id="godown_Data${prod}"><option>~SELECT~</option></select></td></select></td>
                <td style="color: red" onclick="$('#faqs-row${prod}').remove();"><i class="fa fa-trash" aria-hidden="true"></i></td>
                </tr>`;
            $('#dynamicTable tbody').append(html);
            prod++;
        }
        addRow();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Priyanka_Project\VirajCeramics\resources\views/admin/purchase.blade.php ENDPATH**/ ?>