<?php

namespace App\Http\Controllers;

//use PDF;
use App\Models\Type;
use App\Models\User;
use App\Models\Notes;
use App\Models\Client;
use App\Models\Product;
use App\Models\Quality;
use App\Models\Category;
use App\Models\Purchase;
use Milon\Barcode\DNS1D;
use App\Models\Quotation;
use App\Helpers\AppHelpers;
use Illuminate\Support\Str;
use App\Models\TrackingData;
use Illuminate\Http\Request;
use App\Models\PurchaseItems;
use App\Models\ManagePurchase;
use App\Models\QuotationItems;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\QuotationPayment;
use Illuminate\Support\Facades\DB;
use App\Models\ManagePurchaseItems;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Pagination\LengthAwarePaginator;

class DashboardController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function addUser()
    {
        $user = User::orderBy('id', 'ASC')->paginate(20);
        return view('admin.addUser', compact('user'));
    }

    public function storeUser(Request $request)
    {
        $request->validate([
            'mobile' => ['required', 'numeric', 'digits:10', 'unique:users,mobile'],
        ]);

        $user = new User;
        $user->name = $request->user_Name;
        $user->password = Hash::make($request->password);
        $user->email = $request->email;
        $user->role = $request->role;
        $user->mobile = $request->mobile;
        $user->save();
        return redirect()->route('addUser')->with('message', 'User Data Saved Successfully');
    }

    public function updateUser(Request $request)
    {
        $quality = User::find($request->user_id);
        $quality->update([
            'name' => $request->u_name,
            'password' => Hash::make($request->pass),
        ]);

        return redirect()->back()->with('message', 'You have successfully Update Username');
    }

    public function deleteUser(Request $request, $id)
    {
        $user = User::find($id);
        if ($user) {
            $user->delete();
            return redirect()->back()->with('message', 'User deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'User Not Found');
        }
    }

    public function changePassword()
    {

        return view('admin.changePw');
    }

    public function updatePassword(Request $request)
    {

        $user_id = Auth::user()->id;
        $emp_data = User::Where('id', $user_id)->first();
        $emp_password = $emp_data->password;

        if (Hash::check($request->old_pw, $emp_password)) {
            if ($request->old_pw == $request->newpassword) {
                return redirect()->route('changePassword')->with('message', "Old and New Password is similar please enter new password");
            }

            $EmployeeModel = User::find($user_id);
            $EmployeeModel->password = Hash::make($request->newpassword);
            $EmployeeModel->save();
            return redirect()->route('changePassword')->with('message', "Password Updated Successfully");
        } else {
            return redirect()->route('changePassword')->with('message', "Password Does Not Match");
        }
    }

    public function quality()
    {
        $data = Quality::orderBy('id', 'asc')->paginate(10);
        return view('admin.quality', compact('data'));
    }

    public function searchQuality(Request $request)
    {
        $quality = $request->txtsearch;
        $quality = DB::select('SELECT * FROM `qualities` WHERE `quality_name` LIKE ' % $quality % '');
        return view('admin.quality', compact('quality'));
    }

    public function storeQuality(Request $request)
    {
        $qualityData = new Quality;
        $qualityData->quality_name = strtoupper($request->quality_name);
        $qualityData->availability = $request->availability;
        $qualityData->save();
        return redirect()->route('quality')->with('message', 'Data Saved Successfully');
    }
    public function deleteQuality(Request $request)
    {
        $quality = Quality::find($request->id);
        if ($quality) {
            $quality->delete();
            return redirect()->back()->with('message', 'Quality deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Quality Not Found');
        }
    }
    public function updateQuality(Request $request)
    {
        $quality = Quality::find($request->q_id);
        $quality->update([
            'quality_name' => strtoupper($request->quality_name),
            'availability' => $request->availability_status,

        ]);

        return redirect()->back()->with('message', 'You have successfully Update Quality');
    }
    public function type()
    {
        $data = Type::orderBy('id', 'asc')->paginate(10);
        return view('admin.type', compact('data'));
    }


    public function storetype(Request $request)
    {
        $typeData = new Type;
        $typeData->name = strtoupper($request->name);
        $typeData->save();
        return redirect()->route('type')->with('message', 'Data Saved Successfully');
    }
    public function deletetype(Request $request)
    {
        $type = Type::find($request->id);
        if ($type) {
            $type->delete();
            return redirect()->back()->with('message', 'Type deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Type Not Found');
        }
    }
    public function updatetype(Request $request)
    {
        $typeData = Type::find($request->t_id);
        $typeData->name = strtoupper($request->name);
        $typeData->save();

        return redirect()->back()->with('message', 'You have successfully Update Type');
    }
    public function category()
    {
        $data = Category::orderBy('id', 'asc')->paginate(10);
        return view('admin.category', compact('data'));
    }
    public function storeCategory(Request $request)
    {
        $qualityData = new Category;
        $qualityData->categories_name = strtoupper($request->categories_name);
        $qualityData->availability = $request->availability;
        $qualityData->save();
        return redirect()->route('category')->with('message', 'Data Saved Successfully');
    }
    public function deleteCategory(Request $request)
    {
        $quality = Category::find($request->id);
        if ($quality) {
            $quality->delete();
            return redirect()->back()->with('message', 'Category deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Category Not Found');
        }
    }
    public function updateCategory(Request $request)
    {
        $category = Category::find($request->cat_id);
        $category->update([
            'categories_name' => strtoupper($request->categories_name),
            'availability' => $request->availability_status,
        ]);
        return redirect()->back()->with('message', 'You have successfully Update Quality');
    }

    // public function product(Request $request)
    // {
    //     $search = $request->get('search');

    //     if ($search != null) {
    //         $qualities = Quality::where("quality_name", 'like', '%' . $search . '%')->pluck('id')->toArray();
    //         $products = Product::with(['quality', 'purchaseItems', 'managePurchaseItems'])->where('p_name', 'like', '%' . $search . '%')->orwherein('quality_id', $qualities)->orderBy('p_name')->paginate(10);
    //         $products->map(function ($product) {
    //             $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->managePurchaseItems->sum('box');
    //             $batchNumbers = $product->purchaseItems->pluck('batchno')->unique();
    //             $tempBatches = [];
    //             foreach ($batchNumbers as $batchNumber) {
    //                 $temp["batchno"] = $batchNumber;
    //                 $temp["quantity"] = $product->purchaseItems->where('batchno', $batchNumber)->sum('quantity') - $product->managePurchaseItems->where('batchno', $batchNumber)->sum('box');
    //                 array_push($tempBatches, $temp);
    //             }
    //             $product->batches = $tempBatches;
    //             return $product;
    //         });
    //         $products->withPath('product')->appends(['search' => $search]);
    //     } else {
    //         $products = Product::with(['quality', 'purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->paginate(10);
    //         $products->map(function ($product) {
    //             $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->managePurchaseItems->sum('box');
    //             $batchNumbers = $product->purchaseItems->pluck('batchno')->unique();
    //             $tempBatches = [];
    //             foreach ($batchNumbers as $batchNumber) {
    //                 $temp["batchno"] = $batchNumber;
    //                 $temp["quantity"] = $product->purchaseItems->where('batchno', $batchNumber)->sum('quantity') - $product->managePurchaseItems->where('batchno', $batchNumber)->sum('box');
    //                 array_push($tempBatches, $temp);
    //                 $availablequantity = $product->purchaseItems->where('batchno', $batchNumber)->sum('quantity') - $product->managePurchaseItems->where('batchno', $batchNumber)->sum('box');
    //                 $purch_item = PurchaseItems::where('batchno', $batchNumber)->first();
    //                 $purch_item->available_qty = $availablequantity;
    //                 $purch_item->save();
    //             }
    //             $product->batches = $tempBatches;
    //             return $product;
    //         });
    //     }
    //     $qualities = Quality::orderBy('id')->get();
    //     $categories = Category::orderBy('id')->get();
    //     $type = Type::get();
    //     return view('admin.product', compact('products', 'qualities', 'categories', 'type'));
    // }

    public function product(Request $request)
    {
        $search = $request->get('search');

        if ($search != null) {
            $qualities = Quality::where("quality_name", 'like', '%' . $search . '%')->pluck('id')->toArray();
            // $products = Product::with(['quality', 'purchaseItems', 'managePurchaseItems'])->where('p_name', 'like', '%' . $search . '%')->orwherein('quality_id', $qualities)->orderBy('p_name')->paginate(10);
            $products = Product::with(['quality', 'purchaseItems', 'quotationItems', 'managePurchaseItems'])->where('p_name', 'like', '%' . $search . '%')->orwherein('quality_id', $qualities)->orderBy('p_name')->paginate(10);
            $products->map(function ($product) {
                $product->remain_quontity = $product->quotationItems->sum('box') - $product->quotationItems->sum('unit_remain');
                // $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->managePurchaseItems->sum('box');
                $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->remain_quontity;
                $batchNumbers = $product->purchaseItems->pluck('batchno')->unique();
                $tempBatches = [];
                foreach ($batchNumbers as $batchNumber) {
                    $temp["batchno"] = $batchNumber;
                    $temp["quantity"] = $product->purchaseItems->where('batchno', $batchNumber)->sum('quantity') - $product->managePurchaseItems->where('batchno', $batchNumber)->sum('box');
                    array_push($tempBatches, $temp);
                }
                $product->batches = $tempBatches;
                return $product;
            });
            $products->withPath('product')->appends(['search' => $search]);
        } else {
            // $products = Product::with(['quality', 'purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->paginate(10);
            $products = Product::with(['quality', 'purchaseItems', 'quotationItems', 'managePurchaseItems'])->orderBy('p_name')->paginate(10);
            $products->map(function ($product) {
                $product->remain_quontity = $product->quotationItems->sum('box') - $product->quotationItems->sum('unit_remain');
                // $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->managePurchaseItems->sum('box');
                $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->remain_quontity;
                $batchNumbers = $product->purchaseItems->pluck('batchno')->unique();
                $tempBatches = [];
                foreach ($batchNumbers as $batchNumber) {
                    $temp["batchno"] = $batchNumber;
                    $temp["quantity"] = $product->purchaseItems->where('batchno', $batchNumber)->sum('quantity') - $product->managePurchaseItems->where('batchno', $batchNumber)->sum('box');
                    array_push($tempBatches, $temp);
                    $availablequantity = $product->purchaseItems->where('batchno', $batchNumber)->sum('quantity') - $product->managePurchaseItems->where('batchno', $batchNumber)->sum('box');
                    $purch_item = PurchaseItems::where('batchno', $batchNumber)->first();
                    $purch_item->available_qty = $availablequantity;
                    $purch_item->save();
                }
                $product->batches = $tempBatches;
                return $product;
            });
        }
        $qualities = Quality::orderBy('id')->get();
        $categories = Category::orderBy('id')->get();
        $type = Type::get();
        return view('admin.product', compact('products', 'qualities', 'categories', 'type'));
    }

    public function storeProduct(Request $request)
    {
        //dd($request->all());
        $product = new Product;
        $product->p_image = $request->p_image;
        if ($request->hasFile('p_image')) {
            $imageName = AppHelpers::uploadImage($request->p_image, 'product_img');
        } else {
            $imageName = "";
        }
        $product->p_image = $imageName;
        $product->p_name = strtoupper($request->p_name);
        $product->p_size = $request->p_size;
        $product->quality_id = $request->p_quality;
        $product->cat_id = $request->p_category;
        $product->type = $request->type;
        $product->p_pcinbox = $request->p_pcinbox;
        $product->p_mrp_sqft_rate = $request->p_mrp_sqft_rate;
        $product->coverage = $request->coverage;
        $product->p_quantity = '0';
        $product->p_rate_p_box = $request->rate;
        // $product->p_rate_p_sqft = $request->rate_sqft;
        $product->availability = $request->availability;
        $product->video_link = $request->video_link;
        $count = count($request->godown);
        for ($i = 0; $i < $count; $i++) {
            $productData[] = $request->godown[$i];
        }
        $product->godown = json_encode($productData);
        $product->save();
        $productId = $product->id;
        $randAlpha = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'][rand('0', '25')];
        $prodCode = time() . $randAlpha . $productId;
        $prodCode = substr($prodCode, -10);
        $product->product_code = $prodCode;
        $product->save();

        $purchaseData = new Purchase;
        $purchaseData->purchase_date = date('Y-m-d');
        $purchaseData->bill_no = 'Ad1';
        $purchaseData->client_name = auth()->user()->name;
        $purchaseData->client_contact = '';
        $purchaseData->total = '0';
        $purchaseData->status = '1';
        $purchaseData->user_id = Auth::user()->id;
        $purchaseData->save();
        if ($request->batch_no) {
            $count = count($request->batch_no);
            for ($i = 0; $i < $count; $i++) {
                $productId = $product->id;
                $generate = new DNS1D();
                $purData = new PurchaseItems;
                $purData->purchase_id = $purchaseData->id;
                $purData->product_id = $productId;
                $purData->size = $request->p_size;
                $purData->quality = $request->p_quality;
                $purData->rate = $request->rate;
                $purData->coverage = '1';
                $purData->available_qty = '0';
                $purData->quantity = $request->quantity[$i];
                $purData->batchno = $request->batch_no[$i];
                $purData->location = $request->location[$i];
                $purData->total = $request->rate * '1' * $request->quantity[$i];
                $purData->product_code = $prodCode;
                $purData->barcode = '<img src="data:image/png,' . $generate->getBarcodePNG($product->product_code, 'C39+') . '"
                 alt="barcode" />';
                $purData->godown = $product->godown;
                $purData->status = '1';
                $purData->save();
            }
        }

        return redirect()->route('product')->with('message', 'Data Saved Successfully');
    }

    public function deleteProduct(Request $request)
    {
        $product = Product::find($request->id);

        if ($product) {
            $img_name = $product->p_image;
            $destinationPath = 'public/product_img/' . $img_name;
            if (file_exists($destinationPath)) {
                unlink($destinationPath);
            }
            $video_name = $product->video_link;
            $destinationPath = 'public/product_video/' . $video_name;
            if (file_exists($destinationPath)) {
                unlink($destinationPath);
            }

            $product->delete();
            return redirect()->back()->with('message', 'Product deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Product Not Found');
        }
    }
    public function updateProduct(Request $request)
    {
        //dd($request->all());
        $product = Product::find($request->p_id);
        if ($request->hasFile('p_image')) {
            $pdt_img = time() . '.' . $request->p_image->extension();
            $request->p_image->move(public_path('product_img'), $pdt_img);
            $destinationPath = 'public/product_img/' . $request->old_p_image;
            if (is_file($destinationPath)) {
                unlink($destinationPath);
            }
            $product->p_image = $pdt_img;
        }

        $product->video_link = $request->video_link;
        $product->p_name = strtoupper($request->p_name);
        $product->p_size = $request->p_size;
        $product->cat_id = $request->cat_id;
        $product->quality_id = $request->p_quality;
        $product->p_quantity = $request->p_quantity;
        $product->type = $request->type;
        $product->p_pcinbox = $request->p_pcinbox;
        $product->p_mrp_sqft_rate = $request->p_mrp_sqft_rate;
        $product->coverage = $request->coverage;
        $product->p_rate_p_box = $request->p_rate;
        // $product->p_rate_p_sqft = $request->p_rate_sqft;
        $product->availability = $request->availability;
        $product->godown = $request->godown;
        $product->update();

        if (!is_null($request->batch_no)) {
            $count = count($request->batch_no);
            for ($i = 0; $i < $count; $i++) {
                $stockid = $request->stockId[$i];
                $purchaseData = PurchaseItems::find($stockid);
                if (is_null($purchaseData)) {
                    $purchaseData = new PurchaseItems;
                    $purchaseData->batchno = $request->batch_no[$i];
                }
                $purchaseData->purchase_id = $request->purchase_id;
                $purchaseData->product_id = $request->p_id;
                $purchaseData->size = $request->p_size;
                $purchaseData->quality = $request->p_quality;
                $purchaseData->rate = $request->p_rate;
                $purchaseData->quantity = $request->quantity[$i];
                $purchaseData->coverage = '1';
                $purchaseData->available_qty = '0';
                $purchaseData->total = $request->p_rate * '1' * $request->quantity[$i];
                $purchaseData->status = '1';
                $purchaseData->location = $request->location[$i];
                $purchaseData->save();
            }
        }

        return redirect()->back()->with('message', 'You have successfully Update Product');
    }

    public function notInStockProducts()
    {
        $products = Product::with(['quality', 'purchaseItems', 'quotationItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        $products->map(function ($product) {
            $product->remain_quontity = $product->quotationItems->sum('box') - $product->quotationItems->sum('unit_remain');
            $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->remain_quontity;
            return $product;
        });
        return view('admin.notinstock', compact('products'));
    }

    public function lessInStockProducts()
    {
        $products = Product::with(['quality', 'purchaseItems', 'quotationItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        $products->map(function ($product) {
            $product->remain_quontity = $product->quotationItems->sum('box') - $product->quotationItems->sum('unit_remain');
            $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->remain_quontity;
            return $product;
        });
        return view('admin.lessinstock', compact('products'));
    }

    public function fastMoving()
    {
        // $products = Product::with(['quality', 'purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        // $products->map(function ($product) {
        //     $product->fastmovingproducts = (int)$product->managePurchaseItems->sum('box');
        //     return $product;
        // });
        // return view('admin.fastmovingproducts', compact('products'));
        $products = Product::with(['quality', 'purchaseItems', 'quotationItems', 'managePurchaseItems'])
            ->orderBy('p_name')
            ->get();

        // Calculate `fastmovingproducts` and sort by it
        $fastMovingProducts = $products->map(function ($product) {
            $product->remain_quontity = $product->quotationItems->sum('box') - $product->quotationItems->sum('unit_remain');
            $product->current_quantity = (int) $product->p_quantity + $product->purchaseItems->sum('quantity') - $product->remain_quontity;
            $product->fastmovingproducts = (int) $product->quotationItems->sum('box') - $product->quotationItems->sum('unit_remain');
            return $product;
        })->sortByDesc('fastmovingproducts')
            ->take(20);

        return view('admin.fastmovingproducts', compact('fastMovingProducts'));
    }

    public function getPurchaseItems(Request $request)
    {
        $purchaseItems = $request->input('stockId');
        //return $itemid;
        $purchaseData = PurchaseItems::where('id', $purchaseItems)->first();
        $purchaseData->delete();
        return response()->json([
            'status' => 'success',
            'data' => $purchaseData,
        ]);
    }

    public function Notes()
    {
        $notes = Notes::orderBy('id', 'desc')->paginate(5);
        $products = Product::orderBy('p_name')->get();
        return view('admin.notes', compact('notes', 'products'));
    }
    public function storeNotes(Request $request)
    {
        $notes = new Notes;
        $notes->name = $request->name;
        $notes->size = $request->size;
        $notes->quality = strtoupper($request->quality);
        $notes->Date = $request->Date;
        $notes->quantity = $request->quantity;
        $notes->description = $request->description;
        $notes->save();
        return redirect()->route('Notes')->with('message', 'Data Saved successfully');
    }
    public function deleteNotes(Request $request)
    {
        $notes = Notes::find($request->id);
        if ($notes) {
            $notes->delete();
            return redirect()->back()->with('message', 'Notes deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Notes Not Found');
        }
    }
    public function updateNotes(Request $request)
    {
        $quality = Notes::find($request->n_id);
        $quality->update([
            'name' => $request->name,
            'size' => $request->size,
            'quality' => $request->quality,
            'Date' => $request->Date,
            'quantity' => $request->quantity,
            'description' => $request->description,
        ]);

        return redirect()->back()->with('message', 'You have successfully Update Notes');
    }
    public function report()
    {
        return view('admin.report');
    }

    public function getReport(Request $request)
    {
        $startDate = date($request->start_date);
        $endDate = date($request->end_date);
        $quotationData = Quotation::whereDate('created_at', '>=', $startDate)
            ->whereDate('created_at', '<=', $endDate)
            ->get();
        return view('admin.reportData', compact('quotationData'));
    }

    public function purchase()
    {
        $products = Product::with(['purchaseItems', 'quotationItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        $products->map(function ($product) {
            $product->remain_quontity = $product->quotationItems->sum('box') - $product->quotationItems->sum('unit_remain');
            // $product->current_quantity = ((int) $product->p_quantity + (int) $product->purchaseItems->sum('quantity')) -
            //     (int) $product->managePurchaseItems->sum('box');
            $product->current_quantity = ((int) $product->p_quantity + (int) $product->purchaseItems->sum('quantity')) -
                (int)  $product->remain_quontity;
            return $product;
        });
        $quality = Quality::get();
        return view('admin.purchase', compact('products', 'quality'));
    }

    public function getInventoryData(Request $request)
    {
        $purchaseId = $request->input('purchaseId');
        $purchaseItems = PurchaseItems::find($purchaseId);
        $purchaseData = Purchase::find($purchaseItems->purchase_id);
        $purchaseData->total = ((float) $purchaseData->total - (float) $purchaseItems->total);
        $purchaseData->save();
        $purchaseData->total_amount = (float) $purchaseData->total;
        $purchaseItems->delete();
        return response()->json([
            'status' => 'success',
            'data' => ['total_amount' => $purchaseData->total_amount],
        ]);
    }

    public function storePurchase(Request $request)
    {
        if (empty($request->prod_name[0])) {
            return redirect()->back()->with('message_err', 'Please select at least 1 Product');
        }

        $purchaseData = new Purchase;
        $purchaseData->purchase_date = $request->purchase_data;
        $purchaseData->bill_no = $request->bill_no;
        $purchaseData->client_name = $request->client_name;
        $purchaseData->client_contact = $request->client_contact;
        $purchaseData->total = $request->subTotal;
        $purchaseData->user_id = Auth::user()->id;
        $purchaseData->save();
        $count = count($request->prod_name);
        for ($i = 0; $i < $count; $i++) {
            if ($request->product_id[$i] == null) {
                continue;
            } else {
                $productId = $request->product_id[$i];
                $productData = Product::where('id', $productId)->first();
                $generate = new DNS1D();
                $purData = new PurchaseItems;
                $purData->product_id = $request->product_id[$i];
                $purData->size = $request->productSize[$i];
                $purData->quality = $request->productQuality[$i];
                $purData->rate = $request->productrate[$i];
                $purData->coverage = $request->coverage[$i];
                $purData->batchno = $request->batch_no[$i];
                $purData->quantity = $request->quantity[$i];
                $purData->available_qty = $request->avl_quantity[$i];
                $purData->total = $request->totalbalance[$i];
                $purData->product_code = $productData->product_code;
                $purData->barcode = '<img src="data:image/png,' . $generate->getBarcodePNG($productData->product_code, 'C39+') . '"
                 alt="barcode" />';
                $purData->purchase_id = $purchaseData->id;
                $purData->godown = $request->godown[$i];
                $purData->save();
            }
        }
        return redirect()->back()->with('message', 'Data saved Successfully');
    }

    public function managePurchase(Request $request)
    {
        $search = $request->get('search');
        if ($search != null) {
            $productIds = Product::where('p_name', 'like', '%' . $search . '%')->pluck('id')->toArray();
            $purchases = Purchase::with('purchaseItems')->where('client_name', 'like', '%' . $search . '%')->orwhere(function ($query) use ($productIds) {
                $query->whereHas('purchaseItems', function ($query) use ($productIds) {
                    $query->whereIn('product_id', $productIds);
                });
            })->latest('id')->paginate(10);
            $purchases->withPath('managePurchase')->appends(['search' => $search]);
        } else {
            $purchases = Purchase::with('purchaseItems')->latest('id')->where('status', '0')->paginate(10);
        }

        foreach ($purchases as $value) {
            $value->count = count($value->purchaseItems);
        }
        return view('admin.manage_purchase', compact('purchases'));
    }

    public function editPurchase(Request $request, $id)
    {
        $pdata = Purchase::find($id);
        $purchaseItems = PurchaseItems::where('purchase_id', $id)->get();
        $products = Product::with(['purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        $products->map(function ($product) {
            $product->current_quantity = ((float) $product->p_quantity + (float) $product->purchaseItems->sum('quantity'));
            return $product;
        });
        $quality = Quality::get();
        return view('admin.edit_purchase', compact('pdata', 'purchaseItems', 'products', 'quality'));
    }
    public function updatePurchase(Request $request)
    {
        if (empty($request->product_id[0])) {
            return redirect()->back()->with('message_err', 'Please select at least 1 Product');
        }
        $purchaseId = $request->purchase_id;
        $purchaseData = Purchase::find($purchaseId);
        if ($purchaseData) {
            $purchaseData->purchase_date = $request->purchase_data;
            $purchaseData->bill_no = $request->bill_no;
            $purchaseData->client_name = $request->client_name;
            $purchaseData->client_contact = $request->contact;
            $purchaseData->total = $request->subTotal;
            $purchaseData->user_id = Auth::user()->id;
            $purchaseData->save();
        } else {
            return redirect()->back()->with('message_err', 'Something went wrong');
        }
        $countData = count($request->prod_name);
        for ($i = 0; $i < $countData; $i++) {
            $productId = $request->product_id[$i];
            $batchNo = $request->batch_no[$i];
            if (is_null($productId)) {
                return redirect()->back()->with('message_err', 'Please fill all the fields');
            }
            $randAlpha = [
                'A',
                'B',
                'C',
                'D',
                'E',
                'F',
                'G',
                'H',
                'I',
                'J',
                'K',
                'L',
                'M',
                'N',
                'O',
                'P',
                'Q',
                'R',
                'S',
                'T',
                'U',
                'V',
                'W',
                'X',
                'Y',
                'Z',
            ][rand('0', '25')];
            $prodCode = time() . $randAlpha . $productId;
            $prodCode = substr($prodCode, -10);
            $generate = new DNS1D();
            $purData = PurchaseItems::where('purchase_id', $purchaseId)->where('product_id', $productId)->where('batchno', $batchNo)->first();
            if (is_null($purData)) {
                $purData = new PurchaseItems;
                $purData->product_id = $productId;
                $purData->batchno = $request->batch_no[$i];
            }
            $purData->size = $request->productSize[$i] ?? null;
            $purData->quality = $request->productQuality[$i] ?? null;
            $purData->rate = $request->productrate[$i] ?? null;
            $purData->coverage = $request->coverage[$i] ?? null;
            $purData->quantity = $request->quantity[$i] ?? null;
            $purData->available_qty = $request->avl_quantity[$i] ?? null;
            $purData->total = round($request->totalbalance[$i], 2);
            $purData->product_code = $prodCode;
            $purData->barcode = '<img src="data:image/png,' . $generate->getBarcodePNG($prodCode, 'C39+') . '"
                alt="barcode" />';
            $purData->purchase_id = $purchaseData->id;
            $purData->godown = $request->godown[$i];
            $purData->save();
        }
        return redirect()->back()->with('message', 'Data Updated Successfully');
    }
    public function deletePurchase($id)
    {
        $purchaseData = Purchase::find($id);
        if ($purchaseData) {
            $purchaseData->delete();
            return redirect()->back()->with('message', 'Inventory Data Deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Inventory Data Not Found');
        }
    }

    public function AddQuotation()
    {
        $products = Product::with(['purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        $products->map(function ($product) {
            $product->current_quantity = ((int) $product->p_quantity + (int) $product->purchaseItems->sum('quantity')) -
                (int) $product->managePurchaseItems->sum('box');
            return $product;
        });
        $quality = Quality::get();
        $quotationData = Quotation::select('attended_by')->distinct()->get();

        $allQuotations = Quotation::get();

        return view('admin.addquotation', compact('products', 'quality', 'quotationData', 'allQuotations'));
    }

    public function manageQuotation(Request $request)
    {
        $search = $request->get('search');
        $attendedBy = $request->get('attendedBy');

        $productIds = [];

        if ($search) {
            $productIds = Product::where('p_name', 'like', '%' . $search . '%')->pluck('id')->toArray();
            $quotations = Quotation::with(['quotationItems.product', 'user'])->where('client_name', 'like', '%' . $search . '%')->orwhere(function ($query) use ($productIds) {
                $query->whereHas('quotationItems', function ($query) use ($productIds) {
                    $query->whereIn('product_id', $productIds);
                });
            })->latest('id')->paginate(10);

            $markedQuotations = Quotation::with(['quotationItems.product', 'user'])
                ->where([['client_name', 'like', '%' . $search . '%'], ['star_mark', '1']])
                ->latest('id')->paginate(10);

            $quotations->withPath('manageQuotation')->appends(['search' => $search]);
            $markedQuotations->withPath('manageQuotation')->appends(['search' => $search]);
        } else if ($attendedBy) {
            $quotations = Quotation::with(['quotationItems.product', 'user'])->where('attended_by', 'like', '%' . $attendedBy . '%')->latest('id')->paginate(10);
            $markedQuotations = Quotation::with(['quotationItems.product', 'user'])->where([['attended_by', 'like', '%' . $attendedBy . '%'], ['star_mark', '1']])->latest('id')->paginate(10);
            $quotations->withPath('manageQuotation')->appends(['attendedBy' => $attendedBy]);
            $markedQuotations->withPath('manageQuotation')->appends(['attendedBy' => $attendedBy]);
        } else {
            $quotations = Quotation::with(['quotationItems.product', 'user'])->latest('id')->paginate(10);
            $markedQuotations = Quotation::with(['quotationItems.product', 'user'])->where('star_mark', '1')->latest('id')->paginate(10);
        }

        $finalQuotation = [];

        foreach ($quotations as $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];
            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    array_push($quotationProducts, $data->product);
                }
            }
            $value->quotationProduct = $quotationProducts;
            $value->due_amount = ((float) $value->sub_amt - (float) $value->paymentHistory->sum('amount'));
            if ($value->due_amount <= 0) {
                array_push($finalQuotation, $value);
            }
        }

        $perPage = 10;
        $page = request('page', 1);
        $finalQuotation = new LengthAwarePaginator($finalQuotation, count($finalQuotation), $perPage, $page, [
            'path' => request()->url(),
            'query' => request()->query(),
        ]);

        $markedQuotations = Quotation::with(['quotationItems.product', 'user'])->where('star_mark', '1')->latest('id')->paginate(10);
        foreach ($markedQuotations as $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];
            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    array_push($quotationProducts, $data->product);
                }
            }
            $value->quotationProduct = $quotationProducts;
        }

        return view('admin.manage_quotation', compact('quotations', 'markedQuotations', 'finalQuotation'));
    }

    public function finalQuotation(Request $request)
    {
        $search = $request->get('search');
        $attendedBy = $request->get('attendedBy');

        $productIds = [];

        if ($search) {
            $productIds = Product::where('p_name', 'like', '%' . $search . '%')->pluck('id')->toArray();

            // Fetch quotations with the star_mark condition
            $quotations = Quotation::with(['quotationItems.product', 'user'])
                ->where(function ($query) use ($search, $productIds) {
                    $query->where('client_name', 'like', '%' . $search . '%')
                        ->orWhereHas('quotationItems', function ($subQuery) use ($productIds) {
                            $subQuery->whereIn('product_id', $productIds);
                        });
                })
                ->where('star_mark', '1') // Universal star_mark condition
                ->latest('id')
                ->paginate(10);

            $quotations->withPath('manageQuotation')->appends(['search' => $search]);
        } else if ($attendedBy) {
            // Fetch quotations attended by specific user with star_mark condition
            $quotations = Quotation::with(['quotationItems.product', 'user'])
                ->where('attended_by', 'like', '%' . $attendedBy . '%')
                ->where('star_mark', '1') // Universal star_mark condition
                ->latest('id')
                ->paginate(10);

            $quotations->withPath('manageQuotation')->appends(['attendedBy' => $attendedBy]);
        } else {
            // Default case to include only starred quotations
            $quotations = Quotation::with(['quotationItems.product', 'user'])
                ->where('star_mark', '1') // Universal star_mark condition
                ->latest('id')
                ->paginate(10);
        }

        // Now `quotations` will only include those with `star_mark = 1` as requested.

        $finalQuotation = [];

        foreach ($quotations as $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];
            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    array_push($quotationProducts, $data->product);
                }
            }
            $value->quotationProduct = $quotationProducts;
            $value->due_amount = ((float) $value->sub_amt - (float) $value->paymentHistory->sum('amount'));
            if ($value->due_amount <= 0) {
                array_push($finalQuotation, $value);
            }
        }

        $perPage = 10;
        $page = request('page', 1);
        $finalQuotation = new LengthAwarePaginator($finalQuotation, count($finalQuotation), $perPage, $page, [
            'path' => request()->url(),
            'query' => request()->query(),
        ]);

        $markedQuotations = Quotation::with(['quotationItems.product', 'user'])->where('star_mark', '1')->latest('id')->paginate(10);
        foreach ($markedQuotations as $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];
            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    array_push($quotationProducts, $data->product);
                }
            }
            $value->quotationProduct = $quotationProducts;
        }

        return view('admin.final_quotation', compact('quotations', 'markedQuotations', 'finalQuotation'));
    }



    public function completeQuotation(Request $request)
    {
        $search = $request->get('search');
        $attendedBy = $request->get('attendedBy');

        $productIds = [];

        if ($search) {
            $productIds = Product::where('p_name', 'like', '%' . $search . '%')->pluck('id')->toArray();

            // Fetch quotations with the star_mark condition
            $quotations = Quotation::with(['quotationItems.product', 'user'])
                ->where(function ($query) use ($search, $productIds) {
                    $query->where('client_name', 'like', '%' . $search . '%')
                        ->orWhereHas('quotationItems', function ($subQuery) use ($productIds) {
                            $subQuery->whereIn('product_id', $productIds);
                        });
                })
                ->where('star_mark', '1') // Universal star_mark condition
                ->latest('id')
                ->paginate(10);

            $quotations->withPath('manageQuotation')->appends(['search' => $search]);
        } elseif ($attendedBy) {
            // Fetch quotations attended by specific user with star_mark condition
            $quotations = Quotation::with(['quotationItems.product', 'user'])
                ->where('attended_by', 'like', '%' . $attendedBy . '%')
                ->where('star_mark', '1') // Universal star_mark condition
                ->latest('id')
                ->paginate(10);

            $quotations->withPath('manageQuotation')->appends(['attendedBy' => $attendedBy]);
        } else {
            // Default case to include only starred quotations
            $quotations = Quotation::with(['quotationItems.product', 'user'])
                ->where('star_mark', '1') // Universal star_mark condition
                ->latest('id')
                ->paginate(10);
        }

        foreach ($quotations as $key => $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];

            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    $quotationProducts[] = $data->product; // Append product to array
                }
            }

            $value->quotationProduct = $quotationProducts;
            $value->due_amount = (float)$value->sub_amt - (float)$value->paymentHistory->sum('amount');

            // Adjusted condition to check if all `unit_remain` values are zero
            if ($value->due_amount > 0) {
                unset($quotations[$key]); // Safely remove item from collection
            }
        }


        // Process each quotation
        // foreach ($quotations as $key => $value) {
        //     $value->creator = is_null($value->user) ? "" : $value->user->name;
        //     $value->productCount = count($value->quotationItems);
        //     $value->total_weight = $value->quotationItems->sum('weight');
        //     $quotationProducts = [];
        //     $allUnitsRemainZero = true;

        //     foreach ($value->quotationItems as $data) {
        //         if (!is_null($data->product)) {
        //             $quotationProducts[] = $data->product; // Append product to array
        //         }
        //         if ($data->unit_remain !== 0) {
        //             $allUnitsRemainZero = false; // Set flag to false if any unit_remain is not '0'
        //         }
        //     }

        //     $value->quotationProduct = $quotationProducts;
        //     $value->due_amount = (float)$value->sub_amt - (float)$value->paymentHistory->sum('amount');

        //     // Remove from collection if due_amount is not positive
        //     if ($value->due_amount > 0 && $allUnitsRemainZero != true) {
        //         unset($quotations[$key]); // Safely remove item from collection
        //     }
        // }

        // Return updated quotations
        //  return $quotations;

        $finalQuotation = [];

        // foreach ($quotations as $value) {
        //     $value->creator = is_null($value->user) ? "" : $value->user->name;
        //     $value->productCount = count($value->quotationItems);
        //     $value->total_weight = $value->quotationItems->sum('weight');
        //     $quotationProducts = [];
        //     foreach ($value->quotationItems as $data) {
        //         if (!is_null($data->product)) {
        //             array_push($quotationProducts, $data->product);
        //         }
        //     }
        //     $value->quotationProduct = $quotationProducts;
        //     $value->due_amount = ((float) $value->sub_amt - (float) $value->paymentHistory->sum('amount'));
        //     if ($value->due_amount <= 0) {
        //         array_push($finalQuotation, $value);
        //     }
        // }

        $perPage = 10;
        $page = request('page', 1);
        $finalQuotation = new LengthAwarePaginator($finalQuotation, count($finalQuotation), $perPage, $page, [
            'path' => request()->url(),
            'query' => request()->query(),
        ]);

        $markedQuotations = Quotation::with(['quotationItems.product', 'user'])->where('star_mark', '1')->latest('id')->paginate(10);
        foreach ($markedQuotations as $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];
            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    array_push($quotationProducts, $data->product);
                }
            }
            $value->quotationProduct = $quotationProducts;
        }

        return view('admin.complete_quotation', compact('quotations', 'markedQuotations', 'finalQuotation'));
    }

    public function creditor(Request $request)
    {
        $search = $request->get('search');
        $attendedBy = $request->get('attendedBy');

        $productIds = [];

        if ($search) {
            $productIds = Product::where('p_name', 'like', '%' . $search . '%')->pluck('id')->toArray();

            // Fetch quotations with the star_mark condition
            $quotations = Quotation::with(['quotationItems.product', 'user'])
                ->where(function ($query) use ($search, $productIds) {
                    $query->where('client_name', 'like', '%' . $search . '%')
                        ->orWhereHas('quotationItems', function ($subQuery) use ($productIds) {
                            $subQuery->whereIn('product_id', $productIds);
                        });
                })
                ->where('star_mark', '1') // Universal star_mark condition
                ->latest('id')
                ->paginate(10);

            $quotations->withPath('manageQuotation')->appends(['search' => $search]);
        } else {
            $quotations = Quotation::with(['quotationItems.product', 'user'])
                ->where('star_mark', '1')
                ->latest('id')
                ->paginate(10);
        }


        $finalQuotation = [];

        foreach ($quotations as $key => $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];

            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    $quotationProducts[] = $data->product; // Append product to array
                }
            }

            $value->quotationProduct = $quotationProducts;
            $value->rec_amount = $value->paymentHistory->sum('amount');
            $value->due_amount = (float)$value->sub_amt - (float)$value->paymentHistory->sum('amount');

            if ($value->due_amount <= 0) {
                unset($quotations[$key]);
            }
        }


        $perPage = 10;
        $page = request('page', 1);
        $finalQuotation = new LengthAwarePaginator($finalQuotation, count($finalQuotation), $perPage, $page, [
            'path' => request()->url(),
            'query' => request()->query(),
        ]);

        $markedQuotations = Quotation::with(['quotationItems.product', 'user'])->where('star_mark', '1')->latest('id')->paginate(10);
        foreach ($markedQuotations as $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];
            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    array_push($quotationProducts, $data->product);
                }
            }
            $value->quotationProduct = $quotationProducts;
        }

        return view('admin.creditor', compact('quotations', 'markedQuotations', 'finalQuotation'));
    }

    public function creditorPdf()
    {
        $quotations = Quotation::with(['quotationItems.product', 'user'])
            ->where('star_mark', '1') // Universal star_mark condition
            ->latest('id')
            ->get();
        foreach ($quotations as $key => $value) {
            $value->creator = is_null($value->user) ? "" : $value->user->name;
            $value->productCount = count($value->quotationItems);
            $value->total_weight = $value->quotationItems->sum('weight');
            $quotationProducts = [];

            foreach ($value->quotationItems as $data) {
                if (!is_null($data->product)) {
                    $quotationProducts[] = $data->product; // Append product to array
                }
            }

            $value->quotationProduct = $quotationProducts;
            $value->rec_amount = $value->paymentHistory->sum('amount');
            $value->due_amount = (float)$value->sub_amt - (float)$value->paymentHistory->sum('amount');

            if ($value->due_amount <= 0) {
                unset($quotations[$key]);
            }
        }

        return view('admin.creditorpdf', compact('quotations'));
    }

    public function editQuotation($id)
    {

        $qdata = Quotation::with('paymentHistory')->find($id);
        $qdata->due_amount = ((float) $qdata->sub_amt - (float) $qdata->paymentHistory->sum('amount'));
        $qdata->total_paid = ((float) $qdata->advance_payment) + (float) $qdata->paymentHistory->sum('amount');
        // $qdata->total_paid =  $qdata->advance_payment;


        $qdata->discount_per = $qdata->discount;
        $qdata->discount_amt = $qdata->discountedAmt;

        $discountedPercentage = $qdata->discount_per / 100;
        // Calculate discounted amount
        $discountedAmount = $qdata->discount_amt * $discountedPercentage;

        $qdata->grand_total_amt = $qdata->discount_amt + $qdata->total_paid + $discountedAmount;

        $qdata->originalAmount = $qdata->discount_amt / (1 - $discountedPercentage);
        // dd($qdata);
        // return $qdata->originalAmount;

        $quotationItems = QuotationItems::where('quotation_id', $id)->get();
        $products = Product::with(['purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        $products->map(function ($product) {
            $product->current_quantity = ((int) $product->p_quantity + (int) $product->purchaseItems->sum('quantity')) - (int) $product->managePurchaseItems->sum('box');
            return $product;
        });
        $quality = Quality::get();
        return view('admin.edit_quotation', compact('qdata', 'quotationItems', 'products', 'quality'));
    }

    public function getQuotation(Request $request)
    {
        $quotationId = $request->input('quotationId');
        $quotationData = QuotationItems::find($quotationId);
        $quotations = Quotation::with('paymentHistory')->find($quotationData->quotation_id);
        $quotations->sub_amt = ((float) $quotations->sub_amt - (float) $quotationData->total);
        $quotations->save();
        $quotations->due_amount = ((float) $quotations->sub_amt - (float) $quotations->paymentHistory->sum('amount'));
        $quotations->total_paid = ((float) $quotations->paymentHistory->sum('amount'));
        $quotations->advance_payment = (float) $quotations->advance_payment;
        $quotationData->delete();
        return response()->json([
            'status' => 'success',
            'data' => ['due_amount' => $quotations->due_amount, 'total_paid' => $quotations->total_paid],
        ]);
    }
    public function updateQuotation(Request $request)
    {
        // dd($request->all());
        if (empty($request->product_id[0])) {
            return redirect()->back()->with('message_err', 'Please select at least 1 Product');
        }
        $quotationId = $request->quotation_id;
        $data = Quotation::find($quotationId);
        if ($data) {
            $data->client_name = $request->client_name;
            $data->contact = $request->contact;
            $data->client_addr = $request->client_addr;
            $data->attended_by = $request->attended_by;
            $data->attendee_contact = $request->attendee_contact;
            $data->architect = $request->architect_name;
            $data->architect_contact = $request->architect_contact;
            $data->header_section = $request->header_section;
            $data->advance_payment = $request->advance;
            //$data->sub_amt = $request->subTotal;
            $data->sub_amt = $request->subTotal + $request->freight_charges;
            $data->discount = $request->grand_total_disc;
            $data->discountedAmt = $request->discountedAmt;
            $data->bottom_section = $request->bottom_section;
            $data->freight_charges = $request->freight_charges;
            $data->user_id = Auth::user()->id;
            $data->save();
        } else {
            return redirect()->back()->with('message_err', 'Something went wrong');
        }
        $count = count($request->prod_name);
        for ($i = 0; $i < $count; $i++) {
            $productId = $request->product_id[$i];
            $quotationItemId = $request->quotationItemId[$i];
            if (is_null($productId)) {
                return redirect()->back()->with('message_err', 'Please fill all the fields');
            }

            $quotationData = QuotationItems::where('id', $quotationItemId)->first();

            if (is_null($quotationData)) {
                $quotationData = new QuotationItems;
                $quotationData->quotation_id = $quotationId;
            }
            $quotationData->product_id = $productId;
            $quotationData->size = $request->productSize[$i] ?? null;
            $quotationData->initial_rate = $request->mrpproductrate[$i];
            $quotationData->rate = $request->productrate[$i] ?? null;
            $quotationData->p_rate_p_box = $request->productRatePerBox[$i] ?? null;
            $quotationData->f_rate_p_box = $request->finalRatePerBox[$i] ?? null;
            $quotationData->quality = $request->productQuality[$i] ?? null;
            $quotationData->coverage = $request->coverage[$i] ?? null;
            $quotationData->box = $request->box[$i] ?? null;
             $quotationData->unit_remain = $request->box[$i];
               $quotationData->unit_send = null;
            $quotationData->weight = round($request->weight[$i], 2);
            $quotationData->total_weight = round($request->totalweight[$i], 2);
            $quotationData->total = round($request->totalbalance[$i], 2);
            $quotationData->application_area = $request->application_area[$i] ?? null;
            // $quotationData->discount = $request->discount[$i] ?? null;
            $quotationData->save();
        }
        return redirect()->route('manageQuotation')->with('message', 'Data Updated Successfully');
    }
    public function quotation($id, Request $request)
    {
        $quotations = Quotation::with('paymentHistory')->find($id);
        $quotations->due_amount = ((float) $quotations->sub_amt - (float) $quotations->paymentHistory->sum('amount'));
        $quotations->total_paid = ((float) $quotations->advance_payment + (float) $quotations->paymentHistory->sum('amount'));
        $quotationItems = QuotationItems::where('quotation_id', $id)->get();
        $products = Product::orderBy('p_name')->get();
        $quality = Quality::get();
        $type = $request->type;
        return view('admin.quotation', compact('quotations', 'quotationItems', 'products', 'quality', 'type'));
    }
    // public function quotationfinalbill($id, Request $request)
    // {
    //     $quotations = Quotation::with('paymentHistory')->find($id);
    //     $quotations->due_amount = ((float) $quotations->sub_amt - (float) $quotations->paymentHistory->sum('amount'));
    //     $quotations->total_paid = ((float) $quotations->advance_payment + (float) $quotations->paymentHistory->sum('amount'));
    //     $quotationItems = QuotationItems::where('quotation_id', $id)->get();
    //     $products = Product::orderBy('p_name')->get();
    //     $quality = Quality::get();
    //     $type = $request->type;
    //     return view('admin.quotationFinalBill', compact('quotations', 'quotationItems', 'products', 'quality', 'type'));
    // }
    
    
     public function quotationfinalbill($id, Request $request)
    {
        $quotations = Quotation::with('paymentHistory')->find($id);
        $quotations->due_amount = ((float) $quotations->sub_amt - (float) $quotations->paymentHistory->sum('amount'));
        $quotations->total_paid = ((float) $quotations->advance_payment + (float) $quotations->paymentHistory->sum('amount'));

        $quotationItems = QuotationItems::where('quotation_id', $id)->get();
        $products = Product::orderBy('p_name')->get();
        $quality = Quality::get();
        $type = $request->type;

        $quotationlist = Quotation::with('paymentHistory')->where('star_mark', '1')->get();

        $relatedQuotations = $quotationlist->filter(function ($list) use ($quotations) {
            return $quotations->contact == $list->contact && $quotations->id != $list->id;
        });

        $relatedQuotationData = $relatedQuotations->map(function ($related) {
            $related->due_amount = (float) $related->sub_amt - (float) $related->paymentHistory->sum('amount');
            $related->total_paid = (float) $related->advance_payment + (float) $related->paymentHistory->sum('amount');
            return $related; // Return the full quotation object with additional attributes
        })->filter(function ($related) {
            return $related->due_amount != 0; // Exclude records with due_amount equal to 0
        });

        // return   $relatedQuotationData;

        return view('admin.quotationFinalBill', compact(
            'quotations',
            'quotationItems',
            'products',
            'quality',
            'type',
            'quotationlist',
            'relatedQuotationData'
        ));
    }

    public function deliveryChallan(Request $request)
    {
        Quotation::where('id', $request->del_id)->update([
            'del_boy_name' => $request->del_boy_name,
            'del_boy_contact' => $request->contact_no,
            'weight_of_goods' => $request->totalWeight,
            'tempo_no' => $request->tempo_no,
        ]);

        QuotationItems::where('quotation_id', $request->del_id)->update([
            'included' => '0',
            'unit_send' => null,
        ]);

        foreach ($request->all() as $key => $value) {
            if (Str::startsWith($key, 'product')) {
                $item_data = explode('_', $key);
                $item = QuotationItems::find($item_data[1]);
                $item->included = "1";
                $item->unit_send = $request->all()['box_' . $item_data[1]];
                $item->unit_remain = $item->unit_remain - $item->unit_send;
                $item->save();
            }
        }
        return redirect()->back()->with('message', 'Data Save Successfully');
    }
    public function deliveryChallanByStar(Request $request)
    {
        Quotation::where('id', $request->delv_id)->update([
            'del_boy_name' => $request->del_boy_name,
            'del_boy_contact' => $request->contact_no,
            'weight_of_goods' => $request->totalWeightStar,
            'tempo_no' => $request->tempo_no,
        ]);
        QuotationItems::where('quotation_id', $request->del_id)->update([
            'included' => '0',
            'unit_send' => null,
        ]);

        foreach ($request->all() as $key => $value) {
            if (Str::startsWith($key, 'product')) {
                $item_data = explode('_', $key);
                $item = QuotationItems::find($item_data[1]);
                $item->included = "1";
                $item->unit_send = $request->all()['box_' . $item_data[1]];
                $item->unit_remain = $item->unit_remain - $item->unit_send;
                $item->save();
            }
        }
        return redirect()->back()->with('message', 'Data Save Successfully');
    }
    public function printChallan(Request $request, $id)
    {
        $quotations = Quotation::where('id', $id)->get();
        $quotationItems = QuotationItems::where('quotation_id', $id)->where('included', '1')->get();
        $products = Product::orderBy('p_name')->get();
        $quality = Quality::get();
        return view('admin.deliveryChallan', compact('quotations', 'quotationItems', 'products', 'quality'));
    }
    public function starMark(Request $request)
    {
        Quotation::where('id', $request->id)->update([
            'star_mark' => $request->status,
        ]);
    }

    public function storeQuotation(Request $request)
    {
        // dd($request->all());

        if (empty($request->product_id[0])) {
            return redirect()->back()->with('message_err', 'Please select at least 1 Product');
        }

        $data = new Quotation;
        $data->client_name = $request->client_name;
        $data->contact = $request->contact;
        $data->client_addr = $request->client_addr;
        $data->attended_by = $request->attended_by;
        $data->attendee_contact = $request->attendee_contact;
        $data->architect = $request->architect_name;
        $data->architect_contact = $request->architect_contact;
        $data->header_section = $request->header_section;
        $data->advance_payment = $request->advance;
        //$data->sub_amt = $request->subTotal;
        $data->sub_amt = $request->subTotal + $request->freight_charges;
        $data->discount = $request->grand_total_disc;
        $data->discountedAmt = $request->discountedAmt;
        $data->bottom_section = $request->bottom_section;
        $data->freight_charges = $request->freight_charges;
        $data->user_id = Auth::user()->id;
        $data->save();

        $count = count($request->prod_name);
        for ($i = 0; $i < $count; $i++) {
            if ($request->product_id[$i] == null) {
                continue;
            } else {
                $quotationData = new QuotationItems;
                $quotationData->product_id = $request->product_id[$i];
                $quotationData->size = $request->productSize[$i];
                $quotationData->quality = $request->productQuality[$i];
                $quotationData->initial_rate = $request->mrpproductrate[$i];
                $quotationData->rate = $request->productrate[$i];
                $quotationData->coverage = $request->coverage[$i];
                $quotationData->p_rate_p_box = $request->productRatePerBox[$i];
                $quotationData->f_rate_p_box = $request->finalRatePerBox[$i];
                $quotationData->box = $request->box[$i];
                $quotationData->unit_remain = $request->box[$i];
                $quotationData->application_area = $request->application_area[$i];
                $quotationData->total = round($request->totalbalance[$i], 2);
                $quotationData->weight = round($request->weight[$i], 2);
                $quotationData->total_weight = round($request->totalweight[$i], 2);
                $quotationData->quotation_id = $data->id;
                $quotationData->save();
            }
        }
        return redirect()->route('manageQuotation')->with('message', 'Quotation Added Successfully');
    }

    public function storePayment(Request $request)
    {
        //dd($request->all());
        $quotationData = new QuotationPayment;
        $quotationData->quotation_id = $request->q_id;
        $quotationData->payment_type = $request->payment_type;
        $quotationData->amount = $request->total_amount;
        $quotationData->payment_date = $request->payment_date;
        $quotationData->remark = $request->remark;
        $quotationData->save();
        if ($request->total_amount > 0) {
            $quotation = Quotation::find($request->q_id);
            $quotation->star_mark = '1';
            $quotation->save();
        }
        return redirect()->route('manageQuotation')->with('message', 'Data Added Successfully');
    }

    public function deleteQuotation($id)
    {
        $quotation = Quotation::find($id);
        if ($quotation) {
            $quotation->delete();
            return redirect()->back()->with('message', 'Quotation Deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Quotation Not Found');
        }
    }

    public function deletePaymentData($id)
    {
        $quotationPayment = QuotationPayment::find($id);
        $quotationPayment->delete();
        return redirect()->back()->with('message', 'Row Data Deleted Successfully');
    }

    public function changeValueSize(Request $request)
    {
        $pid = $request->pid;
        $productSql = DB::select("SELECT products.id, products.p_size, products.`quality_id`, qualities.quality_name FROM products LEFT JOIN qualities ON qualities.id = products.quality_id WHERE products.id='" . $pid . "'");
        return $productSql[0]->p_size;
    }
    public function changeValueQuality(Request $request)
    {
        $pid = $request->pid;
        $productSql = DB::select("SELECT products.id, products.p_size, products.`quality_id`, qualities.quality_name FROM products LEFT JOIN qualities ON qualities.id = products.quality_id WHERE products.id='" . $pid . "'");
        return $productSql;
        return $productSql[0]->quality_name;
    }

    public function productPDF()
    {
        $productData = Product::with(['purchaseItems', 'managePurchaseItems', 'quality', 'category'])->latest('p_name')->get();
        $productData->map(function ($product) {
            $product->current_quantity = ((int) $product->p_quantity + (int) $product->purchaseItems->sum('quantity')) - (int) $product->managePurchaseItems->sum('box');
            return $product;
        });
        return view('admin.productpdf', compact('productData'));
    }

    public function productPDFDownload()
    {
        $productData = Product::with(['purchaseItems', 'managePurchaseItems'])->latest('p_name')->get();
        $productData->map(function ($product) {
            $product->current_quantity = ((int) $product->p_quantity + (int) $product->purchaseItems->sum('quantity')) - (int) $product->managePurchaseItems->sum('box');
            return $product;
        });
        $pdf = \PDF::loadView('admin.productpdf', compact('productData'));
        return $pdf->download('product.pdf');
    }

    public function quotationMainPDF($id, Request $request)
    {
        $quotation = Quotation::with('paymentHistory')->find($id);
        if ($quotation != null) {
            $quotation->due_amount = ((float) $quotation->sub_amt - (float) $quotation->paymentHistory->sum('amount'));
            $quotation->total_paid = ((float) $quotation->advance_payment + (float) $quotation->paymentHistory->sum('amount'));
        }

        $quotationItems = QuotationItems::where('quotation_id', $id)->get();
        if (!$quotation) {
            return redirect()->back()->withErrors(['error' => 'Quotation not found!']);
        }
        if ($quotationItems->isEmpty()) {
            return redirect()->back()->withErrors(['error' => 'No items found for this quotation!']);
        }
        $products = Product::orderBy('p_name')->get();
        $type = $request->type;
        // return $type;
        $data = [
            'quotation' => $quotation,
            'quotationItems' => $quotationItems,
            'products' => $products,
            'type' => $type,
        ];
        // dd($data);
        $pdf = Pdf::loadView('admin.quotationMainPDF', $data);
        $pdfName = $quotation->client_name . "_Q" . ".pdf";
        return $pdf->download($pdfName);

        //return view('admin.quotationMainPDF', compact('quotation', 'quotationItems', 'products', 'type'));
    }


    public function proPdf(Request $request)
    {
        $product = Product::where('id', $request->id)->first();
        $quality = Quality::Where('id', $product->quality_id)->first()->quality_name;
        $category = Category::Where('id', $product->cat_id)->first();
        $product->qr_code = "$product->id.Name = $product->p_name . Size = $product->p_size . Quality = $quality";
        $qr = QrCode::size(120)->generate($product->qr_code);

        return view('admin.pro_pdf', compact('product', 'qr', 'quality'));
    }

    public function downloadProductPdf(Request $request)
    {
        $product = Product::where('id', $request->id)->first();
        $quality = Quality::Where('id', $product->quality_id)->first();
        $category = Category::Where('id', $product->cat_id)->first();
        $pdf = app('dompdf.wrapper');
        $pdf = \PDF::loadView('admin.pro_pdf_download', array(
            'product' => $product,
            'quality' => $quality,
            'category' => $category,
        ));
        return $pdf->download('Product.pdf');
    }
    public function test()
    {
        $purchaseItems = PurchaseItems::get();
        return view('admin.test', compact('purchaseItems'));
    }

    public function inventoryDC(Request $request, $id)
    {
        $purchaseData = ManagePurchase::where('id', $id)->get();
        $purchaseItems = ManagePurchaseItems::where('purchase_id', $id)->get();
        $products = Product::with(['purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        $products->map(function ($product) {
            $product->current_quantity = ((int) $product->p_quantity - $product->purchaseItems->sum('quantity')) -
                $product->managePurchaseItems->sum('box');
            return $product;
        });
        $quality = Quality::get();
        return view('admin.inventoryDeliveryChallan', compact('purchaseData', 'purchaseItems', 'products', 'quality'));
    }
    public function printBarcode($id)
    {
        $purchaseItems = PurchaseItems::where('purchase_id', $id)->get();
        return view('admin.printBarcode', compact('purchaseItems'));
    }


    public function purchaseManage()
    {
        $products = Product::with(['purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        foreach ($products as $product) {
            $product->current_quantity = ((int) $product->p_quantity + (int) $product->purchaseItems->sum('quantity')) -
                (int) $product->managePurchaseItems->sum('box');
        }

        $quality = Quality::get();
        $purchaseItems = PurchaseItems::with(['stockOutMany', 'stockProducts'])->get();

        foreach ($purchaseItems as $purchaseData) {
            $purchaseData->current_quantity = $purchaseData->available_qty;
        }
        return view('admin.purchaseManage', compact('products', 'quality', 'purchaseItems'));
    }

    public function storePurchaseData(Request $request)
    {
        if (empty($request->prod_name[0])) {
            return redirect()->back()->with('message_err', 'Please Scan at least 1 Product Data');
        }

        $purchaseData = new ManagePurchase;
        $purchaseData->purchase_date = $request->purchase_date;
        $purchaseData->bill_no = $request->bill_no;
        $purchaseData->client_name = $request->client_name;
        $purchaseData->client_contact = $request->client_contact;
        $purchaseData->client_addr = $request->client_addr;
        $purchaseData->refer_by = $request->refer_by;
        $purchaseData->del_boy_name = $request->del_boy_name;
        $purchaseData->del_boy_contact = $request->del_boy_contact;
        $purchaseData->tempo_no = $request->tempo_no;
        $purchaseData->user_id = Auth::user()->id;
        $purchaseData->save();

        $count = count($request->prod_name);

        for ($i = 0; $i < $count; $i++) {
            if ($request->product_id[$i] == null) {
                continue;
            } else {
                $purData = new ManagePurchaseItems;
                $purData->purchase_id = $purchaseData->id;
                $purData->product_id = $request->product_id[$i];
                $purData->size = $request->productSize[$i];
                $purData->rate = $request->productrate[$i];
                $purData->coverage = $request->coverage[$i];
                $purData->batchno = $request->batch_no[$i];
                $purData->box = $request->box[$i];
                $purData->quality = $request->productQuality[$i];
                $purData->weight = $request->weight[$i];
                $purData->total_weight = $request->totalweight[$i];
                $purData->total = $request->totalbalance[$i];
                $purData->save();
            }
        }
        return redirect()->back()->with('message', 'Data saved Successfully');
    }

    public function manageData(Request $request)
    {
        $search = $request->get('search');
        if ($search != null) {
            $productIds = Product::where('p_name', 'like', '%' . $search . '%')->pluck('id')->toArray();
            $purchaseData = ManagePurchase::with('items')->where('client_name', 'like', '%' . $search . '%')->orwhere(function ($query) use ($productIds) {
                $query->whereHas('items', function ($query) use ($productIds) {
                    $query->whereIn('product_id', $productIds);
                });
            })->latest('id')->paginate(10);
            $purchaseData->withPath('manageData')->appends(['search' => $search]);
        } else {
            $purchaseData = ManagePurchase::with('items')->latest('id')->paginate(10);
        }

        foreach ($purchaseData as $value) {
            $value->count = count($value->items);
        }
        return view('admin.managePurchaseData', compact('purchaseData'));
    }

    public function editPurchaseData(Request $request, $id)
    {
        $purchaseData = ManagePurchase::where('id', $id)->get();
        $purchaseItems = ManagePurchaseItems::where('purchase_id', $id)->get();
        $products = Product::with(['purchaseItems', 'managePurchaseItems'])->orderBy('p_name')->get();
        $products->map(function ($product) {
            $product->current_quantity = ((int) $product->p_quantity - $product->purchaseItems->sum('quantity')) - $product->managePurchaseItems->sum('box');
            return $product;
        });
        $quality = Quality::get();
        return view('admin.edit_purchaseData', compact('purchaseData', 'purchaseItems', 'products', 'quality'));
    }

    public function getDeliveryData(Request $request)
    {
        $deliveryId = $request->input('deliveryId');
        $purchaseItems = ManagePurchaseItems::find($deliveryId);
        $purchaseData = ManagePurchase::find($purchaseItems->purchase_id);
        $purchaseItems->delete();
        return response()->json([
            'status' => 'success',
            'data' => $purchaseData,
        ]);
    }
    public function updatePurchaseData(Request $request)
    {
        //dd($request->all());
        $purchaseId = $request->purchase_id;
        $purchaseData = ManagePurchase::find($purchaseId);
        if ($purchaseData) {
            $purchaseData->purchase_date = $request->purchase_date;
            $purchaseData->bill_no = $request->bill_no;
            $purchaseData->client_name = $request->client_name;
            $purchaseData->client_contact = $request->contact;
            $purchaseData->client_addr = $request->client_addr;
            $purchaseData->refer_by = $request->refer_by;
            $purchaseData->del_boy_name = $request->del_boy_name;
            $purchaseData->del_boy_contact = $request->del_boy_contact;
            $purchaseData->tempo_no = $request->tempo_no;
            $purchaseData->user_id = Auth::user()->id;
            $purchaseData->save();
        } else {
            return redirect()->back()->with('message_err', 'Something went wrong');
        }
        $count = count($request->prod_name);
        for ($i = 0; $i < $count; $i++) {
            $productId = $request->product_id[$i];
            $batchNo = $request->batch_no[$i];
            $rate = $request->productSize[$i];
            $purchaseItemId = $request->purchaseItemId[$i];
            if (is_null($productId)) {
                return redirect()->back()->with('message_err', 'Please fill all the fields');
            }
            $deliverychallanData = ManagePurchaseItems::where('id', $purchaseItemId)->first();
            if (is_null($deliverychallanData)) {
                $deliverychallanData = new ManagePurchaseItems;
                $deliverychallanData->purchase_id = $purchaseId;
            }
            $deliverychallanData->product_id = $productId;
            $deliverychallanData->size = $request->productSize[$i] ?? null;
            $deliverychallanData->quality = $request->productQuality[$i] ?? null;
            $deliverychallanData->coverage = $request->coverage[$i] ?? null;
            $deliverychallanData->box = $request->box[$i];
            $deliverychallanData->batchno = $request->batch_no[$i] ?? null;
            $deliverychallanData->rate = $request->productrate[$i];
            $deliverychallanData->weight = round($request->weight[$i], 2);
            $deliverychallanData->total_weight = round($request->totalweight[$i], 2);
            $deliverychallanData->total = round($request->totalbalance[$i], 2);
            $deliverychallanData->save();
        }
        return redirect()->back()->with('message', 'Data Updated Successfully');
    }
    public function trackingDetails(Request $request)
    {
        $trackData = new TrackingData;
        $trackData->purchase_id = $request->del_id;
        $trackData->purchase_date = $request->date;
        $trackData->status = $request->status;
        $trackData->save();
        return redirect()->route('manageData')->with('message', 'Data Saved Successfully');
    }

    public function trackingDetailsData($id)
    {
        $purchase_id = $id;
        $trackingData = TrackingData::where('purchase_id', $id)->get();
        return view('admin.trckingDetails', compact('trackingData', 'purchase_id'));
    }

    public function deleteTrackingData($id)
    {
        $trackingData = TrackingData::find($id);
        if ($trackingData) {
            $trackingData->delete();
            return redirect()->back()->with('message', 'Tracking Data Deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Tracking Data Not Found');
        }
    }
    public function deletePurchaseData($id)
    {
        $purchaseData = ManagePurchase::find($id);
        if ($purchaseData) {
            $purchaseData->delete();
            return redirect()->back()->with('message', 'Purchase Data Deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Purchase Data Not Found');
        }
    }

    public function barcode($id)
    {
        $products = Product::where('id', $id)->get();
        $quality = Quality::get();
        return view('admin.barcode', compact('products', 'quality'));
    }
    public function prodMRP($id)
    {
        $products = Product::where('id', $id)->get();
        return view('admin.prodMRP', compact('products'));
    }

    public function printProduct($id, $prod_id)
    {
        $purchaseItems = PurchaseItems::where(['purchase_id' => $id, 'product_id' => $prod_id])->get();
        $products = Product::where('id', $prod_id)->get();
        return view('admin.printBarcode', compact('purchaseItems', 'products'));
    }
    public function scanBarcode(Request $request)
    {
        // Retrieve the barcode data from the request
        $barcode_data = $request->input('barcode_data');
        $purchaseItems = Product::where('product_code', $barcode_data)->first();
        return response()->json([
            'status' => 'success',
            'data' => $purchaseItems,
        ]);
    }

    public function quotationPayment($id)
    {
        $quotation = Quotation::with('paymentHistory')->find($id);
        $quotation->due_amount = ((float) $quotation->sub_amt - (float) $quotation->paymentHistory->sum('amount'));
        $quotation->total_paid = ((float) $quotation->advance_payment + (float) $quotation->paymentHistory->sum('amount'));
        return view('admin.quotationPayment', compact('quotation'));
    }
    public function checkBarcode()
    {
        return view('admin.checkbarcode');
    }
    public function deleteDeliveryChallanData($id)
    {
        $deliveryChallan = ManagePurchaseItems::find($id);
        $deliveryChallan->delete();
        return redirect()->back()->with('message', 'Row Data deleted successfully');
    }

    public function deleteInvenData($id)
    {
        $inventoryData = PurchaseItems::find($id);
        $purchaseData = Purchase::find($inventoryData->purchase_id);
        $purchaseData->total = $purchaseData->total - $inventoryData->total;
        $purchaseData->save();
        $inventoryData->delete();
        return redirect()->back()->with('message', 'Row Data deleted successfully');
    }

    public function deleteQuotationData($id)
    {
        $quotationData = QuotationItems::find($id);
        $quoData = Quotation::find($quotationData->quotation_id);
        $quoData->sub_amt = $quoData->sub_amt - $quotationData->total;
        $quoData->save();
        $quotationData->delete();
        return redirect()->back()->with('message', 'Row Data deleted successfully');
    }
    public function deleteDeliveryData($id)
    {
        $deliveryData = ManagePurchaseItems::find($id);
        $quoData = managePurchase::find($deliveryData->purchase_id);
        $quoData->save();
        $deliveryData->delete();
        return redirect()->back()->with('message', 'Row Data deleted successfully');
    }

    public function printBarcodeQr($id)
    {
        $purchaseItems = PurchaseItems::where('purchase_id', $id)->get();
        $products = Product::orderBy('p_name')->get();
        return view('admin.printBarcodeQr', compact('purchaseItems', 'products'));
    }

    public function printProductData($id, $prod_id)
    {
        $purchaseItems = PurchaseItems::where(['purchase_id' => $id, 'product_id' => $prod_id])->get();
        $products = Product::where('id', $prod_id)->get();
        return view('admin.printBarcodeQr', compact('purchaseItems', 'products'));
    }


    public function client()
    {
        $data = Client::orderBy('id', 'asc')->paginate(10);
        return view('admin.client', compact('data'));
    }


    public function storeclient(Request $request)
    {
        $clientData = new Client;
        $clientData->name = $request->name;
        $clientData->mobile = $request->mobile;
        $clientData->city = $request->city;
        $clientData->amount = $request->amount;
        $clientData->save();
        return redirect()->route('client')->with('message', 'Data Saved Successfully');
    }
    public function deleteclient(Request $request)
    {
        $client = Client::find($request->id);
        if ($client) {
            $client->delete();
            return redirect()->back()->with('message', 'Client deleted Successfully');
        } else {
            return redirect()->back()->with('message', 'Client Not Found');
        }
    }
    public function updateclient(Request $request)
    {
        $clientData = Client::find($request->c_id);
        $clientData->name = $request->name;
        $clientData->mobile = $request->mobile;
        $clientData->city = $request->city;
        $clientData->amount = $request->amount;
        $clientData->save();

        return redirect()->back()->with('message', 'You have successfully Update Client');
    }
}
