<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quotation extends Model
{
    use HasFactory;

    public $fillable = ['advance_payment', 'sub_amt', 'payment_date', 'payment_status', 'client_name', 'contact', 'attended_by', 'attendee_contact', 'payment_type', 'total_amount', 'del_boy_name', 'del_boy_contact', 'weight_of_goods', 'tempo_no', 'star_mark', 'header_section', 'bottom_section', 'user_id', 'architect', 'architect_contact'];

    protected $appends = ['grand_total'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getGrandTotalAttribute()
    {
        $subAmt = $this->sub_amt ? $this->sub_amt : 0;
        $advancePayment = $this->advance_payment ? $this->advance_payment : 0;
        return (float)$subAmt + (float)$advancePayment;
    }

    public function paymentHistory()
    {
        return $this->hasMany(QuotationPayment::class, 'quotation_id');
    }

    public function quotationItems()
    {
        return $this->hasMany(QuotationItems::class, 'quotation_id');
    }
}
