<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>test Barcode</title>
</head>

<body>
    <div class="container">
        <div>
            <input type="text" id="barcode-input" name="barcode">
        </div>
        <div>
            <table id="barcode-table">
                <thead>
                    <tr>
                        <td>Name</td>
                        <td>quantity</td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>
<script>
    window.addEventListener('event', function(e) {
        console.log(e);
    })
    // Bind an event listener to the input field
    document.getElementById('barcode-input').addEventListener('keydown', function(event) {
        if (event.code == 'Enter') {
            // The Enter key was pressed, so process the barcode
            process_barcode(this.value);
            this.value = ''; // Clear the input field
        }
    });

    // Function to process the barcode
    function process_barcode(barcode) {
        console.log(barcode); // Output the barcode value to the console
        // Do something with the barcode value, such as adding it to the table
        add_row(barcode);
    }

    // Function to add a row to the table
    function add_row(barcode) {
        // Get a reference to the table
        var table = document.getElementById('barcode-table');

        var exists = false;
        for (var i = 1, row; row = table.rows[i]; i++) {
            if (row.cells[0].innerHTML == barcode) {
                row.cells[1].innerHTML = parseInt(row.cells[1].innerHTML) + 1;
                exists = true;
                break;
            }
        }

        if (!exists) {
            var row = table.insertRow(-1);

            // Create a new cell for the barcode value
            var cell1 = row.insertCell(0);
            cell1.innerHTML = barcode;

            // Create a new cell for the quantity
            var cell2 = row.insertCell(1);
            cell2.innerHTML = '1';
        }
    }
</script>
