@extends ('admin.layouts.master')
@section('content')
    <div class="pt-4 px-4">
        <div class="bg-light rounded h-100 p-4">
            <x-session-message />
            <div class="d-flex justify-content-between mb-2">
                <h6 class="mb-4">Manage Inventory</h6>
                <div class="d-flex gap-2">
                    <form class="d-flex" method="GET">
                        <input type="search" class="form-control border-0" name="search" id="search" placeholder="Search">
                        <input type="submit" value="Submit" class="btn btn-success">
                    </form>
                    @if (Request::get('search') != '')
                        <a href="{{ route('managePurchase') }}" class="btn btn-danger">All Purchase</a>
                    @endif
                </div>
                <div></div>
            </div>
            <div class="table-responsive">
                <table class="table text-center">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Purchase&nbsp;Date</th>
                            <th>Bill&nbsp;No</th>
                            <th>Client&nbsp;name</th>
                            <th>Client&nbsp;Contact</th>
                            <th>Items</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="text-center">
                        @foreach ($purchases as $value)
                            <tr>
                                <td class="align-middle">{{ $value->id }}</td>
                                <td class="align-middle">{{ $value->purchase_date }}</td>
                                <td class="align-middle">{{ $value->bill_no }}</td>
                                <td class="align-middle">{{ $value->client_name }}</td>
                                <td class="align-middle">{{ $value->client_contact }}</td>
                                <td class="align-middle">{{ $value->count }}</td>
                                <td class="align-middle">
                                    @auth
                                        @if (Auth::user()->role == 'Admin')
                                            <a href="{{ route('editPurchase', $value->id) }}">
                                                <button type="button" class="btn btn-square btn-success m-2">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                            </a>
                                        @endif
                                    @endauth

                                    @auth
                                        @if (Auth::user()->role == 'Admin')
                                            <a href="{{ route('deletePurchase', $value->id) }}"
                                                onclick="return confirm('Are you sure you want to delete this Inventory?');">
                                                <button type="button" class="btn btn-square btn-danger m-2"><i
                                                        class="fa fa-trash"></i></button></a>
                                        @endif
                                    @endauth
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-end my-3">
                    {{ $purchases->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>
@endsection
