@extends ('admin.layouts.master')
@section('content')
    <div class="container-fluid pt-4 px-4 mb-5">
        <div class="bg-light rounded p-4" style="background: #ececec !important;">
            <x-session-message />
            <div class="d-flex justify-content-between mb-2">
                <h6 class="mb-4">Manage Quotation</h6>
                <div class="d-flex gap-2">
                    <form class="d-flex" method="GET">
                        <input type="search" class="form-control border-0" name="search" id="search"
                            placeholder="Search">
                        <input type="submit" value="Submit" class="btn btn-success">
                    </form>
                    @if (Request::get('search') != '' || Request::get('attendedBy') != '')
                        <a href="{{ route('manageQuotation') }}" class="btn btn-danger">All Quotations</a>
                    @endif
                </div>
                {{--  <div>
                    <button onclick="finished()" id="finishedQtn" class="btn btn-success"
                        title="Quotaiton that have Zero Due Amount">Finished</button>
                    <button onclick="starQuo()" id="strQtn" class="btn btn-success">Starred</button>
                    <button onclick="manQuo()" id="mngQtn" class="btn btn-success">All</button>
                </div>  --}}
            </div>

            <div class="table-responsive text-center" id="manageQuotation" style="">
                <table class="table table  table-hover ">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Client&nbsp;Name</th>
                            <th>Product&nbsp;Items</th>
                            <th style="display: none">Product&nbsp;Name</th>
                            <th>Created&nbsp;Date</th>
                            <th>User</th>
                            <th>Attended&nbsp;By</th>
                            <th>Options</th>
                            <th>Mark&nbsp;As&nbsp;Star</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($quotations as $value)
                            <tr>
                                <td class="align-middle">{{ $value->id }}</td>
                                <td class="align-middle">{{ $value->client_name }}</td>
                                <td class="align-middle">{{ $value->productCount }}</td>
                                @foreach ($value->quotationProduct as $data)
                                    <td class="align-middle" style="display: none">{{ $data->p_name }}</td>
                                @endforeach
                                <td class="align-middle">{{ $value->created_at }}</td>
                                <td class="align-middle">{{ $value->creator }}</td>
                                <td class="align-middle">{{ $value->attended_by }}</td>
                                <td class="align-middle">
                                    @auth
                                        @if (Auth::user()->role == 'Admin')
                                            <a href="{{ route('editQuotation', $value->id) }}"
                                                class="btn btn-square btn-success m-2">
                                                <i class="fa fa-edit" title="Edit Quotation"></i>
                                            </a>
                                        @endif
                                    @endauth
                                    @auth
                                        @if (Auth::user()->role == 'Admin')
                                            <a href="{{ route('deleteQuotation', $value->id) }}"
                                                onclick="return confirm('Are you sure you want to delete this Quotation?');"><button
                                                    type="button" class="btn btn-square btn-danger m-2"><i class="fa fa-trash"
                                                        title="Delete Quotation"></i></button></a>
                                        @endif
                                    @endauth
                                    @auth
                                        @if (Auth::user()->role == 'Admin')
                                            <a href="{{ route('quotationPayment', $value->id) }}"
                                                class="btn btn-square btn-success m-2">
                                                Pay
                                            </a>
                                        @endif
                                    @endauth
                                    <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                        data-bs-target="#deliveryModalByManage"
                                        onclick="deliveryData('{{ $value->id }}','{{ $value->total_weight }}')">
                                        DC
                                    </button>
                                    <a href="{{ route('printChallan', $value->id) }}" target="_blank"
                                        class="btn btn-square btn-success m-2">
                                        Print
                                    </a>
                                    {{--  <a href="{{ route('quotation', $value->id) }}?type=code" target="_blank"
                                        class="btn btn-success p-1 m-0">
                                       Q Code 
                                    </a>  --}}
                                    <a href="{{ route('quotation', $value->id) }}?type=name" target="_blank"
                                        class="btn btn-success p-1 m-0">
                                        Q Name
                                    </a>
                                    {{--  <a href="{{ url('quotationMain', $value->id) }}?type=code" target="_blank"
                                        class="btn btn-success p-1 m-0"><i class="fa fa-download">&nbsp;Code</i>
                                    </a>  --}}
                                    <a href="{{ url('quotationMain', $value->id) }}?type=name"
                                        target="_blank"class="btn btn-success p-1 m-0">
                                        <i class="fa fa-download">&nbsp;Name</i>
                                    </a>
                                </td>
                                <td class="align-middle">
                                    <label>
                                        <input class="form-check-input" type="checkbox"
                                            @if ($value->star_mark == 1) Checked @endif>
                                    </label>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-end my-3" id="manageQuo-div">
                    {{ $quotations->links('pagination::bootstrap-4') }}
                </div>
            </div>
            <div class="table-responsive text-center" id="starQuotation">
                <table class="table">
                    <thead class="text-center">
                        <tr>
                            <th>Id</th>
                            <th>Client&nbsp;Name</th>
                            <th>Product&nbsp;Items</th>
                            <th style="display: none">Product&nbsp;Name</th>
                            <th>Created&nbsp;Date</th>
                            <th>User</th>
                            <th>Attended&nbsp;By</th>
                            <th>Options</th>
                            <th>Mark&nbsp;As&nbsp;Star</th>
                        </tr>
                    </thead>
                    @foreach ($markedQuotations as $data)
                        <tbody class="text-center">
                            <tr>
                                <td class="align-middle">{{ $data->id }}</td>
                                <td class="align-middle">{{ $data->client_name }}</td>
                                <td class="align-middle">{{ $data->productCount }}</td>
                                @foreach ($data->quotationProduct as $value)
                                    <td class="align-middle" style="display: none">{{ $value->p_name }}</td>
                                @endforeach
                                <td class="align-middle">{{ $data->created_at }}</td>
                                <td class="align-middle">{{ $data->creator }}</td>
                                <td class="align-middle">{{ $data->attended_by }}</td>
                                <td>
                                    <a href="{{ route('editQuotation', $data->id) }}">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i class="fa fa-edit" title="Edit Quotation"></i>
                                        </button></a>
                                    <a href="{{ route('deleteQuality', $data->id) }}"
                                        onclick="return confirm('Are you sure you want to delete this Quotation?');"><button
                                            type="button" class="btn btn-square btn-danger m-2"><i class="fa fa-trash"
                                                title="Delete Quotation"></i></button></a>
                                    <a href="{{ route('quotationPayment', $data->id) }}">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i class="fa-duotone fa-indian-rupee-sign" title="Payment">Pay</i>
                                        </button></a>
                                    <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                        data-bs-target="#deliveryModalByStar"
                                        onclick="deliveryDataStar('{{ $data->id }}','{{ $data->total_weight }}')">
                                        <i class="fa-duotone fa-indian-rupee-sign" title="Delivery Challan">DC</i>
                                    </button>
                                    <a href="{{ route('printChallan', $data->id) }}" target="_blank">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i title="Print Quotation">Print</i>
                                        </button></a>
                                    <a href="{{ route('quotation', $data->id) }}" target="_blank">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i title="Quotation">Quo</i>
                                        </button></a>
                                </td>
                                <td class="align-middle">
                                    <label>
                                        <input class="form-check-input" type="checkbox"
                                            @if ($value->star_mark == 0) Checked @endif
                                            onclick="return setCheckUncheck({{ $value->id }},'{{ $value->star_mark != 0 }}')"
                                            readonly>
                                    </label>
                                </td>
                            </tr>
                        </tbody>
                    @endforeach
                </table>
                <div class="d-flex justify-content-end my-3">
                    {{ $markedQuotations->links('pagination::bootstrap-4') }}
                </div>
            </div>
            <div class="table-responsive text-center" id="finishedQuotation">
                <table class="table table-bordered ">
                    <thead class="text-center">
                        <tr>
                            <th>Id</th>
                            <th>Client&nbsp;Name</th>
                            <th>Product&nbsp;Items</th>
                            <th style="display: none">Product&nbsp;Name</th>
                            <th>Created&nbsp;Date</th>
                            <th>User</th>
                            <th>Attended&nbsp;By</th>
                            <th>Options</th>
                            <th>Mark&nbsp;As&nbsp;Star</th>
                        </tr>
                    </thead>
                    @foreach ($finalQuotation as $data)
                        <tbody class="text-center">
                            <tr>
                                <td class="align-middle">{{ $data->id }}</td>
                                <td class="align-middle">{{ $data->client_name }}</td>
                                <td class="align-middle">{{ $data->productCount }}</td>
                                @foreach ($data->quotationProduct as $value)
                                    <td class="align-middle" style="display: none">{{ $value->p_name }}</td>
                                @endforeach
                                <td class="align-middle">{{ $data->created_at }}</td>
                                <td class="align-middle">{{ $data->creator }}</td>
                                <td class="align-middle">{{ $data->attended_by }}</td>
                                <td>
                                    <a href="{{ route('editQuotation', $data->id) }}">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i class="fa fa-edit" title="Edit Quotation"></i>
                                        </button></a>
                                    <a href="{{ route('deleteQuality', $data->id) }}"
                                        onclick="return confirm('Are you sure you want to delete this Quotation?');"><button
                                            type="button" class="btn btn-square btn-danger m-2"><i class="fa fa-trash"
                                                title="Delete Quotation"></i></button></a>
                                    <a href="{{ route('quotationPayment', $data->id) }}">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i class="fa-duotone fa-indian-rupee-sign" title="Payment">Pay</i>
                                        </button></a>
                                    <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                        data-bs-target="#deliveryModalByStar"
                                        onclick="deliveryDataStar('{{ $data->id }}','{{ $data->total_weight }}')">
                                        <i class="fa-duotone fa-indian-rupee-sign" title="Delivery Challan">DC</i>
                                    </button>
                                    <a href="{{ route('printChallan', $data->id) }}" target="_blank">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i title="Print Quotation">Print</i>
                                        </button></a>
                                    <a href="{{ route('quotation', $data->id) }}" target="_blank">
                                        <button type="button" class="btn btn-square btn-success m-2">
                                            <i title="Quotation">Quo</i>
                                        </button></a>
                                    <a href="{{ route('quotationfinalbill', $data->id) }}" target="_blank">
                                        <button type="button" class="btn  btn-success m-2">
                                            <i title="Quotation">Final Bill</i>
                                        </button></a>
                                </td>
                                <td class="align-middle">
                                    <label>
                                        <input class="form-check-input" type="checkbox"
                                            @if ($value->star_mark == 0) Checked @endif
                                            onclick="return setCheckUncheck({{ $value->id }},'{{ $value->star_mark != 0 }}')"
                                            readonly>
                                    </label>
                                </td>
                            </tr>
                        </tbody>
                    @endforeach
                </table>
                <div class="d-flex justify-content-end my-3">
                    {{ $finalQuotation->links('pagination::bootstrap-4') }}
                </div>
            </div>
            <div class="modal fade" id="deliveryModalByManage" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Delivery&nbsp;Challan</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('deliveryChallan') }}" method="POST">
                            @csrf
                            <input type="hidden" id="del_id" name="del_id">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Product&nbsp;Details:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <div id="quotations_edit_items"></div>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for=""
                                            style="font: bold;color:black">Delivery&nbsp;Boy&nbsp;Name:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="del_boy_name" class="form-control">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Contact&nbsp;Number:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="contact_no" class="form-control" pattern="[0-9]{10}"
                                            maxlength="10">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Weight&nbsp;Of&nbsp;Goods
                                            :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="totalWeight" id="totalWeight" class="form-control"
                                            readonly>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Tempo&nbsp;No
                                            :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="tempo_no" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer justify-content-center">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="deliveryModalByStar" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Delivery&nbsp;Challan</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('deliveryChallanByStar') }}" method="POST">
                            @csrf
                            <input type="hidden" id="delv_id" name="delv_id">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Product&nbsp;Details:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <div id="quotations_edit_staritems"></div>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for=""
                                            style="font: bold;color:black">Delivery&nbsp;Boy&nbsp;Name:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="del_boy_name" class="form-control">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Contact&nbsp;Number:</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="contact_no" class="form-control" pattern="[0-9]{10}"
                                            maxlength="10">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Weight&nbsp;Of&nbsp;Goods
                                            :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="totalWeightStar" id="totalWeightStar"
                                            class="form-control" readonly>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="" style="font: bold;color:black">Tempo&nbsp;No
                                            :</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" name="tempo_no" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer justify-content-center">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Blank End -->
        <script type="text/javascript">
            $("#mngQtn").hide();
            $("#starQuotation").hide();
            $("#finishedQuotation").hide();
            let quotations = @JSON($quotations).data;
            let products = [];

            function paymentData(id, total, name, advance, type, status, date, totalamt, paidup) {
                document.getElementById('q_id').value = id;
                document.getElementById('d_id').value = id;
                document.getElementById('clientName').value = name;
                document.getElementById('grand_total').value = parseInt(total) + parseInt(advance);
                document.getElementById('advance_pay').value = advance;
                document.getElementById('paidup').value = paidup;
                document.getElementById('due_amount').value = parseInt(total) - parseInt(paidup);
                document.getElementById('advance_pay').value = advance;
                document.getElementById('paid_amt').value = paidup;
                document.getElementById('rem_amt').value = parseInt(total) - parseInt(paidup);
                document.getElementById('pay_type').value = type;
                document.getElementById('due_date').value = date;
            }

            function paymentDataStar(id, total, name, advance, type, status, date, totalamt) {
                document.getElementById('quo_id').value = id;
                document.getElementById('del_id').value = id;
                document.getElementById('client_Name').value = name;
                document.getElementById('grandTotal').value = parseFloat(total) + parseFloat(advance);
                document.getElementById('advancePay').value = advance;
                document.getElementById('paidup').value = paidup;
                document.getElementById('dueAmount').value = parseFloat(total) - parseFloat(advance);
                document.getElementById('advance_pay').value = advance;
                document.getElementById('paidAmt').value = paidup;
                document.getElementById('remAmt').value = parseFloat(total) - parseFloat(paidup);
                document.getElementById('payType').value = type;
                document.getElementById('dueDate').value = date;
            }

            function deliveryData(id, weight) {
                document.getElementById('del_id').value = id;
                document.getElementById('totalWeight').value = weight;
                let products = quotations.find((item) => item.id == id).quotationProduct;
                let items = quotations.find((item) => item.id == id).quotation_items;
                console.log(items);
                let html = '';
                products.forEach((item, x) => {
                    if (items[x].unit_remain === '0') {
                        return; // Skip this iteration
                    }

                    html += `<div class="form-control">
                        <input type="checkbox" name="product_${items[x].id}"`;

                    console.log(items[x].weight);
                    if (items[x].included == "1") {
                        html += `checked`;
                    }
                    html += `>
                            <label for="">${item.p_name}</label>
                            <input type="text" name="box_${items[x].id}"`;

                    if (items[x].unit_send == null) {
                        html += `value="${items[x].box}"`;
                    } else {
                        html += `value="${items[x].unit_remain}"`;
                        // html += `value="${items[x].box}-${items[x].unit_send}"`;
                    }
                    //if (items[x].unit_send == null) {
                    //    html += `value="${items[x].box}"`;
                    // } else {
                    //    const calculatedValue = items[x].box - items[x].unit_send; // Perform the calculation
                    //    html += `value="${calculatedValue}"`; // Use the result as the value
                    //}

                    html += `oninput="updateWieght(${items[x].weight})"></div>`;
                });
                document.getElementById('quotations_edit_items').innerHTML = html;
            }


            function updateWieght(p) {
                console.log(p);
                let boxes = document.querySelectorAll('input[name^="box_"]');
                let totalWeight = 0;
                boxes.forEach((box) => {
                    let weight = box.value;
                    products.forEach((item) => {
                        if (item.id == box.name.split('_')[1]) {
                            weight = weight * item.weight;
                        }
                    });
                    totalWeight += parseInt(weight);
                });

                if (isNaN(totalWeight)) {
                    totalWeight = p;
                }

                document.getElementById('totalWeight').value = totalWeight;
            }

            function deliveryDataStar(id, weight) {
                document.getElementById('delv_id').value = id;
                document.getElementById('totalWeightStar').value = weight;
                let html = '';
                document.getElementById('quotations_edit_staritems').innerHTML = html;
                let products = quotations.find((item) => item.id == id).quotationProduct;
                let items = quotations.find((item) => item.id == id).quotation_items;
                products.forEach((item, x) => {
                    html += `<div class="form-control">
                            <input type="checkbox" name="product_${items[x].id}"`;

                    if (items[x].included == "1") {
                        html += `checked`;
                    }
                    html += `>
                            <label for="">${item.p_name}</label>
                            <input type="text" name="box_${items[x].id}"`;
                    if (items[x].unit_send == null) {
                        html += `value="${items[x].box}"`;
                    } else {
                        html += `value="${items[x].unit_remain}"`;
                    }

                    html += `oninput="updateWieght()"></div>`;
                });

                document.getElementById('quotations_edit_staritems').innerHTML = html;
            }

            function setCheckUncheck(id, check) {
                var status = "";
                if (check == false || '') {
                    status = "0";
                } else {
                    status = "1";
                }
                $.ajax({
                    type: "POST",
                    url: "{{ route('setCheckUncheck') }}",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "status": status,
                        "id": id
                    },
                    success: function(resp) {
                        console.log(resp);
                        location.reload();
                    },
                });
            }

            function starQuo() {
                $("#starQuotation").show();
                $("#strQtn").hide();
                $("#manageQuotation").hide();
                $("#mngQtn").show();
                $("#finishedQuotation").hide();
                $("#finishedQtn").show();
            }

            function manQuo() {
                $("#starQuotation").hide();
                $("#strQtn").show();
                $("#manageQuotation").show();
                $("#mngQtn").hide();
                $("#finishedQuotation").hide();
                $("#finishedQtn").show();
            }

            function finished() {
                $("#starQuotation").hide();
                $("#strQtn").show();
                $("#manageQuotation").hide();
                $("#mngQtn").show();
                $("#finishedQuotation").show();
                $("#finishedQtn").hide();
            }
        </script>
    @endsection
