@extends ('admin.layouts.master')
@section('content')
    <!-- Blank Start -->
    <div class="container pt-4 px-4">
        <div class="col-12">
            <div class="bg-light rounded h-100 p-4">
                @if (Session::has('message'))
                    <div class="alert alert-success alert-dismissible">
                        <strong> {{ Session::get('message') }} </strong>
                        <button type="button" class="close" data-bs-dismiss="alert">&times;</button>
                    </div>
                @endif
                <div class="row">
                    <div class="bg-light rounded h-100 p-4">
                        <h6 class="mb-4">Order Reports</h6>
                        <form action="{{ route('getReport') }}" method="POST">
                            @csrf
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Start Date </label>
                                <div class="col-md-10">
                                    <input type="date" class="form-control" name="start_date">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">End Date </label>
                                <div class="col-md-10">
                                    <input type="date" class="form-control" name="end_date">
                                </div>
                            </div>




                            <button type="submit" class="btn btn-success">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Blank End -->
@endsection
