<?php $__env->startSection('content'); ?>
    <!-- Blank Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="col-12">
            <div class="bg-light rounded h-100 p-4">
                <?php if(count($errors) > 0): ?>
                    <div class="alert alert-danger tcs_alert">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <?php if(Session::has('message')): ?>
                    <div class="alert alert-success alert-dismissible tcs_alert">
                        <strong> <?php echo e(Session::get('message')); ?> </strong>
                        <button type="button" class="close" data-bs-dismiss="alert">&times;</button>
                    </div>
                <?php endif; ?>
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="mb-4">Add User</h6>
                    </div>
                    <div class="col-md-4">
                        <form class="d-none d-md-flex ms-4">
                            <input class="form-control border-0" type="search" placeholder="Search">
                        </form>
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addModal">
                            + Add User
                        </button>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">User name</th>
                                <th scope="col">Options</th>

                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($value->id); ?></td>
                                    <td><?php echo e($value->name); ?></td>
                                    <td>
                                        <button type="button" class="btn btn-square btn-success m-2" data-bs-toggle="modal"
                                            data-bs-target="#editModal"
                                            onclick="updatequantity('<?php echo e($value->id); ?>','<?php echo e($value->name); ?>')">
                                            <i class="fa fa-edit"></i>
                                        </button>

                                        <a href="<?php echo e(route('deleteUser', $value->id)); ?>"
                                            onclick="return confirm('Are you sure you want to delete this Tips?');"><button
                                                type="button" class="btn btn-square btn-danger m-2"><i
                                                    class="fa fa-trash"></i></button></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <div class="d-flex justify-content-end my-3">
                        <?php echo e($user->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
            
            <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Add User</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="<?php echo e(route('storeUser')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <label style="font: bold;color:black">User Name :</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="text" name="user_Name" class="form-control" placeholder="User Name"
                                            value="">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label style="font: bold;color:black">Password :</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="password" name="password" class="form-control" placeholder="Password">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="" style="font: bold;color:black">Email :</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="email" name="email" class="form-control"
                                            placeholder="Email Address">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="" style="font: bold;color:black">Role :</label>
                                    </div>
                                    <div class="col-md-9">
                                        <select name="role" id="role" class="form-control">
                                            <option value="">~Select~</option>
                                            <option value="Admin">Admin</option>
                                            <option value="User">User</option>
                                        </select>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="" style="font: bold;color:black">Mobile :</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="number" name="mobile" class="form-control"
                                            placeholder="Contact Number">
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            
            <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Update User</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="<?php echo e(route('updateUser')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="user_id" name="user_id">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="" style="font: bold;color:black">User Name :</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="text" id="u_name" name="u_name" class="form-control"
                                            placeholder="User Name">
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label style="font: bold;color:black">Password :</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="password" name="pass" class="form-control"
                                            placeholder="Password">
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function updatequantity(id, user_Name) {
            console.log(id);
            document.getElementById('user_id').value = id;
            document.getElementById('u_name').value = user_Name;

        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/virajceramics/public_html/dev/resources/views/admin/addUser.blade.php ENDPATH**/ ?>