<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Product;
use App\Models\Quotation;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        if ($request->has('start_date')) {
            $start_date = Carbon::parse($request->start_date);
        } else {
            $start_date = Carbon::today();
        }

        if ($request->has('end_date')) {
            $end_date = Carbon::parse($request->end_date);
        } else {
            $end_date = $start_date->copy()->subDay(365);
        }

        if ($start_date > $end_date) {
            $temp = $start_date;
            $start_date = $end_date;
            $end_date = $temp;
        }

        $end_date = $end_date->copy()->addDay(1)->subSecond(1);

        $total_product = Product::count();
        $quotation = Quotation::whereBetween('created_at',  [$start_date, $end_date])->get();

        $quotationAttendedBy =  $quotation->pluck('attended_by')->unique()->toArray();

        $users = [];

        foreach ($quotationAttendedBy as $value) {
            $user = ucfirst(strtolower($value));
            if ($value == null || $value == '' || in_array($user, $users) || str_contains($user, ' ')) {
                continue;
            }
            $users[] = $user;
        }
        $userWise = [];
        // foreach ($users as $user) {
        //     $quotations = Quotation::with('paymentHistory,quotationItems')->where('attended_by', 'like',  '%' . $user . '%')->whereBetween('created_at',  [$start_date, $end_date])->get();
        //     $userWise[] = [
        //         'name' => $user,
        //         'amount' => $quotations->where('advance_payment', '>', 0)->sum('sub_amt'),
        //         'count' => $quotations->where('advance_payment', '>', 0)->count(),
        //         'total' => $quotations->count()
        //     ];
        // }
        // foreach ($users as $user) {
        //     $quotations = Quotation::with('paymentHistory', 'quotationItems')->where('attended_by', 'like',  '%' . $user . '%')->whereBetween('created_at',  [$start_date, $end_date])->get();
        //     $userWise[] = [
        //         'name' => $user,
        //         'amount' => $quotations->$paymentHistory->sum('amount'),
        //         'count' => $quotations->where('advance_payment', '>', 0)->count(),
        //         'total' => $quotations->count()
        //     ];
        // }
        foreach ($users as $user) {
            $quotations = Quotation::with('paymentHistory', 'quotationItems')
                ->where('attended_by', 'like', '%' . $user . '%')
                ->whereBetween('created_at', [$start_date, $end_date])
                ->get();

            $totalAmount = $quotations->where('star_mark', '1')->reduce(function ($carry, $quotation) {
                return $carry + $quotation->quotationItems->sum('total');
            }, 0);

            $userWise[] = [
                'name' => $user,
                'amount' => $totalAmount,
                'count' => $quotations->where('star_mark', '1')->count(),
                'total' => $quotations->count(),
            ];
        }

        $userWise = collect($userWise)->sortByDesc('count')->toArray();

        $total_orders = Quotation::count();

        return view('home', compact('total_product', 'userWise', 'quotation', 'start_date', 'end_date'));
    }
}
