<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotation_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('quotation_id');
            $table->foreign('quotation_id')->references('id')->on('quotations')->onDelete('cascade');
            $table->unsignedBigInteger('product_id');
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->string('size')->nullable();
            $table->string('quality')->nullable();
            $table->string('rate')->nullable();
            $table->string('coverage')->nullable();
            $table->string('box')->nullable();
            $table->string('discount')->nullable();
            $table->string('application_area')->nullable();
            $table->string('total')->nullable();
            $table->string('weight')->nullable();
            $table->string('total_weight')->nullable();
            $table->boolean('included')->default(1);
            $table->string('unit_send')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotation_items');
    }
};
