<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\TwilioSMSController;
use App\Http\Controllers\DashboardAPIController;

Route::get('/', function () {
    return view('auth.login');
});
Route::get('checkBarcode', [DashboardController::class, 'checkBarcode']);

Auth::routes();

Route::get('/home', [HomeController::class, 'index'])->name('home');
Route::get('addUser', [DashboardController::class, 'addUser'])->name('addUser');
Route::post('storeUser', [DashboardController::class, 'storeUser'])->name('storeUser');
Route::post('updateUser', [DashboardController::class, 'updateUser'])->name('updateUser');
Route::get('deleteUser/{id}', [DashboardController::class, 'deleteUser'])->name('deleteUser');
Route::get('changePassword', [DashboardController::class, 'changePassword'])->name('changePassword');
Route::post('updatePassword', [DashboardController::class, 'updatePassword'])->name('updatePassword');
Route::get('quality', [DashboardController::class, 'quality'])->name('quality');
Route::get('deleteQuality/{id}', [DashboardController::class, 'deleteQuality'])->name('deleteQuality');
Route::post('updateQuality', [DashboardController::class, 'updateQuality'])->name('updateQuality');
Route::post('storeQuality', [DashboardController::class, 'storeQuality'])->name('storeQuality');
Route::get('type', [DashboardController::class, 'type'])->name('type');
Route::get('deleteType/{id}', [DashboardController::class, 'deletetype'])->name('deleteType');
Route::post('updateType', [DashboardController::class, 'updatetype'])->name('updateType');
Route::post('storeType', [DashboardController::class, 'storetype'])->name('storeType');
Route::get('category', [DashboardController::class, 'category'])->name('category');
Route::post('storeCategory', [DashboardController::class, 'storeCategory'])->name('storeCategory');
Route::get('deleteCategory/{id}', [DashboardController::class, 'deleteCategory'])->name('deleteCategory');
Route::post('updateCategory', [DashboardController::class, 'updateCategory'])->name('updateCategory');
Route::get('product', [DashboardController::class, 'product'])->name('product');
Route::post('storeProduct', [DashboardController::class, 'storeProduct'])->name('storeProduct');
Route::get('deleteProduct/{id}', [DashboardController::class, 'deleteProduct'])->name('deleteProduct');
Route::post('updateProduct', [DashboardController::class, 'updateProduct'])->name('updateProduct');
Route::get('notInStockProducts', [DashboardController::class, 'notInStockProducts'])->name('notInStockProducts');
Route::get('lessInStockProducts', [DashboardController::class, 'lessInStockProducts'])->name('lessInStockProducts');
Route::get('fastMoving', [DashboardController::class, 'fastMoving'])->name('fastMoving');

Route::get('Notes', [DashboardController::class, 'Notes'])->name('Notes');
Route::post('updateNotes', [DashboardController::class, 'updateNotes'])->name('updateNotes');
Route::post('getPurchaseItems', [DashboardController::class, 'getPurchaseItems'])->name('getPurchaseItems');
Route::get('report', [DashboardController::class, 'report'])->name('report');
Route::post('getReport', [DashboardController::class, 'getReport'])->name('getReport');
Route::post('storeNotes', [DashboardController::class, 'storeNotes'])->name('storeNotes');
Route::get('deleteNotes/{id}', [DashboardController::class, 'deleteNotes'])->name('deleteNotes');
Route::get('addPurchase', [DashboardController::class, 'purchase'])->name('addPurchase');
Route::post('storePurchase', [DashboardController::class, 'storePurchase'])->name('storePurchase');
Route::post('getInventoryData', [DashboardController::class, 'getInventoryData'])->name('getInventoryData');
Route::get('editPurchase/{id}', [DashboardController::class, 'editPurchase'])->name('editPurchase');
Route::post('updatePurchase', [DashboardController::class, 'updatePurchase'])->name('updatePurchase');
Route::get('deletePurchase/{id}', [DashboardController::class, 'deletePurchase'])->name('deletePurchase');
Route::get('managePurchase', [DashboardController::class, 'managePurchase'])->name('managePurchase');
Route::get('AddQuotation', [DashboardController::class, 'AddQuotation'])->name('AddQuotation');

Route::post('getQuotation', [DashboardController::class, 'getQuotation'])->name('getQuotation');
Route::get('manageQuotation', [DashboardController::class, 'manageQuotation'])->name('manageQuotation');
Route::get('finalQuotation', [DashboardController::class, 'finalQuotation'])->name('finalQuotation');
Route::get('completeQuotation', [DashboardController::class, 'completeQuotation'])->name('completeQuotation');
Route::get('editQuotation/{id}', [DashboardController::class, 'editQuotation'])->name('editQuotation');
Route::post('updateQuotation', [DashboardController::class, 'updateQuotation'])->name('updateQuotation');
Route::post('storeQuotation', [DashboardController::class, 'storeQuotation'])->name('storeQuotation');
Route::post('storePayment', [DashboardController::class, 'storePayment'])->name('storePayment');
Route::get('showQuotation/{id}', [DashboardController::class, 'showQuotation'])->name('showQuotation');
Route::post('deliveryChallan', [DashboardController::class, 'deliveryChallan'])->name('deliveryChallan');
Route::post('deliveryChallanByStar', [DashboardController::class, 'deliveryChallanByStar'])->name('deliveryChallanByStar');
Route::get('printChallan/{id}', [DashboardController::class, 'printChallan'])->name('printChallan');
Route::post('setCheckUncheck', [DashboardController::class, 'starMark'])->name('setCheckUncheck');
// Route::post('setUnchecked', [DashboardController::class, 'starMarked'])->name('setUnchecked');
Route::get('quotation/{id}', [DashboardController::class, 'quotation'])->name('quotation');
Route::get('quotationfinalbill/{id}', [DashboardController::class, 'quotationfinalbill'])->name('quotationfinalbill');
Route::get('deleteQuotation/{id}', [DashboardController::class, 'deleteQuotation'])->name('deleteQuotation');
Route::get('quotationMain/{id}', [DashboardController::class, 'quotationMainPDF'])->name('quotationMain');


Route::get('deletePaymentData/{id}', [DashboardController::class, 'deletePaymentData'])->name('deletePaymentData');

Route::get('productPDF', [DashboardController::class, 'productPDF'])->name('productPDF');
Route::get('productPDFDownload', [DashboardController::class, 'productPDFDownload'])->name('productPDFDownload');

Route::post('searchQuality', [DashboardController::class, 'searchQuality'])->name('searchQuality');
Route::post('changeValueSize', [DashboardController::class, 'changeValueSize'])->name('changeValueSize');
Route::post('changeValueQuality', [DashboardController::class, 'changeValueQuality'])->name('changeValueQuality');
Route::get('proPdf/{id}', [DashboardController::class, 'proPdf'])->name('proPdf');
Route::get('admin/pro_pdf_download/{id}', [DashboardController::class, 'downloadProductPdf'])->name('admin.pro_pdf_download');

Route::get('getPurById', [DashboardController::class, 'getPurById'])->name('getPurById');
Route::get('inventoryDC/{id}', [DashboardController::class, 'inventoryDC'])->name('inventoryDC');
Route::get('printBarcode/{id}', [DashboardController::class, 'printBarcode'])->name('printBarcode');
Route::get('purchaseManage', [DashboardController::class, 'purchaseManage'])->name('purchaseManage');
Route::post('storePurchaseData', [DashboardController::class, 'storePurchaseData'])->name('storePurchaseData');
Route::get('manageData', [DashboardController::class, 'manageData'])->name('manageData');
Route::get('editPurchaseData/{id}', [DashboardController::class, 'editPurchaseData'])->name('editPurchaseData');
Route::post('trackingDetails', [DashboardController::class, 'trackingDetails'])->name('trackingDetails');
Route::get('deletePurchaseData/{id}', [DashboardController::class, 'deletePurchaseData'])->name('deletePurchaseData');
Route::post('updatePurchaseData', [DashboardController::class, 'updatePurchaseData'])->name('updatePurchaseData');
Route::post('getDeliveryData', [DashboardController::class, 'getDeliveryData'])->name('getDeliveryData');
Route::get('barcode/{id}', [DashboardController::class, 'barcode'])->name('barcode');
Route::get('prodMRP/{id}', [DashboardController::class, 'prodMRP'])->name('prodMRP');
Route::get('printProduct/{id}/{prod_id}', [DashboardController::class, 'printProduct'])->name('printProduct');
Route::get('quotationPayment/{id}', [DashboardController::class, 'quotationPayment'])->name('quotationPayment');
Route::get('deleteDeliveryChallanData/{id}', [DashboardController::class, 'deleteDeliveryChallanData'])->name('deleteDeliveryChallanData');
Route::get('deleteInvenData/{id?}', [DashboardController::class, 'deleteInvenData'])->name('deleteInvenData');
Route::get('deleteQuotationData/{id?}', [DashboardController::class, 'deleteQuotationData'])->name('deleteQuotationData');
Route::get('deleteDeliveryData/{id?}', [DashboardController::class, 'deleteDeliveryData'])->name('deleteDeliveryData');
Route::get('printBarcodeQr/{id}', [DashboardController::class, 'printBarcodeQr'])->name('printBarcodeQr');
Route::get('trackingDetailsData/{id}', [DashboardController::class, 'trackingDetailsData'])->name('trackingDetailsData');
Route::get('deleteTrackingData/{id}', [DashboardController::class, 'deleteTrackingData'])->name('deleteTrackingData');

Route::get('sendSMS', [TwilioSMSController::class, 'index']);
Route::post('/scan-barcode', [DashboardController::class, 'scanBarcode'])->name('scan-barcode');
Route::post('/categoryData', [DashboardController::class, 'categoryData'])->name('categoryData');
Route::get('printProductData/{id}/{prod_id}', [DashboardController::class, 'printProductData'])->name('printProductData');


Route::get('creditor', [DashboardController::class, 'creditor'])->name('creditor');
Route::get('creditorPDF', [DashboardController::class, 'creditorPDF'])->name('creditorPDF');

Route::get('client', [DashboardController::class, 'client'])->name('client');
Route::get('deleteclient/{id}', [DashboardController::class, 'deleteclient'])->name('deleteClient');
Route::post('updateclient', [DashboardController::class, 'updateclient'])->name('updateClient');
Route::post('storeclient', [DashboardController::class, 'storeclient'])->name('storeClient');

Route::get('/clean-cache', function () {
    $exitCode = Artisan::call('cache:clear');
    $exitCode = Artisan::call('route:cache');
    $exitCode = Artisan::call('route:clear');
    $exitCode = Artisan::call('view:cache');
    $exitCode = Artisan::call('view:clear');
    $exitCode = Artisan::call('config:cache');
    $exitCode = Artisan::call('config:clear');
    $exitCode = Artisan::call('event:cache');
    $exitCode = Artisan::call('event:clear');
    $exitCode = Artisan::call('optimize');
    return '<h1>Cache facade value cleared</h1>';
});
