<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css"
        integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">

    <title>Delivery Challan</title>
</head>
<style>
    .container {
        width: 1000px;
    }

    .wrapper {
        width: 100%;
        border: 1px solid #000;
        margin: 10px 0;

        .row {
            border-bottom: 1px solid #000;

            .border-right {
                border-right: 1px solid #000;
            }
        }

        .no-border {
            border-bottom: 0;
        }
    }

    .margin-0 {
        margin: 0;
    }

    .padding-0 {
        padding: 0;
    }

    img {
        height: 104px;
        width: 200px;
    }

    .table {
        width: 100%;
        margin: 0;

        >tbody>tr {
            >td {
                border: 1px solid #000;
                padding: 5px 0 5px 10px;
                width: 50%;
            }

            .first {
                border-top: 0;
            }

            .last {
                border-bottom: 0;
            }

            b {
                display: block;
            }

            span {
                font-size: 12px;
            }
        }
    }

    .invoice-bill {
        width: 100%;

        td {
            border: 1px solid #000;
            padding: 5px;
        }

        .serial-no {
            width: 70px;
        }

        .particulars {
            width: 500px;
        }

        .amount {
            width: 150px;
        }

        .particular-items {
            padding: 5px 10px;
        }

        .amount-items {
            padding: 5px 0;
        }
    }

    .entry-id {
        margin: 35px 0;
    }

    .bank-details {
        margin-top: 30px;
    }

    .authorised-sign-wrapper {
        width: 300px;
        border: 1px solid #000;
        padding: 5px 20px;
    }

    .logo {
        margin-top: 40px;
        margin-left: 30px;
    }

    .pri {
        margin-left: 590px;
        margin-top: -34px;
    }

    .tablecontainer {
        width: 99%;
        margin-left: 4px;
        margin-top: 6px;
    }
</style>

<body>
    <div class="container">
        <div class="wrapper">
            <div class="row">
                <div class="col-sm-12">
                    <div class="text-center mt-4">
                        <h2>Delivery Challan</h2>
                        
                    </div>
                </div>
            </div>
            <div class="tablecontainer">
                <div class="row mt-3">
                    <div class="col-sm-8">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">VIRAJ CERAMICS</h5>
                                <p class="card-text">87/6, Balapur, Fagna<br>
                                    Opp Hotel Sheetal, Parola Road<br>
                                    Dhule<br>
                                    GSTIN No.: 27ADAPJ5841K1ZG<br>
                                    CONT.: 9373943349/8285272727<br>
                                    Email: viraj_ceramics@yahoon.com<br></p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="col-sm-4 logo">
                            <img src="../assets/viraj_logo.png" alt="logo"
                                style="width:200px !important; height:200px !important;margin-top:-20px;">
                        </div>
                    </div>
                </div>
            </div>
            <div class="tablecontainer">
                <div class="row">
                    <div class="col-sm-12">
                        <?php $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <table class="table table-bordered">
                                <tbody>
                                    <tr style="1px solid black">
                                        <th colspan="2" style="border:1px solid black;">To,
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($data->client_name); ?>

                                        </th>
                                        <th colspan="2" style="border:1px solid black;">Mobile No
                                            :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($data->contact); ?></th>
                                        
                                    </tr>

                                    <tr>
                                        
                                        
                                        <th colspan="2" style="border:1px solid black;"> Challan No
                                            :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($data->id); ?> </th>
                                        
                                        <th colspan="2" style="border:1px solid black;">
                                            <!--Date: <?php echo e(\Carbon\Carbon::parse($data->created_at)->format('d-m-Y')); ?>-->
                                             Date: <?php echo e(\Carbon\Carbon::now()->format('d-m-Y')); ?>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th td colspan="7" style="border:1px solid black;"> Client Address
                                            :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span
                                                style="font-size:20px;"><?php echo e($data->client_addr); ?></span> </th>

                                    </tr>
                                    
                                    
                                </tbody>
                            </table>
                    </div>
                </div>
            </div>
            <div class="tablecontainer">
                <table class="table table-bordered">
                    <thead class="thead-dark">
                        <tr>
                            <th style="border:1px solid black;width:10%;">Sr.&nbsp;No</th>
                            <th style="border:1px solid black;width:15%">Size</th>
                            <th style="border:1px solid black;width:15%">Quality</th>

                            <th style="border:1px solid black;width:45%">Description&nbsp;of&nbsp;Goods</th>
                            <!--<th style="border:1px solid black;width:15%">Type</th>-->
                            
                            <th style="border:1px solid black;width:15%">Qty</th>
                            
                            
                            
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $tot_weight = 0;
                            $grandtotal = 0;
                            $count = 0;
                        ?>
                        <?php $__currentLoopData = $quotationItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $count++;
                                $cov = $value->coverage;
                                $totbox = $value->unit_send != null ? $value->unit_send : $value->box;
                                $calculate = round((float) $cov * (float) $totbox * (float) $value->rate);
                                $percent = ((float) $calculate * (float) $value->discount) / 100;

                                $p_name = '';
                            ?>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($prod->id == $value->product_id): ?>
                                    <?php
                                        $p_name = $prod->p_name;
                                        $type = $prod->type;
                                    ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td style="border:1px solid black;width:10%;font-size:20px !important;font-weight:600 !important;"><?php echo e($count); ?></td>
                                <td style="border:1px solid black;width:15%;font-size:20px !important;font-weight:600 !important;"><?php echo e($value->size); ?></td>
                                <td style="border:1px solid black;width:10%;font-size:20px !important;font-weight:600 !important;"><?php echo e($value->quality); ?></td>

                                <td style="border:1px solid black;width:45%;font-size:20px !important;font-weight:600 !important;"><?php echo e($p_name); ?></td>
                                <!--<td style="border:1px solid black;width:10%;"><?php echo e($type); ?></td>-->
                                
                                <?php
                                    $tot_weight += $value->total_weight;
                                    $grandtotal += $calculate - $percent;
                                ?>
                                <td style="border:1px solid black;width:15%;font-size:20px !important;font-weight:600 !important;">
                                    <?php echo e($value->unit_send != null ? $value->unit_send : $value->box); ?></td>
                                
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <tr>
                            <td colspan="4">Please check the tiles at the time of delivery .
                                While fitting tiles if any defect is found, please contact us.
                                We will not be responsible after the tiles are fitted.

                            </td>
                            <td colspan="3"><br><br><br>for, Viraj Ceramics</td>
                        </tr>
                        <tr rowspan="2">
                            <th colspan="3">Tempo No :&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($data->tempo_no); ?> </th>
                            <th colspan="2">Fright to Pay :&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($data->freight_charges); ?>

                            </th>
                            
                        </tr>
                    </tbody>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
            </div>
        </div>
        <script>
            let p = document.getElementById('weightD').value;
            document.getElementById('totalWeight').innerHTML = p / 1000;
        </script>
        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"
            integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous">
        </script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.7/dist/umd/popper.min.js"
            integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous">
        </script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/js/bootstrap.min.js"
            integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous">
        </script>
</body>

</html>
<?php /**PATH /home/virajceramics/public_html/dev/resources/views/admin/deliveryChallan.blade.php ENDPATH**/ ?>