<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('cat_id');
            $table->foreign('cat_id')->references('id')->on('categories')->onDelete('cascade');
            $table->unsignedBigInteger('quality_id');
            $table->foreign('quality_id')->references('id')->on('qualities')->onDelete('cascade');
            $table->string('p_name')->nullable();
            $table->string('p_image')->nullable();
            $table->string('p_size')->nullable();
            $table->string('p_quantity')->nullable();
            $table->string('p_pcinbox')->nullable();
            $table->string('p_rate')->nullable();
            $table->string('video_link')->nullable();
            $table->enum('availability', ['AVAILABLE', 'NOT-AVAILABLE'])->nullable();
            $table->json('godown')->nullable();
            $table->string('product_code')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
