<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Quotation</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css"
        integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
</head>
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    html {
        margin: 10px;
        margin-top: 20px;
    }


    h2 {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        margin: 10px;
    }

    body {
        width: 100%;
        height: 100%;
        margin: 0 auto;
    }

    .wrapper {
        margin: 10px auto;
        padding: 20px 4px;
    }

    .delivery-challan {
        color: #212529;
        font-size: 20px;
    }

    .text-center {
        text-align: center;
    }

    .card {
        padding: 1rem;
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-radius: 0.25rem;
        text-align: left;
        font-weight: bold;
    }

    .card-title {
        color: #212529;
        font-size: 18px;
    }

    .headerDiv .logo {
        width: 40%;
        text-align: center;
    }

    .card-text {
        font-size: 16px;
        color: rgb(33, 37, 41);

    }

    .bank-details {
        padding: 8px;
        font-weight: bold;
    }

    table {
        width: 100%;
        text-align: center;
    }

    table,
    th,
    td {
        border: 1px solid rgba(0, 0, 0, 0.125);
        border-collapse: collapse;
        padding: 10px 0px;
        word-wrap: break-word;

    }

    .terms {
        text-align: left;
        border-radius: 0.25rem;
    }

    .terms td {
        padding: 8px;
    }

    .footer td {
        padding: 10px;
    }

    .dark-border {
        border: 1px solid rgb(0, 0, 0);
    }

    .remove-border {
        border: none;
    }

    .p-2 {
        padding: 8px 0.2rem !important;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        text-align: center;
        margin: 20px 0;
    }

    table th,
    table td {
        border: 1px solid #000;
        padding: 8px;
        word-break: break-word;
    }

    .text-center {
        text-align: center;
    }

    .logo img {
        max-width: 200px;
        height: auto;
    }
</style>

<body>
    <div class="wrapper">
        <div class="text-center">
            <p class="card-text" style="width: 90%;margin: auto;font-weight: 600; margin-top: 10px; font-size: 14px">
            <div>
                {{--  <div class=" logo">
                    <img src="{{ asset('assets/viraj_logo.png') }}" alt="logo"
                        style="width:200px !important; height:200px !important;margin-top:-20px;">
                </div>  --}}
                <div class="logo">
                    <img src="{{ public_path('assets/viraj_logo.png') }}" alt="logo"
                        style="width:200px !important; height:200px !important; margin-top:-40px;">
                </div>
            </div>
            <p class="card-text" style="font-weight: bold;font-size:14px; margin-top:-30px;">87/6, Balapur, Fagna
                Opp Hotel Sheetal, Parola Road,
                Dhule<br>
                GSTIN No.: 27ADAPJ5841K1ZG<br>
                CONT.: 82852 72727<br>
                Email: viraj_ceramics@yahoon.com<br></p>
            </p>
        </div>
        <hr style="width: 96%;margin-left: auto;margin-right: auto;color: rgba(0, 0, 0, 0.514);
    border: solid;">
        <div class="text-center" style="margin-top:-25px;">
            <h2><u style=color:black;><i>Quotation</i></u></h2>
        </div>
        <table style="border: none; margin: 0 auto; width: 98%" class="text-center">
            <tbody>
                <tr>
                    <th style="text-align: left; border: none">To,</th>
                    <th style="border: none; text-align: right;">
                        {{ $quotation->created_at->toDateString() }}
                    </th>

                </tr>
                <tr style="margin-top:-25px;">
                    <th style="text-align: left; border: none;">
                        {{ $quotation->client_name }}&nbsp;&nbsp;({{ $quotation->contact }})<br>
                        {{--  {{ $quotation->attended_by }}({{ $quotation->attendee_contact }})  --}}
                    </th>
                    {{--  <th style="text-align: left; border: none;">Attended By
                        :&nbsp;&nbsp;&nbsp;{{ $quotation->attended_by }}({{ $quotation->attendee_contact }})
                    </th>  --}}
                </tr>
                {{--  <tr style="margin-top:-25px;">
                    <th style="text-align: left; border: none;margin-top:-25px;">Attended By
                        :&nbsp;&nbsp;&nbsp;{{ $quotation->attended_by }}({{ $quotation->attendee_contact }})
                    </th>
                </tr>  --}}
            </tbody>
        </table>

        <p style="font-size: 16px;color: rgb(33, 37, 41); margin: 0 auto;padding:0px 15px 0 15px;margin-top:-15px;">
            This is with reference to our discussion with you regarding your requirement; here we
            quote our best price for your prestigious project as below:
        </p>

        <div style="margin-top: -20px;width:96%;padding:0 15px;">
            <table class="table table-bordered">
                <thead class="text-center">
                    <tr>
                        <th style="border:1px solid gray; width: 20px" class="p-2">SrNo</th>
                        <th width="10%" style="border:1px solid gray;">{{ $type == 'code' ? 'Code' : 'Name' }}
                        </th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">Size</th>
                        <th style="border:1px solid gray; width: 6%" class="p-2">Image</th>
                        {{--  <th style="border:1px solid gray; width: 8%" class="p-2">Quality</th>  --}}
                        <th style="border:1px solid gray; width: 7%" class="p-2">Type</th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">MRP Rate Per Sqft</th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">Final Rate Per Sqft</th>
                        <th style="border:1px solid gray; width: 4%" class="p-2">Rate Per Box</th>
                        {{--  <th style="border:1px solid gray; width: 4%" class="p-2">Dis</th>  --}}
                        <th style="border:1px solid gray; width: 3%" class="p-2">Cov</th>
                        <th style="border:1px solid gray; width: 5%" class="p-2">Box</th>
                        <th style="border:1px solid gray; width: 7%" class="p-2">DisAmt</th>
                        {{--  <th style="border:1px solid gray; width: 10%" class="p-2">Area</th>  --}}
                        <th style="border:1px solid gray; width: 14%" class="p-2">Amount</th>
                    </tr>
                </thead>
                <tbody class="text-center" style="text-size:9px !important;">
                    @php
                        $tot_weight = 0;
                        $grandtotal = 0;
                        $count = 0;
                    @endphp
                    @foreach ($quotationItems as $value)
                        @php
                            $cov = $value->coverage != '' ? $value->coverage : 1;
                            $totbox = $value->unit_send != null ? $value->unit_send : $value->box;
                            $calculate = round((float) $cov * (float) $totbox * (float) $value->rate, 2);

                            $count++;
                            $p_name = '';
                            $p_image = '';
                            //$discountAmt = ($value->initial_rate - $value->rate) * $value->coverage * $value->box;
                            $discountAmt =
                                $value->initial_rate !== null
                                    ? ($value->initial_rate - $value->rate) * $value->coverage * $value->box
                                    : 0;
                        @endphp
                        @foreach ($products as $prod)
                            @if ($prod->id == $value->product_id)
                                @php
                                    $p_name = $type == 'code' ? $prod->id : $prod->p_name;
                                    $p_image = $prod->p_image;
                                    $p_type = $prod->type;
                                @endphp
                                <tr>
                                    <td style="border:1px solid gray; width: 5%" class="p-2">{{ $count }}</td>
                                    <td style="border:1px solid gray; width: 10%; font-size: 15px" class="p-2">
                                        {{ $p_name }}</td>
                                    <td style="border:1px solid gray; width: 5%" class="p-2">{{ $value->size }}</td>
                                    <td style="border:1px solid gray; width: 10%" class="p-2">
                                        @if (empty($p_image)||($p_image=='Null')||($p_image==''))
                                            <img src="{{ asset('assets/no_image.png') }}" width="80px"
                                                height="70px" style="padding-top: 15px;">
                                        @else
                                            <img src="{{ $prod->p_image }}" width="80px"
                                                height="70px" style="padding-top: 15px;">
                                        @endif
                                        {{--  <img height="30" width="30" class="img-thumbnail"
                                            src="{{ public_path($prod->p_image ? {{ $p_image }} : 'product_img/no_image.jpg') }}">  --}}
                                        {{--  <img height="30" width="30" class="img-thumbnail"
                                    src="{{ file_exists(public_path($p_image ? 'product_img/' . $p_image : 'product_img/no_image.jpg')) ? public_path($p_image ? 'product_img/' . $p_image : 'product_img/no_image.jpg') : public_path('product_img/no_image.jpg') }}">  --}}

                                    </td>
                                    {{--  <td style="border:1px solid gray; width: 5%" class="p-2">
                                        {{ Str::ucfirst(Str::lower($value->quality)) }}</td>  --}}
                                    <td style="border:1px solid gray; width: 10%; font-size: 15px" class="p-2">
                                        {{ $p_type }}</td>
                                    <td style="border:1px solid gray; width: 10%" class="p-2">
                                        {{ $value->initial_rate }}
                                    <td style="border:1px solid gray; width: 10%" class="p-2">{{ $value->rate }}
                                    <td style="border:1px solid gray; width: 10%" class="p-2">
                                        {{ $value->p_rate_p_box }}
                                    </td>
                                    <td style="border:1px solid gray; width: 10%" class="p-2">
                                        {{ $value->coverage }}
                                    </td>
                                    <td style="border:1px solid gray; width: 5%" class="p-2">
                                        {{ $value->unit_send != null ? $value->unit_send : $value->box }}</td>
                                    {{--  @if ($value->discount != 0)
                                        <td style="border:1px solid gray; width: 5%" class="p-2">
                                            {{ $value->discount }}
                                        </td>
                                    @else
                                        <td style="border:1px solid gray;">-</td>
                                    @endif  --}}
                                    {{--  @if ($value->discount != 0)  --}}
                                    <td style="border:1px solid gray; width: 5%" class="p-2">{{ $discountAmt }}
                                    </td>
                                    {{--  @else
                                        <td style="border:1px solid gray;">-</td>
                                    @endif  --}}

                                    {{--  <td style="border:1px solid gray; width: 10%" class="p-2">
                                        {{ $value->application_area }}</td>  --}}
                                    <td style="border:1px solid gray; width: 10%" class="p-2">
                                        {{ $value->total }}
                                    </td>
                                    @php
                                        $tot_weight += $value->total_weight;
                                        //$grandtotal += $calculate - 0;
                                        $grandtotal += $value->total;
                                    @endphp
                                </tr>
                            @endif
                        @endforeach
                    @endforeach
                    <tr>
                        <th colspan="11" class="text-center" style="border:1px solid gray;">Total</th>
                        <td style="border:1px solid gray;">{{ round($grandtotal, 2) }}/-</td>
                    </tr>
                    @if ($quotation->discount !== null && $quotation->discount !== 0)
                        <tr>
                            <th colspan="11" class="text-center" style="border:1px solid gray;">Discount</th>
                            <td style="border:1px solid gray;">{{ $quotation->discount }}/-</td>
                        </tr>
                        <tr>
                            <th colspan="11" class="text-center" style="border:1px solid gray;">
                                Discounted&nbsp;Amount
                            </th>
                            <td style="border:1px solid gray;">{{ $quotation->discountedAmt }}/-</td>
                        </tr>
                    @endif
                    <tr>
                        <th colspan="11" class="text-center" style="border:1px solid gray;">Paidup&nbsp;Amount
                        </th>
                        <td style="border:1px solid gray;">{{ $quotation->total_paid }}/-</td>
                    </tr>
                    <tr>
                        <th colspan="11" class="text-center" style="border:1px solid gray;">DueAmount</th>
                        <td style="border:1px solid gray;">{{ $quotation->due_amount }}/-</td>
                    </tr>
                </tbody>
            </table>
            <p>Above rates are including GST @ 18%, Excluding unloading charge and this are Nashik
                warehouse rates.
            </p>
            <b>Payment Terms &nbsp;:</b>&nbsp;&nbsp;
            100% Advance<br>
            <b>Delivery Period &nbsp;:</b>&nbsp;&nbsp; 7 TO 8 Days from the date of order / dispatch
            schedule.<br>
            <b>Billing</b>

            GST Billing @ 18%<br>
            <b>Validity Of Price :</b>&nbsp;&nbsp; 30 Days from Date of Quotation<br><br>
            <h5 style="font-weight: 700;">BANK DETAILS:</h5>
            <b>BANK NAME:</b>&nbsp;&nbsp; HDFC BANK<br>
            <b>ACCOUNT NO. :</b>&nbsp;&nbsp; 50200037712596<br>
            <b>IFSC CODE :</b>&nbsp;&nbsp; HDFC0000637<br>
            <b>BRANCH :</b>&nbsp;&nbsp; DHULE <br><br>
            <b>BANK NAME:</b>&nbsp;&nbsp; THE HASTI CO-OP BANK LTD<br>
            <b>ACCOUNT NO. :</b>&nbsp;&nbsp; 007001100000021<br>
            <b>IFSC CODE :</b>&nbsp;&nbsp; HCBL0000107<br>
            <b>BRANCH :</b>&nbsp;&nbsp; DHULE <br>
            <p>
                We again express our gratitude for your esteemed organization and looking forward
                for a
                long and
                healthy business relationship. Assuring you of our best service all the
                times.<br><br>
                Thanking You
            </p>
            <b>VIRAJ CERAMICS<br>
                82852 72727<br>
        </div>
    </div>
</body>

</html>
