@extends('admin.layouts.master')
@section('content')
    <div class="container mt-4">
        <div class="row">
            <h4 style="text-center">Edit Payment</h4>
        </div>
        <div style="height: 600px; overflow: scroll;">
            <form action="{{ route('storePayment') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" id="q_id" name="q_id" value="{{ $quotation->id }}">
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Client&nbsp;Name :</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="clientName" id="clientName" class="form-control"
                                value="{{ $quotation->client_name }}" readonly>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Grand&nbsp;Total :</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="grand_total" id="grand_total" class="form-control"
                                value="{{ $quotation->grand_total }}" readonly>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Advance&nbsp;Payment
                                :</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="advance_pay" id="advance_pay" class="form-control"
                                value="{{ $quotation->advance_payment }}" readonly>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Paidup&nbsp;Amount
                                :</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="paidup" id="paidup" class="form-control"
                                value="{{ $quotation->total_paid }}" readonly>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Due&nbsp;Amount :</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="due_amount" id="due_amount" class="form-control"
                                value="{{ $quotation->due_amount }}" readonly>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Payment&nbsp;type :</label>
                        </div>
                        <div class="col-md-6">
                            <select id="payment_type" name="payment_type" class="form-control" required>
                                <option value="">~~SELECT~~</option>
                                <option value="Cheque">Cheque</option>
                                <option value="Cash">Cash</option>
                                <option value="Bank-Transfer">Bank&nbsp;Transfer</option>
                            </select>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Amount :</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="total_amount" id="total_amount" class="form-control" required>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Payment&nbsp;Date :</label>
                        </div>
                        <div class="col-md-6">
                            <input type="date" name="payment_date" id="date_field" class="form-control"
                                value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font: bold;color:black">Remark :</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="remark" id="remark" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="submit" class="btn btn-success">Submit</button>
                </div>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th style="width:10%;">Sr&nbsp;No</th>
                                <th style="width:14%;">Amount</th>
                                <th style="width:14%;">Type</th>
                                <th style="width:14%;">Payment&nbsp;Date</th>
                                <th style="width:14%;">Remark</th>
                                <th style="width:14%;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($quotation->paymentHistory as $data)
                                <tr>
                                    <td>{{ $data->id }}</td>
                                    <td>{{ $data->amount }}</td>
                                    <td>{{ $data->payment_type }}</td>
                                    <td>{{ $data->payment_date }}</td>
                                    <td>{{ $data->remark }}</td>
                                    <td>
                                        <a href="{{ route('deletePaymentData', $data->id) }}"
                                            onclick="return confirm('Are you sure you want to delete this Tips?');">
                                            <button type="button" class="btn btn-square btn-danger m-2"><i
                                                    class="fa fa-trash" title="Delete Quotation"></i></button>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </form>
        </div>
    </div>
@endsection
