<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Barcode</title>
</head>
<style>
    .container {
        margin: 0;
        padding: 0;
        display: flex;
    }

    .card {
        margin: 0;
        padding: 0;
        width: 240px;
        /* background-color: white;
        border: 1px solid gray;
        border-radius: 10px; */
    }

    .card-header {
        background-color: lightgray;
        border-bottom: 1px solid gray;
        padding: 10px;
    }

    .card-body {
        margin: 0;
        padding: 0;
        text-align: center;
    }

    .card-title {
        padding: 0;
        margin: 0;
        font-size: 16px;
    }

    .barData {
        font-size: 14px;
    }

    .barcodedata {
        display: flex;
        justify-content: center;
    }

    .tableData {
        padding: 0;
        margin: 0;
        display: flex;
        justify-content: center;
        font-size: 11px;
    }
</style>

<body>
    <div class="container">
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card" id="cardData">
                <div class="card-body">
                    <h3 class="card-title">Viraj Ceramics</h3>
                    <div class="barcodedata">
                        <?php echo DNS1D::getBarcodeSVG($data->product_code, 'C39', 0.8, 40); ?>

                    </div>
                    <table class="tableData">
                        <tr>
                            <td><?php echo Str::limit($data->p_name, 6, '.'); ?></td>
                            <td><?php echo Str::limit($data->p_size, 6, '.'); ?></td>
                            <?php $__currentLoopData = $quality; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->id == $data->quality_id): ?>
                                    <td><?php echo e($item->quality_name); ?></td>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </table>
                    
                </div>
            </div>
            <br>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</body>

</html>
<?php /**PATH /home/virajceramics/public_html/admin/resources/views/admin/barcode.blade.php ENDPATH**/ ?>